/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.FCL20;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.fcl.local.CraftingBlock;
import net.fexcraft.mod.fcl.local.CraftingEntity;
import net.fexcraft.mod.fcl.util.ClientPacketPlayer;
import net.fexcraft.mod.fcl.util.EntityUtil;
import net.fexcraft.mod.fcl.util.ExternalTextures;
import net.fexcraft.mod.fcl.util.FCLRenderTypes;
import net.fexcraft.mod.fcl.util.UIPacket;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.UniReg;
import net.fexcraft.mod.uni.impl.SWI;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.packet.PacketFile;
import net.fexcraft.mod.uni.packet.PacketTag;
import net.fexcraft.mod.uni.packet.PacketTagListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UniCon;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;
import org.slf4j.Logger;

@Mod(value="fcl")
public class FCL {
    public static final String MODID = "fcl";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)Registries.f_256798_, (String)"fcl");
    public static final RegistryObject<MenuType<UniCon>> UNIVERSAL = CONTAINERS.register("universal", () -> {
        try {
            return IForgeMenuType.create(UniCon::new);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    });
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("fcl", "channel")).clientAcceptedVersions(pro -> true).serverAcceptedVersions(pro -> true).networkProtocolVersion(() -> "fcl").simpleChannel();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"fcl");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"fcl");
    public static final DeferredRegister<BlockEntityType<?>> BLOCKENTS = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"fcl");
    public static final RegistryObject<Block> CRAFTING_BLOCK = BLOCKS.register("crafting", () -> new CraftingBlock());
    public static final RegistryObject<Item> CRAFTING_ITEM = ITEMS.register("crafting", () -> new BlockItem((Block)CRAFTING_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockEntityType<CraftingEntity>> CRAFTING_ENTITY = BLOCKENTS.register("crafting", () -> BlockEntityType.Builder.m_155273_(CraftingEntity::new, (Block[])new Block[]{(Block)CRAFTING_BLOCK.get()}).m_58966_(null));
    private static ConcurrentHashMap<String, TagKey<Item>> tagkeys = new ConcurrentHashMap();
    public static Optional<MinecraftServer> SERVER = Optional.empty();
    public static UniFCL CONFIG;

    public FCL() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FCL20.MAINDIR = FMLPaths.GAMEDIR.get().toFile();
        FCL20.init(!FMLEnvironment.production);
        if (FMLLoader.getDist().isClient()) {
            FCL20.initClient();
        }
        CONFIG = new UniFCL(FMLPaths.CONFIGDIR.get().toFile());
        UniStack.TAG_GETTER = key -> {
            ArrayList<StackWrapper> list = new ArrayList<StackWrapper>();
            if (!tagkeys.containsKey(key)) {
                tagkeys.put((String)key, (TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(key)));
            }
            ITag tags = ForgeRegistries.ITEMS.tags().getTag(tagkeys.get(key));
            for (Item item : tags) {
                list.add(UniStack.createStack(new ItemStack((ItemLike)item)));
            }
            return list;
        };
        EntityUtil.UI_OPENER = (player, ui, pos) -> {
            try {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Fexcraft Universal UI");
                    }

                    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                        return new UniCon(i, inventory, ui, pos, UniReg.getMenuJson(ui));
                    }
                }, buf -> {
                    buf.writeInt(ui.length());
                    buf.m_130070_(ui);
                    buf.writeInt(pos.x);
                    buf.writeInt(pos.y);
                    buf.writeInt(pos.z);
                    String str = JsonHandler.toString(UniReg.getMenuJson(ui), JsonHandler.PrintOption.FLAT);
                    buf.writeInt(str.length());
                    buf.m_130070_(str);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        UniFCL.registerFCLUI(this);
        FclRecipe.VALIDATE = comp -> {
            if (comp.tag) {
                if (comp.key == null) {
                    comp.key = ItemTags.create((ResourceLocation)new ResourceLocation(comp.id));
                }
                return ForgeRegistries.ITEMS.tags().getTag((TagKey)comp.key) != null;
            }
            return !comp.stack.empty();
        };
        FclRecipe.GET_TAG_AS_LIST = comp -> {
            ArrayList<StackWrapper> list = new ArrayList<StackWrapper>();
            if (comp.key == null) {
                comp.key = ItemTags.create((ResourceLocation)new ResourceLocation(comp.id));
            }
            ITag tags = ForgeRegistries.ITEMS.tags().getTag((TagKey)comp.key);
            for (Item item : tags) {
                list.add(UniStack.createStack(new ItemStack((ItemLike)item, comp.amount)));
            }
            return list;
        };
        MinecraftForge.EVENT_BUS.register((Object)this);
        ITEMS.register(bus);
        BLOCKS.register(bus);
        BLOCKENTS.register(bus);
        CONTAINERS.register(bus);
        bus.addListener(this::commonSetup);
    }

    public static void bindTex(IDL tex) {
        FCLRenderTypes.setCutout(tex);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        StackWrapper.EMPTY = SWI.parse(ItemStack.f_41583_);
        CHANNEL.registerMessage(1, UIPacket.class, (packet, buffer) -> buffer.m_130079_(packet.com()), buffer -> new UIPacket(buffer.m_130260_()), (packet, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> FCL.lambda$commonSetup$14((Supplier)context, packet));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        CHANNEL.registerMessage(2, PacketTag.class, (packet, buffer) -> {
            buffer.writeInt(packet.lis.length());
            buffer.m_130070_(packet.lis);
            buffer.m_130079_((CompoundTag)packet.com.local());
        }, buffer -> new PacketTag().fill(buffer.m_130136_(buffer.readInt()), TagCW.wrap(buffer.m_130260_())), (packet, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> FCL.lambda$commonSetup$18((Supplier)context, packet));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        CHANNEL.registerMessage(3, PacketFile.class, PacketFile::encode, buffer -> {
            PacketFile pkt = new PacketFile();
            pkt.decode((ByteBuf)buffer);
            return pkt;
        }, (packet, context) -> {
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> FCL.lambda$commonSetup$21((Supplier)context, packet));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
        ContainerInterface.SEND_TO_CLIENT = (com, player) -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player.entity.local()), (Object)new UIPacket((CompoundTag)com.local()));
        ContainerInterface.SEND_TO_SERVER = com -> CHANNEL.sendToServer((Object)new UIPacket((CompoundTag)com.local()));
        if (UniFCL.EXAMPLE_RECIPES) {
            FclRecipe.newBuilder("recipe.fcl.testing").add(new ItemStack((ItemLike)Blocks.f_50652_, 4)).output(new ItemStack((ItemLike)Blocks.f_50635_, 5)).register();
            FclRecipe.newBuilder("recipe.fcl.testing").add("minecraft:logs", 9).output(new ItemStack((ItemLike)Blocks.f_50325_, 1)).register();
        }
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        SERVER = Optional.empty();
    }

    @SubscribeEvent
    public void onCmdReg(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)MODID).executes(cmd -> {
            if (((CommandSourceStack)cmd.getSource()).m_230897_()) {
                UniEntity.getEntity(((CommandSourceStack)cmd.getSource()).m_230896_()).openUI(UniFCL.SELECT_CONFIG_CATEGORY, V3I.NULL);
            }
            return 0;
        }));
    }

    public static void sendServerFile(EntityW player, String lis, String loc, byte[] img) {
        if (player.isOnClient()) {
            CHANNEL.sendToServer((Object)new PacketFile().fill(lis, loc));
        } else {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player.local()), (Object)new PacketFile().fill(lis, loc, img));
        }
    }

    public static IDL requestServerFile(String lis, String loc) {
        CHANNEL.sendToServer((Object)new PacketFile().fill(lis, loc));
        return IDLManager.getIDLCached(loc);
    }

    public static void writeTag(ByteBuf buffer, TagCW com) {
        ((FriendlyByteBuf)buffer).m_130079_((CompoundTag)com.local());
    }

    public static TagCW readTag(ByteBuf buffer) {
        return TagCW.wrap(((FriendlyByteBuf)buffer).m_130260_());
    }

    private static /* synthetic */ void lambda$commonSetup$21(Supplier context, PacketFile packet) {
        if (((NetworkEvent.Context)context.get()).getDirection().getOriginationSide().isClient()) {
            try {
                EntityW player = UniEntity.getEntity(((NetworkEvent.Context)context.get()).getSender());
                if (!packet.lis.equals("def")) {
                    UniFCL.SFL_S.get(packet.lis).handle(packet.loc, null, player);
                    return;
                }
                byte[] tex = UniFCL.getServerFile(packet.loc);
                FCL.sendServerFile(player, packet.lis, packet.loc, tex);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (!packet.lis.equals("def")) {
                UniFCL.SFL_C.get(packet.lis).handle(packet.loc, packet.img, UniEntity.getEntity(ClientPacketPlayer.get()));
                return;
            }
            ExternalTextures.get(packet.loc, packet.img);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$commonSetup$18(Supplier context, PacketTag packet) {
        if (((NetworkEvent.Context)context.get()).getDirection().getOriginationSide().isClient()) {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            PacketTagListener cons = UniFCL.TAG_S.get(packet.lis);
            if (cons != null) {
                cons.handle(packet.com, UniEntity.getEntity(player));
            }
        } else {
            PacketTagListener cons = UniFCL.TAG_C.get(packet.lis);
            if (cons != null) {
                cons.handle(packet.com, UniEntity.getEntity(ClientPacketPlayer.get()));
            }
        }
    }

    private static /* synthetic */ void lambda$commonSetup$14(Supplier context, UIPacket packet) {
        if (((NetworkEvent.Context)context.get()).getDirection().getOriginationSide().isClient()) {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            ((UniCon)player.f_36096_).onPacket(packet.com(), false);
        } else {
            ((UniCon)ClientPacketPlayer.get().f_36096_).onPacket(packet.com(), true);
        }
    }
}

