/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.util.EntityUtil;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class EntityWI
implements EntityW {
    protected Entity entity;
    protected WorldW world;
    protected V3D prev = new V3D();
    protected V3D pos = new V3D();

    public EntityWI(Entity iah) {
        this.entity = iah;
        this.world = WrapperHolder.getWorld(this.entity.m_9236_());
    }

    @Override
    public boolean isOnClient() {
        return this.entity.m_9236_().f_46443_;
    }

    @Override
    public int getId() {
        return this.entity.m_19879_();
    }

    @Override
    public WorldW getWorld() {
        if (this.entity.m_9236_() != this.world.direct()) {
            this.world = WrapperHolder.getWorld(this.entity.m_9236_());
        }
        return this.world;
    }

    @Override
    public boolean isPlayer() {
        return this.entity instanceof Player;
    }

    @Override
    public boolean isAnimal() {
        return this.entity instanceof Animal;
    }

    @Override
    public boolean isHostile() {
        return this.entity instanceof Mob;
    }

    @Override
    public boolean isLiving() {
        return this.entity instanceof LivingEntity;
    }

    @Override
    public boolean isRiding() {
        return this.entity.m_20159_();
    }

    @Override
    public String getRegName() {
        return BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_()).toString();
    }

    @Override
    public <E> E local() {
        return (E)this.entity;
    }

    @Override
    public Object direct() {
        return this.entity;
    }

    @Override
    public V3D getPos() {
        this.pos.x = this.entity.m_20182_().f_82479_;
        this.pos.y = this.entity.m_20182_().f_82480_;
        this.pos.z = this.entity.m_20182_().f_82481_;
        return this.pos;
    }

    @Override
    public void setPos(V3D pos) {
        this.entity.m_6034_(pos.x, pos.y, pos.z);
    }

    @Override
    public V3D getPrevPos() {
        this.prev.x = this.entity.f_19790_;
        this.prev.y = this.entity.f_19791_;
        this.prev.z = this.entity.f_19792_;
        return this.prev;
    }

    @Override
    public void setPrevPos(V3D pos) {
        this.entity.f_19790_ = pos.x;
        this.entity.f_19791_ = pos.y;
        this.entity.f_19792_ = pos.z;
    }

    @Override
    public V3I getV3I() {
        return new V3I((int)this.entity.m_20182_().f_82479_, (int)this.entity.m_20182_().f_82480_, (int)this.entity.m_20182_().f_82481_);
    }

    @Override
    public void decreaseXZMotion(double x) {
    }

    @Override
    public void setYawPitch(float oyaw, float opitch, float yaw, float pitch) {
    }

    @Override
    public void openUI(String id, V3I pos) {
        EntityUtil.UI_OPENER.open((Player)this.entity, id, pos);
    }

    @Override
    public void openUI(UIKey key, V3I pos) {
        this.openUI(key.key, pos);
    }

    @Override
    public String getName() {
        return this.entity.m_7755_().getString();
    }

    @Override
    public void drop(StackWrapper stack, float height) {
        this.entity.m_5552_((ItemStack)stack.local(), height);
    }

    @Override
    public boolean isCreative() {
        return ((Player)this.entity).m_7500_();
    }

    @Override
    public UUID getUUID() {
        return this.entity instanceof Player ? ((Player)this.entity).m_36316_().getId() : this.entity.m_20148_();
    }

    @Override
    public StackWrapper getHeldItem(boolean main) {
        return UniStack.getStack(((Player)this.entity).m_21120_(main ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
    }

    @Override
    public void closeUI() {
        ((Player)this.entity).m_6915_();
    }

    @Override
    public int getInventorySize() {
        return ((Player)this.entity).m_150109_().m_6643_();
    }

    @Override
    public StackWrapper getStackAt(int idx) {
        return UniStack.getStack(((Player)this.entity).m_150109_().m_8020_(idx));
    }

    @Override
    public void addStack(StackWrapper stack) {
        ((Player)this.entity).m_150109_().m_36054_((ItemStack)stack.local());
    }

    @Override
    public void send(String s) {
        this.entity.m_213846_((Component)Component.m_237115_((String)s));
    }

    @Override
    public void send(String str, Object ... args) {
        this.entity.m_213846_((Component)Component.m_237110_((String)str, (Object[])args));
    }

    @Override
    public void sendLink(String str) {
        if (!(this.entity instanceof ServerPlayer)) {
            return;
        }
        this.entity.m_213846_((Component)Component.m_237113_((String)str).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, str)).m_131162_(Boolean.valueOf(true))));
    }

    @Override
    public void bar(String s) {
        ((Player)this.entity).m_5661_((Component)Component.m_237115_((String)s), true);
    }

    @Override
    public void bar(String str, Object ... args) {
        ((Player)this.entity).m_5661_((Component)Component.m_237110_((String)str, (Object[])args), true);
    }

    @Override
    public void dismount(V3D pos) {
        this.entity.m_19877_();
        this.entity.m_6021_(pos.x, pos.y, pos.z);
    }

    @Override
    public boolean inSimRange() {
        if (this.entity.m_9236_().f_46443_) {
            return true;
        }
        return ((ServerChunkCache)this.entity.m_9236_().m_7726_()).f_8325_.m_143145_().m_183913_(this.entity.m_146902_().m_45588_());
    }

    @Override
    public int getTicks() {
        return this.entity.f_19797_;
    }

    @Override
    public int pushTicks() {
        return this.entity.f_19797_++;
    }

    @Override
    public EntityW getVehicle() {
        return UniEntity.getEntityN(this.entity.m_20202_());
    }

    @Override
    public Object getVehicleDirect() {
        return this.entity.m_20202_();
    }

    @Override
    public void setLeash(EntityW player, boolean attach) {
        if (!(this.entity instanceof Mob)) {
            return;
        }
        Mob ent = (Mob)this.entity;
        if (attach) {
            ent.m_21463_((Entity)player.local(), true);
        } else {
            ent.m_21455_(true, !player.isCreative());
        }
    }

    @Override
    public EntityW getLeash() {
        if (!(this.entity instanceof Mob)) {
            return null;
        }
        Mob ent = (Mob)this.entity;
        return UniEntity.getEntityN(ent.m_21524_());
    }

    @Override
    public void move(V3D move) {
        this.entity.m_6478_(MoverType.SELF, new Vec3(move.x, move.y, move.z));
    }

    @Override
    public V3D getEyeVec() {
        return new V3D(this.entity.m_146892_().f_82479_, this.entity.m_146892_().f_82480_, this.entity.m_146892_().f_82481_);
    }

    @Override
    public V3D getLookVec() {
        return new V3D(this.entity.m_20154_().f_82479_, this.entity.m_20154_().f_82480_, this.entity.m_20154_().f_82481_);
    }

    @Override
    public boolean isShiftDown() {
        return this.entity.m_6144_();
    }

    @Override
    public void playSound(Object event, float volume, float pitch) {
        this.entity.m_5496_((SoundEvent)event, volume, pitch);
    }

    @Override
    public void remove() {
        this.entity.m_146870_();
    }

    @Override
    public boolean isRemoved() {
        return this.entity.m_213877_();
    }

    @Override
    public void onPacket(EntityW player, TagCW packet) {
    }

    @Override
    public void setOnGround(boolean bool) {
        this.entity.m_6853_(bool);
    }

    @Override
    public List<StackWrapper> copyInventory() {
        if (!this.isPlayer()) {
            return Collections.emptyList();
        }
        ArrayList<StackWrapper> stacks = new ArrayList<StackWrapper>();
        for (ItemStack stack : ((Player)this.entity).m_150109_().f_35974_) {
            if (stack.m_41619_()) continue;
            stacks.add(UniStack.createStack(stack.m_41777_()));
        }
        return stacks;
    }

    @Override
    public void mount(EntityW veh) {
        this.entity.m_7998_((Entity)veh.local(), true);
    }

    @FunctionalInterface
    public static interface UIOpen {
        public void open(Player var1, String var2, V3I var3);
    }
}

