/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Renderer120
extends ModelRendererTurbo.Renderer {
    public static final Vector3f AY = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f AX = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f AZ = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f NULLVEC = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vec3f DEFCOLOR = new Vec3f(1.0f, 1.0f, 1.0f);
    private static Vec3f color = new Vec3f(1.0f, 1.0f, 1.0f);
    public static PoseStack pose;
    private static MultiBufferSource buffer;
    private static VertexConsumer cons;
    protected static RenderType rentype;
    protected static int overlay;
    public static int light;

    public static void setColor(RGB col) {
        float[] arr = col.toFloatArray();
        Renderer120.color.x = arr[0];
        Renderer120.color.y = arr[1];
        Renderer120.color.z = arr[2];
    }

    public static void setColor(Vec3f col) {
        color.copy(col);
    }

    public static void resetColor() {
        Renderer120.color.z = 1.0f;
        Renderer120.color.y = 1.0f;
        Renderer120.color.x = 1.0f;
    }

    public static void rotateDeg(float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(Static.toRadians(by), (Vector3fc)axe));
    }

    public static void rotateRad(float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(by, (Vector3fc)axe));
    }

    public static void rotateDeg(PoseStack pose, float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(Static.toRadians(by), (Vector3fc)axe));
    }

    public static void rotateRad(PoseStack pose, float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(by, (Vector3fc)axe));
    }

    public static void pushPose() {
        pose.m_85836_();
    }

    public static void popPose() {
        pose.m_85849_();
    }

    public static RenderType rentype() {
        return rentype;
    }

    @Override
    public void render(ModelRendererTurbo turbo, float scale) {
        if (!turbo.showModel) {
            return;
        }
        pose.m_85836_();
        pose.m_252880_(turbo.rotationPointX * scale, turbo.rotationPointY * scale, turbo.rotationPointZ * scale);
        if (turbo.rotationAngleX != 0.0f || turbo.rotationAngleY != 0.0f || turbo.rotationAngleZ != 0.0f) {
            pose.m_252781_(new Quaternionf().rotateAxis(Static.toRadians(turbo.rotationAngleY), (Vector3fc)AY).rotateAxis(Static.toRadians(turbo.rotationAngleX), (Vector3fc)AX).rotateAxis(Static.toRadians(turbo.rotationAngleZ), (Vector3fc)AZ));
        }
        if (buffer != null) {
            cons = buffer.m_6299_(rentype);
        }
        Matrix4f verma = pose.m_85850_().m_252922_();
        Matrix3f norma = pose.m_85850_().m_252943_();
        for (TexturedPolygon poli : turbo.getFaces()) {
            if (rentype.m_173186_() == VertexFormat.Mode.QUADS) {
                for (TexturedVertex vert : poli.getVertices()) {
                    this.fillVert(poli, verma, norma, vert, scale);
                }
                if (poli.getVertices().length >= 4) continue;
                this.fillVert(poli, verma, norma, poli.getVertices()[2], scale);
                continue;
            }
            if (poli.getVertices().length == 4) {
                this.fillVert(poli, verma, norma, poli.getVertices()[0], scale);
                this.fillVert(poli, verma, norma, poli.getVertices()[1], scale);
                this.fillVert(poli, verma, norma, poli.getVertices()[2], scale);
                this.fillVert(poli, verma, norma, poli.getVertices()[0], scale);
                this.fillVert(poli, verma, norma, poli.getVertices()[2], scale);
                this.fillVert(poli, verma, norma, poli.getVertices()[3], scale);
                continue;
            }
            for (TexturedVertex vert : poli.getVertices()) {
                this.fillVert(poli, verma, norma, vert, scale);
            }
        }
        pose.m_85849_();
    }

    private void fillVert(TexturedPolygon poly, Matrix4f verma, Matrix3f norma, TexturedVertex vert, float scale) {
        Vector4f vec = verma.transform(new Vector4f(vert.vector.x * scale, vert.vector.y * scale, vert.vector.z * scale, 1.0f));
        if (poly.getNormals().length == 0) {
            poly.genIfMissingNormals();
        }
        Vector3f norm = norma.transform(new Vector3f(poly.getNormals()[0], poly.getNormals()[1], poly.getNormals()[2]));
        cons.m_5954_(vec.x, vec.y, vec.z, Renderer120.color.x, Renderer120.color.y, Renderer120.color.z, 1.0f, vert.textureX, vert.textureY, overlay, light, norm.x, norm.y, norm.z);
    }

    public static void set(PoseStack ps, MultiBufferSource mbs, int lgt, int ol) {
        pose = ps;
        buffer = mbs;
        cons = null;
        light = lgt;
        overlay = ol;
    }

    public static void set(PoseStack ps, MultiBufferSource mbs, int lgt) {
        pose = ps;
        buffer = mbs;
        cons = null;
        light = lgt;
        overlay = OverlayTexture.f_118083_;
    }

    public static void set(PoseStack ps, VertexConsumer con, int lgt, int ol) {
        pose = ps;
        buffer = null;
        cons = con;
        light = lgt;
        overlay = ol;
    }

    public static void set(PoseStack ps, VertexConsumer con, int lgt) {
        pose = ps;
        buffer = null;
        cons = con;
        light = lgt;
        overlay = OverlayTexture.f_118083_;
    }

    static {
        overlay = OverlayTexture.f_118083_;
    }
}

