/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.tag;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.tag.TagType;

public interface TagCW {
    public static final Supplier<TagCW>[] SUPPLIER = new Supplier[1];
    public static final Function<Object, TagCW>[] WRAPPER = new Function[1];

    public String getString(String var1);

    public float getFloat(String var1);

    public double getDouble(String var1);

    public int getInteger(String var1);

    public long getLong(String var1);

    public boolean getBoolean(String var1);

    public byte getByte(String var1);

    public TagCW getCompound(String var1);

    public TagLW getList(String var1);

    default public V3D getV3D(String key) {
        if (!this.has(key)) {
            return new V3D();
        }
        TagLW list = this.getList(key);
        return new V3D(list.getDouble(0), list.getDouble(1), list.getDouble(2));
    }

    public V3I getV3I(String var1);

    public int[] getIntArray(String var1);

    public byte[] getByteArray(String var1);

    public boolean has(String var1);

    public void set(String var1, String var2);

    public void set(String var1, float var2);

    public void set(String var1, double var2);

    public void set(String var1, int var2);

    public void set(String var1, long var2);

    public void set(String var1, boolean var2);

    public void set(String var1, TagCW var2);

    public void set(String var1, TagLW var2);

    public void set(String var1, int[] var2);

    public void set(String var1, byte[] var2);

    default public void set(String key, V3D vec) {
        TagLW list = TagLW.create();
        list.add(vec.x);
        list.add(vec.y);
        list.add(vec.z);
        this.set(key, list);
    }

    public void set(String var1, V3I var2, boolean var3);

    default public void set(String key, V3I vec) {
        this.set(key, vec, false);
    }

    public int size();

    public static TagCW create() {
        return SUPPLIER[0].get();
    }

    public static TagCW wrap(Object com) {
        if (com instanceof TagCW) {
            return (TagCW)com;
        }
        return WRAPPER[0].apply(com);
    }

    public <T> T local();

    public Object direct();

    public boolean empty();

    public Collection<String> keys();

    public TagCW copy();

    public void rem(String var1);

    public TagType getType(String var1);
}

