/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl.gen;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Material;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;

public class FRLObjParser {
    private boolean uv = true;
    private boolean normals = true;
    private boolean flip_f;
    private boolean flip_u;
    private boolean flip_v;
    private InputStream stream;
    private String id;

    public FRLObjParser(String uid, InputStream stream) {
        this.stream = stream;
        this.id = uid;
    }

    public FRLObjParser uv(boolean bool) {
        this.uv = !bool;
        return this;
    }

    public FRLObjParser normals(boolean bool) {
        this.normals = bool;
        return this;
    }

    public FRLObjParser flipFaces(boolean bool) {
        this.flip_f = bool;
        return this;
    }

    public FRLObjParser flipUV(boolean f_u, boolean f_v) {
        this.flip_u = f_u;
        this.flip_v = f_v;
        return this;
    }

    public Map<String, ArrayList<Polyhedron>> parse() {
        LinkedHashMap<String, ArrayList<Polyhedron>> polygons = new LinkedHashMap<String, ArrayList<Polyhedron>>();
        ArrayList<Vertex> raw_verts = new ArrayList<Vertex>();
        ArrayList<float[]> raw_uvs = new ArrayList<float[]>();
        ArrayList<float[]> raw_normals = new ArrayList<float[]>();
        LinkedHashMap faces = new LinkedHashMap();
        Material mat = Material.NONE;
        String s = null;
        String group = null;
        boolean norm = false;
        boolean uvb = false;
        int line = 0;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.stream, "UTF-8"));
            while ((s = in.readLine()) != null) {
                ++line;
                if ((s = s.trim()).length() == 0 || s.startsWith("#")) continue;
                if (s.startsWith("o ") || s.startsWith("g ")) {
                    group = s.substring(s.indexOf(" ") + 1).trim();
                    if (!polygons.containsKey(group)) {
                        polygons.put(group, new ArrayList());
                    }
                    if (!faces.containsKey(group)) {
                        faces.put(group, new LinkedHashMap());
                    }
                    if (((Map)faces.get(group)).containsKey(mat)) continue;
                    ((Map)faces.get(group)).put(mat, new ArrayList());
                    continue;
                }
                if (s.startsWith("v")) {
                    String[] ss = s.substring(s.indexOf(" ") + 1).trim().split(" ");
                    if (s.startsWith("v ")) {
                        if (ss.length < 3) continue;
                        raw_verts.add(new Vertex(this.p(ss[0]), this.p(ss[1]), this.p(ss[2])));
                        continue;
                    }
                    if (s.startsWith("vt ")) {
                        if (!this.uv || ss.length < 2) continue;
                        float u = this.p(ss[0]);
                        float v = this.p(ss[1]);
                        if (this.flip_u) {
                            u = -u + 1.0f;
                        }
                        if (this.flip_v) {
                            v = -v + 1.0f;
                        }
                        raw_uvs.add(new float[]{u, v});
                        continue;
                    }
                    if (!s.startsWith("vn ") || !this.normals || ss.length < 3) continue;
                    raw_normals.add(new float[]{this.p(ss[0]), this.p(ss[2]), this.p(ss[1])});
                    continue;
                }
                if (s.startsWith("usemtl")) {
                    mat = Material.get(this.id + "?" + s.substring(s.indexOf(" ") + 1), true);
                    if (((Map)faces.get(group)).containsKey(mat)) continue;
                    ((Map)faces.get(group)).put(mat, new ArrayList());
                    continue;
                }
                if (!s.startsWith("f ")) continue;
                ((ArrayList)((Map)faces.get(group)).get(mat)).add(s.substring(s.indexOf(" ") + 1).trim().split(" "));
            }
            in.close();
            for (Map.Entry entry : faces.entrySet()) {
                for (Map.Entry metry : ((Map)entry.getValue()).entrySet()) {
                    Polyhedron hedron = new Polyhedron();
                    ((GLO)hedron.glObj).material = (Material)metry.getKey();
                    for (String[] as : (ArrayList)metry.getValue()) {
                        int i;
                        ArrayList<Vertex> verts = new ArrayList<Vertex>();
                        ArrayList<float[]> norms = new ArrayList<float[]>();
                        ArrayList<float[]> uvs = new ArrayList<float[]>();
                        for (i = 0; i < as.length; ++i) {
                            if (as[i].contains("/")) {
                                String[] fs;
                                if (as[i].contains("//")) {
                                    if (i == 0) {
                                        uvb = false;
                                        norm = this.normals;
                                    }
                                    fs = as[i].split("//");
                                    verts.add((Vertex)raw_verts.get(this.pi(fs[0])));
                                    if (!norm) continue;
                                    norms.add((float[])raw_normals.get(this.pi(fs[1])));
                                    continue;
                                }
                                fs = as[i].split("/");
                                if (i == 0) {
                                    uvb = this.uv;
                                    norm = this.normals && fs.length > 2;
                                }
                                verts.add((Vertex)raw_verts.get(this.pi(fs[0])));
                                if (uvb) {
                                    uvs.add((float[])raw_uvs.get(this.pi(fs[1])));
                                }
                                if (!norm) continue;
                                norms.add((float[])raw_normals.get(this.pi(fs[2])));
                                continue;
                            }
                            if (i == 0) {
                                uvb = false;
                                norm = false;
                            }
                            verts.add((Vertex)raw_verts.get(this.pi(as[i])));
                        }
                        if (uvb) {
                            for (i = 0; i < uvs.size(); ++i) {
                                float[] uva = (float[])uvs.get(i);
                                verts.set(i, new Vertex(verts.get(i)).uv(uva[0], uva[1]));
                            }
                        }
                        Polygon poly = new Polygon(verts);
                        if (norm) {
                            for (int i2 = 0; i2 < norms.size() && i2 < poly.vertices.length; ++i2) {
                                float[] fl = (float[])norms.get(i2);
                                poly.vertices[i2].norm(new Vec3f(fl[0], fl[1], fl[2]));
                            }
                        }
                        if (this.flip_f) {
                            poly.flip();
                        }
                        hedron.polygons.add(poly);
                    }
                    ((ArrayList)polygons.get(entry.getKey())).add(hedron);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception on line " + line + "; " + s + " ; " + group + "; " + e.getMessage());
            e.printStackTrace();
        }
        return polygons;
    }

    private float p(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private int pi(String string) {
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

