/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.impl;

import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniFluidTank;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class UniFluidTank20
extends UniFluidTank {
    private FluidTank tank;

    public UniFluidTank20(int capacity) {
        this.tank = new FluidTank(capacity);
    }

    @Override
    public int capacity() {
        return this.tank.getCapacity();
    }

    @Override
    public TagCW save() {
        TagCW tag = TagCW.create();
        this.tank.writeToNBT((CompoundTag)tag.local());
        return tag;
    }

    @Override
    public void load(TagCW com) {
        this.tank.readFromNBT((CompoundTag)com.local());
    }

    @Override
    public <T> T local() {
        return (T)this.tank;
    }

    @Override
    public int amount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public void amount(String type, int am) {
        this.clear();
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(type));
        if (fluid == null) {
            return;
        }
        this.tank.fill(new FluidStack(fluid, am), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void drain(int am, boolean con) {
        this.tank.drain(am, con ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
    }

    @Override
    public void fill(int am, boolean con) {
        FluidStack stack = this.tank.getFluid().copy();
        stack.setAmount(am);
        this.tank.fill(stack, con ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
    }

    @Override
    public String getFluid() {
        if (this.tank.getFluid().getFluid() == null) {
            return "null";
        }
        return this.getFluidTypeId(this.tank.getFluid().getFluid().getFluidType());
    }

    public String getFluidTypeId(FluidType type) {
        return ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)type).m_135815_();
    }

    @Override
    public String getFluidFromStack(StackWrapper sw) {
        ItemStack stack = (ItemStack)sw.local();
        if (!stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return null;
        }
        IFluidHandlerItem item = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().get();
        if (item.getTanks() > 0 && item.getFluidInTank(0).getFluid() != null) {
            return this.getFluidTypeId(item.getFluidInTank(0).getFluid().getFluidType());
        }
        return null;
    }

    @Override
    public Pair<StackWrapper, Boolean> drainFrom(StackWrapper stack, int amount) {
        if (stack.empty() || !((ItemStack)stack.direct()).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return Pair.of((Object)stack, (Object)false);
        }
        IFluidHandlerItem item = (IFluidHandlerItem)((ItemStack)stack.direct()).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().get();
        if (item.getTanks() > 0 && item.getFluidInTank(0).getFluid() != null && item.getFluidInTank(0).getAmount() > 0) {
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)((ItemStack)stack.local()), (IFluidHandler)this.tank, (int)amount, null, (boolean)true);
            return Pair.of((Object)(result.getResult() == null ? StackWrapper.EMPTY : UniStack.getStack(result.getResult())), (Object)result.success);
        }
        return Pair.of((Object)stack, (Object)false);
    }

    @Override
    public void clear() {
        if (this.tank.getFluidAmount() > 0) {
            this.tank.drain(this.tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

