/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.impl;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fcl.FCL20;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.world.level.storage.LevelResource;

public class WrapperHolderImpl
extends WrapperHolder {
    private static final ConcurrentHashMap<String, LevelResource> LVLRES = new ConcurrentHashMap();
    private V3I vpos = new V3I();
    private WorldW client;

    @Override
    protected boolean isSinglePlayer0() {
        return FCL.SERVER.isPresent() && FCL.SERVER.get().m_129792_();
    }

    @Override
    public <S> S getServer0() {
        return (S)FCL.SERVER.orElseGet(null);
    }

    @Override
    protected boolean isOp0(EntityW entity, int lvl) {
        if (FCL.SERVER.isEmpty()) {
            return false;
        }
        MinecraftServer server = FCL.SERVER.get();
        ServerOpListEntry entry = (ServerOpListEntry)server.m_6846_().m_11307_().m_11388_((Object)((ServerPlayer)entity.direct()).m_36316_());
        return entry != null && entry.m_11363_() >= lvl;
    }

    @Override
    protected EntityW getPlayer0(UUID uuid) {
        if (FCL.SERVER.isEmpty()) {
            return null;
        }
        ServerPlayer player = FCL.SERVER.get().m_6846_().m_11259_(uuid);
        return player == null ? null : UniEntity.getEntity(player);
    }

    @Override
    protected List<UniEntity> getPlayers0() {
        if (FCL.SERVER.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UniEntity> list = new ArrayList<UniEntity>();
        for (ServerPlayer player : FCL.SERVER.get().m_6846_().m_11314_()) {
            UniEntity ent = UniEntity.get(player);
            if (ent == null) continue;
            list.add(ent);
        }
        return list;
    }

    @Override
    public <W extends WorldW> W getClientWorld0() {
        if (this.client == null) {
            this.client = WrapperHolderImpl.getWorld(Minecraft.m_91087_().f_91073_);
        }
        return (W)this.client;
    }

    @Override
    public EntityW getClientPlayer0() {
        return UniEntity.getEntity(Minecraft.m_91087_().f_91074_);
    }

    @Override
    public File getWorldFolder0(WorldW world, String name) {
        try {
            LevelResource lr = LVLRES.computeIfAbsent(name, n -> new LevelResource(n));
            File file = FCL.SERVER.get().m_129843_(lr).toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return FCL20.MAINDIR;
        }
    }

    @Override
    public V3I getPos0(Object o) {
        BlockPos pos = (BlockPos)o;
        return new V3I(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @Override
    public V3I getPos0(long l) {
        return this.getPos0(BlockPos.m_122022_((long)l));
    }

    @Override
    public CubeSide getSide0(Object o) {
        switch ((Direction)o) {
            case UP: {
                return CubeSide.UP;
            }
            case DOWN: {
                return CubeSide.DOWN;
            }
            case NORTH: {
                return CubeSide.NORTH;
            }
            case WEST: {
                return CubeSide.WEST;
            }
            case EAST: {
                return CubeSide.EAST;
            }
            case SOUTH: {
                return CubeSide.SOUTH;
            }
        }
        return CubeSide.NORTH;
    }

    @Override
    public <S> S getLocalSide0(CubeSide side) {
        switch (side) {
            case UP: {
                return (S)Direction.UP;
            }
            case DOWN: {
                return (S)Direction.DOWN;
            }
            case NORTH: {
                return (S)Direction.NORTH;
            }
            case WEST: {
                return (S)Direction.WEST;
            }
            case EAST: {
                return (S)Direction.EAST;
            }
            case SOUTH: {
                return (S)Direction.SOUTH;
            }
        }
        return (S)Direction.NORTH;
    }

    @Override
    public List<UUID> getOnlinePlayerIDs0() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (ServerPlayer player : FCL.SERVER.get().m_6846_().m_11314_()) {
            list.add(player.m_36316_().getId());
        }
        return list;
    }

    @Override
    public UUID getUUIDFor0(String string) {
        Optional gp = FCL.SERVER.get().m_129927_().m_10996_(string);
        return gp.isPresent() ? ((GameProfile)gp.get()).getId() : null;
    }

    @Override
    public String getNameFor0(UUID uuid) {
        Optional gp = FCL.SERVER.get().m_129927_().m_11002_(uuid);
        return gp.isPresent() ? ((GameProfile)gp.get()).getName() : "N/F";
    }

    @Override
    public void schedule0(Runnable run) {
        FCL.SERVER.get().execute(run);
    }

    @Override
    public void reset() {
        this.client = null;
    }

    @Override
    public TagCW read0(File file) {
        try {
            return TagCW.wrap(NbtIo.m_128953_((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return TagCW.create();
        }
    }

    @Override
    public void write0(TagCW compound, File file) {
        try {
            NbtIo.m_128955_((CompoundTag)((CompoundTag)compound.local()), (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected V3I mutPos0(Object pos) {
        BlockPos bpos = (BlockPos)pos;
        return this.vpos.set(bpos.m_123341_(), bpos.m_123342_(), bpos.m_123343_());
    }

    @Override
    protected V3I mutPos0(int x, int y, int z) {
        return this.vpos.set(x, y, z);
    }

    @Override
    protected InputStream getDataResource0(IDL loc) throws IOException {
        Optional is = FCL.SERVER.get().m_177941_().m_213713_((ResourceLocation)loc.local());
        return is.isPresent() ? ((Resource)is.get()).m_215507_() : null;
    }
}

