/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.ui;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.ui.UserInterface;

public abstract class UIElement {
    protected UserInterface ui;
    public int ox;
    public int oy;
    public int x;
    public int y;
    public int otx;
    public int oty;
    public int tx;
    public int ty;
    public int owidth;
    public int width;
    public int oheight;
    public int height;
    public boolean absolute;
    protected boolean visible;
    protected boolean enabled;
    protected boolean hovered;

    public UIElement(UserInterface ui, JsonMap map) throws Exception {
        this.ui = ui;
        this.absolute = map.getBoolean("absolute", false);
        JsonArray arr = null;
        if (map.has("pos")) {
            arr = map.getArray("pos");
            this.ox = this.x = arr.get(0).integer_value();
            this.tx = this.x;
            this.otx = this.x;
            this.oy = this.y = arr.get(1).integer_value();
            this.ty = this.y;
            this.oty = this.y;
        }
        if (map.has("uv")) {
            arr = map.getArray("uv");
            this.otx = this.tx = arr.get(0).integer_value();
            this.oty = this.ty = arr.get(1).integer_value();
        }
        boolean slot = this instanceof UISlot;
        arr = map.has("size") ? map.getArray("size") : new JsonArray(slot ? 18 : 10, slot ? 18 : 10);
        this.owidth = this.width = arr.get(0).integer_value();
        this.oheight = this.height = arr.get(1).integer_value();
        this.visible = map.getBoolean("visible", true);
        this.enabled = map.getBoolean("enabled", true);
    }

    public boolean hovered(int l, int t, int mx, int my) {
        if (this.absolute) {
            boolean xx;
            boolean bl = this.x < 0 ? mx >= this.ui.screen_width + this.x && mx <= this.ui.screen_width + this.x + this.width : (xx = mx >= this.x && mx <= this.x + this.width);
            boolean yy = this.y < 0 ? my >= this.ui.screen_height + this.y && my <= this.ui.screen_height + this.y + this.height : my >= this.y && my <= this.y + this.height;
            this.hovered = xx && yy;
            return this.hovered;
        }
        this.hovered = mx >= l + this.x && mx <= l + this.x + this.width && my >= t + this.y && my <= t + this.y + this.height;
        return this.hovered;
    }

    public void draw(Object ui, UIElement root, float ticks, int gl, int gt, int mx, int my) {
    }

    public boolean visible() {
        return this.visible;
    }

    public void visible(boolean bool) {
        this.visible = bool;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void enabled(boolean bool) {
        this.enabled = bool;
    }

    public boolean hovered() {
        return this.hovered;
    }

    public static <E extends UIElement> E create(Class<? extends UIElement> clazz, UserInterface ui, JsonMap map) throws Exception {
        return (E)clazz.getConstructor(UserInterface.class, JsonMap.class).newInstance(ui, map);
    }
}

