/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.ui;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.uni.ui.UIElement;
import net.fexcraft.mod.uni.ui.UserInterface;

public class UIField
extends UIElement {
    public static Class<? extends UIField> IMPLEMENTATION;
    public static NumberFormat nf;
    public static final DecimalFormat df;
    public String initial_value;
    public String value;
    public boolean background;
    public boolean number;
    public int color;
    public int maxlength;

    public UIField(UserInterface ui, JsonMap map) throws Exception {
        super(ui, map);
        this.initial_value = this.value = map.getString("value", "");
        this.background = map.getBoolean("background", false);
        this.color = Integer.parseInt(map.getString("color", "f0f0f0"), 16);
        if (map.has("numberfield")) {
            this.number = true;
        }
        this.maxlength = map.getInteger("max-length", 32);
    }

    public boolean onclick(int mx, int my, int mb) {
        return false;
    }

    public boolean keytyped(char c, int code) {
        return false;
    }

    public void text(Number num) {
        this.text(df.format(num));
    }

    public void text(String text) {
    }

    public void maxlength(int nl) {
    }

    public String text() {
        return this.value;
    }

    public float number() {
        return this._float();
    }

    public int integer() {
        try {
            return nf.parse(this.text()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public float _float() {
        try {
            return (float)nf.parse(this.text()).doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public double _double() {
        try {
            return nf.parse(this.text()).doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    static {
        nf = NumberFormat.getInstance(Locale.US);
        df = new DecimalFormat("#.####");
        nf.setMaximumFractionDigits(4);
        df.setRoundingMode(RoundingMode.HALF_EVEN);
        df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    }
}

