/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import org.lwjgl.opengl.GL11;

public class TexturedPolygon {
    public static boolean TRIANGULATED_QUADS = true;
    private boolean invert = false;
    private float[] normals;
    private RGB color = null;
    private ArrayList<Vec3f> list;
    private TexturedVertex[] vertices;

    public TexturedPolygon(TexturedVertex[] verts) {
        this.vertices = verts;
        this.normals = new float[0];
        this.list = new ArrayList();
    }

    public TexturedPolygon(ArrayList<TexturedVertex> verts) {
        this(verts.toArray(new TexturedVertex[0]));
    }

    public void setInvert(boolean bool) {
        this.invert = bool;
    }

    public void setNormals(float x, float y, float z) {
        this.normals = new float[]{x, y, z};
    }

    public void draw(float scale, RGB lincol, RGB rgb) {
        boolean gnorm;
        if (lincol != null) {
            GL11.glBegin((int)3);
            lincol.glColorApply();
        } else {
            switch (this.vertices.length) {
                case 3: {
                    GL11.glBegin((int)4);
                    break;
                }
                case 4: {
                    GL11.glBegin((int)(TRIANGULATED_QUADS ? 4 : 7));
                    break;
                }
                default: {
                    GL11.glBegin((int)9);
                }
            }
        }
        boolean bl = gnorm = this.list.isEmpty() || this.list.size() != this.vertices.length;
        if (gnorm) {
            this.genIfMissingNormals();
        }
        if (TRIANGULATED_QUADS && this.vertices.length == 4) {
            if (rgb == null && this.color == null) {
                this.triangleT(scale, 0, 1, 2, gnorm, 0);
            } else {
                (this.color == null ? rgb : this.color).glColorApply();
                this.triangleC(scale, 0, 1, 2, gnorm, 0);
            }
            if (rgb == null && this.color == null) {
                this.triangleT(scale, 0, 2, 3, gnorm, 3);
            } else {
                (this.color == null ? rgb : this.color).glColorApply();
                this.triangleC(scale, 0, 2, 3, gnorm, 3);
            }
        } else {
            for (int i = 0; i < this.vertices.length; ++i) {
                TexturedVertex texvex = this.vertices[i];
                if (!gnorm) {
                    Vec3f norm = this.list.get(i);
                    if (this.invert) {
                        GL11.glNormal3f((float)(-norm.x), (float)(-norm.y), (float)(-norm.z));
                    } else {
                        GL11.glNormal3f((float)norm.x, (float)norm.y, (float)norm.z);
                    }
                } else if (this.invert) {
                    GL11.glNormal3f((float)(-this.normals[0]), (float)(-this.normals[1]), (float)(-this.normals[2]));
                } else {
                    GL11.glNormal3f((float)this.normals[0], (float)this.normals[1], (float)this.normals[2]);
                }
                if (rgb == null && this.color == null) {
                    GL11.glTexCoord2f((float)texvex.textureX, (float)texvex.textureY);
                    GL11.glVertex3f((float)(texvex.vector.x * scale), (float)(texvex.vector.y * scale), (float)(texvex.vector.z * scale));
                    continue;
                }
                (this.color == null ? rgb : this.color).glColorApply();
                GL11.glVertex3f((float)(texvex.vector.x * scale), (float)(texvex.vector.y * scale), (float)(texvex.vector.z * scale));
            }
        }
        GL11.glEnd();
    }

    private void triangleT(float scale, int x, int y, int z, boolean gnorm, int off) {
        if (gnorm) {
            if (this.invert) {
                GL11.glNormal3f((float)(-this.normals[0 + off]), (float)(-this.normals[1 + off]), (float)(-this.normals[2 + off]));
            } else {
                GL11.glNormal3f((float)this.normals[0 + off], (float)this.normals[1 + off], (float)this.normals[2 + off]);
            }
        }
        if (!gnorm) {
            this.norm(x);
        }
        GL11.glTexCoord2f((float)this.vertices[x].textureX, (float)this.vertices[x].textureY);
        GL11.glVertex3f((float)(this.vertices[x].vector.x * scale), (float)(this.vertices[x].vector.y * scale), (float)(this.vertices[x].vector.z * scale));
        if (!gnorm) {
            this.norm(y);
        }
        GL11.glTexCoord2f((float)this.vertices[y].textureX, (float)this.vertices[y].textureY);
        GL11.glVertex3f((float)(this.vertices[y].vector.x * scale), (float)(this.vertices[y].vector.y * scale), (float)(this.vertices[y].vector.z * scale));
        if (!gnorm) {
            this.norm(z);
        }
        GL11.glTexCoord2f((float)this.vertices[z].textureX, (float)this.vertices[z].textureY);
        GL11.glVertex3f((float)(this.vertices[z].vector.x * scale), (float)(this.vertices[z].vector.y * scale), (float)(this.vertices[z].vector.z * scale));
    }

    private void triangleC(float scale, int x, int y, int z, boolean gnorm, int off) {
        if (gnorm) {
            if (this.invert) {
                GL11.glNormal3f((float)(-this.normals[0 + off]), (float)(-this.normals[1 + off]), (float)(-this.normals[2 + off]));
            } else {
                GL11.glNormal3f((float)this.normals[0 + off], (float)this.normals[1 + off], (float)this.normals[2 + off]);
            }
        }
        if (!gnorm) {
            this.norm(x);
        }
        GL11.glVertex3f((float)(this.vertices[x].vector.x * scale), (float)(this.vertices[x].vector.y * scale), (float)(this.vertices[x].vector.z * scale));
        if (!gnorm) {
            this.norm(y);
        }
        GL11.glVertex3f((float)(this.vertices[y].vector.x * scale), (float)(this.vertices[y].vector.y * scale), (float)(this.vertices[y].vector.z * scale));
        if (!gnorm) {
            this.norm(z);
        }
        GL11.glVertex3f((float)(this.vertices[z].vector.x * scale), (float)(this.vertices[z].vector.y * scale), (float)(this.vertices[z].vector.z * scale));
    }

    private void norm(int i) {
        Vec3f norm = this.list.get(i);
        if (this.invert) {
            GL11.glNormal3f((float)(-norm.x), (float)(-norm.y), (float)(-norm.z));
        } else {
            GL11.glNormal3f((float)norm.x, (float)norm.y, (float)norm.z);
        }
    }

    public void genIfMissingNormals() {
        if (this.normals.length >= 3) {
            return;
        }
        if (TRIANGULATED_QUADS && this.vertices.length == 4) {
            Vec3f vec0 = new Vec3f(this.vertices[1].vector.sub(this.vertices[0].vector));
            Vec3f vec1 = new Vec3f(this.vertices[1].vector.sub(this.vertices[2].vector));
            Vec3f vec2 = vec1.cross(vec0).normalize();
            vec0 = new Vec3f(this.vertices[2].vector.sub(this.vertices[0].vector));
            vec1 = new Vec3f(this.vertices[2].vector.sub(this.vertices[3].vector));
            Vec3f vec3 = vec1.cross(vec0).normalize();
            this.normals = new float[]{vec2.x, vec2.y, vec2.z, vec3.x, vec3.y, vec3.z};
        } else if (this.vertices.length >= 3) {
            Vec3f vec0 = new Vec3f(this.vertices[1].vector.sub(this.vertices[0].vector));
            Vec3f vec1 = new Vec3f(this.vertices[1].vector.sub(this.vertices[2].vector));
            Vec3f vec2 = vec1.cross(vec0).normalize();
            this.normals = new float[]{vec2.x, vec2.y, vec2.z};
        }
    }

    public void flipFace() {
        TexturedVertex[] verts = new TexturedVertex[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            verts[i] = this.vertices[this.vertices.length - i - 1];
        }
        this.vertices = verts;
    }

    public TexturedVertex[] getVertices() {
        return this.vertices;
    }

    public void clearNormals() {
        this.normals = new float[0];
        this.list = new ArrayList();
    }

    public boolean isInverted() {
        return this.invert;
    }

    public float[] getNormals() {
        return this.normals;
    }

    public List<Vec3f> getNormalVerts() {
        return this.list;
    }

    public TexturedPolygon setColor(RGB rgb) {
        this.color = rgb;
        return this;
    }
}

