/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl.gen;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.lib.frl.gen.AxisDir;
import net.fexcraft.lib.frl.gen.Generator;
import net.fexcraft.lib.frl.gen.ValueMap;

public class Generator_Cylinder {
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;

    public static <GL extends GLO> void make(Polyhedron<GL> poly, ValueMap map) {
        float scale;
        int i;
        float radius = map.getValue("radius", Float.valueOf(1.0f)).floatValue();
        float radius2 = map.getValue("radius2", Float.valueOf(0.0f)).floatValue();
        float radius3 = map.getValue("radius3", Float.valueOf(radius)).floatValue();
        float radius4 = map.getValue("radius4", Float.valueOf(radius2)).floatValue();
        float length = map.getValue("length", Float.valueOf(1.0f)).floatValue();
        AxisDir dir = map.getValue("axis_dir", AxisDir.X_POSITIVE);
        int segments = map.getValue("segments", 4);
        int seglimit = map.getValue("seg_limit", 0);
        float seg_off = Static.toRadians(map.getValue("seg_off", Float.valueOf(0.0f)).floatValue());
        float top_scale = map.getValue("top_scale", Float.valueOf(1.0f)).floatValue();
        float base_scale = map.getValue("base_scale", Float.valueOf(1.0f)).floatValue();
        boolean radial = map.getValue("radial", false);
        float seg_width = map.getValue("seg_width", Float.valueOf(1.0f)).floatValue();
        float seg_height = map.getValue("seg_height", Float.valueOf(1.0f)).floatValue();
        Vec3f topoff = map.getValue("top_offset", null);
        AxisRotator toprot = map.getValue("top_rot", null);
        float x = map.getValue("x", Float.valueOf(0.0f)).floatValue();
        float y = map.getValue("y", Float.valueOf(0.0f)).floatValue();
        float z = map.getValue("z", Float.valueOf(0.0f)).floatValue();
        boolean[] rems = Generator.intToBoolArray(map.getArray("rem_poly"), 6);
        if (radius2 == 0.0f) {
            rems[3] = true;
        }
        boolean[] deuv = Generator.intToBoolArray(map.getArray("detached_uv"), 6);
        List<Object> uv = map.getArray("uv", 6, null);
        float texw = map.getValue("texture_width", Float.valueOf(1.0f)).floatValue();
        float texh = map.getValue("texture_height", Float.valueOf(1.0f)).floatValue();
        float diameter = (int)Math.floor(radius * 2.0f);
        float texheight = (int)Math.floor(length);
        if (radius < 1.0f) {
            int rad;
            int n = rad = (double)radius < 0.5 ? 1 : 2;
            if (diameter < (float)rad) {
                diameter = rad;
            }
        }
        if (length < 1.0f) {
            texheight = 1.0f;
        } else if (length % 1.0f != 0.0f) {
            texheight = (int)length + (length % 1.0f > 0.5f ? 1 : 0);
        }
        boolean dir_y = dir.isY();
        boolean dir_z = dir.isZ();
        boolean dir_x = dir.isX();
        if (base_scale == 0.0f) {
            base_scale = 1.0f;
        }
        if (top_scale == 0.0f) {
            rems[1] = true;
        }
        if (segments < 3) {
            segments = 3;
        }
        if (seglimit <= 0) {
            seglimit = segments;
        }
        boolean segl = seglimit < segments;
        ArrayList<Polygon> polis = new ArrayList<Polygon>();
        float length_x = dir_x ? length : 0.0f;
        float length_y = dir_y ? length : 0.0f;
        float length_z = dir_z ? length : 0.0f;
        float s_x = dir.positive ? x + length_x : x;
        float s_y = dir.positive ? y + length_y : y;
        float s_z = dir.positive ? z + length_z : z;
        float e_x = (!dir.positive ? x + length_x : x) + (topoff == null ? 0.0f : topoff.x);
        float e_y = (!dir.positive ? y + length_y : y) + (topoff == null ? 0.0f : topoff.y);
        float e_z = (!dir.positive ? z + length_z : z) + (topoff == null ? 0.0f : topoff.z);
        float c_x = s_x;
        float c_y = s_y;
        float c_z = s_z;
        float c_s = base_scale;
        float[][] uvs = new float[6][];
        float scale_u = 1.0f / texw;
        float scale_v = 1.0f / texh;
        float circle_u = diameter * scale_u;
        float circle_v = diameter * scale_v;
        float circle2_u = (float)((int)Math.floor(radius2 * 2.0f)) * scale_u;
        float circle2_v = (float)((int)Math.floor(radius2 * 2.0f)) * scale_v;
        float height_v = texheight * scale_v;
        float seg_u = radius - radius2;
        if (seg_u < 1.0f) {
            seg_u = 1.0f;
        } else if (seg_u % 1.0f != 0.0f) {
            seg_u = (int)seg_u + (seg_u % 1.0f > 0.5f ? 1 : 0);
        }
        seg_u *= scale_u;
        float x0 = poly.texU * scale_u;
        float y0 = poly.texV * scale_v;
        uvs[0] = new float[]{x0, y0};
        uvs[1] = new float[]{x0 + (Generator.detached(rems, deuv, 0) || radial ? 0.0f : circle_u), y0 + (radial && !Generator.detached(rems, deuv, 0) ? seg_height : 0.0f)};
        float cirhi = Generator.detached(rems, deuv, 0) && Generator.detached(rems, deuv, 1) ? 0.0f : (radial ? seg_height * (float)(Generator.detached(rems, deuv, 0) || Generator.detached(rems, deuv, 1) ? 1 : 2) * scale_v : circle_v);
        float cirwi = Generator.detached(rems, deuv, 2) && Generator.detached(rems, deuv, 3) ? 0.0f : circle_u + circle_u;
        uvs[2] = new float[]{x0, y0 + cirhi};
        uvs[3] = new float[]{x0, y0 + cirhi + (Generator.detached(rems, deuv, 2) ? 0.0f : height_v)};
        uvs[4] = new float[]{x0 + cirwi, y0 + cirhi};
        uvs[5] = new float[]{x0 + cirwi + (Generator.detached(rems, deuv, 2) || Generator.detached(rems, deuv, 3) ? seg_u : 0.0f), y0 + cirhi + (Generator.detached(rems, deuv, 2) || Generator.detached(rems, deuv, 3) ? 0.0f : height_v)};
        for (int i2 = 0; i2 < uv.size(); ++i2) {
            if (rems[i2] || uv.get(i2) == null || ((float[])uv.get(i2)).length != 2) continue;
            uvs[i2][0] = ((float[])uv.get(i2))[0] * scale_u;
            uvs[i2][1] = ((float[])uv.get(i2))[1] * scale_v;
            if (deuv[i2]) continue;
            float[] fArray = uvs[i2];
            fArray[0] = fArray[0] + x0;
            float[] fArray2 = uvs[i2];
            fArray2[1] = fArray2[1] + y0;
        }
        float width_u = circle_u * 2.0f / (float)segments;
        float segpi = (float)Math.PI / (float)segments;
        ArrayList<Vertex> verts0 = new ArrayList<Vertex>();
        ArrayList<Vertex> verts1 = new ArrayList<Vertex>();
        ArrayList<Vertex> verts2 = new ArrayList<Vertex>();
        ArrayList<Vertex> verts3 = new ArrayList<Vertex>();
        if (map.getValue("exp", false).booleanValue()) {
            seg_off += segpi;
            radius = (float)((double)radius + ((double)radius - Math.cos(segpi) * (double)radius));
            radius2 = (float)((double)radius2 + ((double)radius2 - Math.cos(segpi) * (double)radius2));
            radius3 = (float)((double)radius3 + ((double)radius3 - Math.cos(segpi) * (double)radius3));
            radius4 = (float)((double)radius4 + ((double)radius4 - Math.cos(segpi) * (double)radius4));
        }
        for (int repeat = 0; repeat < 2; ++repeat) {
            boolean bool;
            for (int index = 0; index < segments; ++index) {
                double s = Math.sin(segpi * (float)index * 2.0f + (float)Math.PI + seg_off);
                double c = -Math.cos(segpi * (float)index * 2.0f + (float)Math.PI + seg_off);
                float size_x = (float)((double)(dir.positive ? -1 : 1) * s * (double)radius * (double)c_s);
                float size_z = (float)(c * (double)radius3 * (double)c_s);
                float x02 = c_x + (!dir_x ? size_x : 0.0f);
                float y1 = c_y + (!dir_y ? size_z : 0.0f);
                float z1 = c_z + (dir_x ? size_x : (dir_y ? size_z : 0.0f));
                verts0.add(new Vertex(x02, y1, z1));
                if (index == segments - 1) {
                    verts0.add(new Vertex((Vertex)verts0.get(0)));
                }
                float xSize2 = (float)((double)(dir.positive ? -1 : 1) * s * (double)radius2 * (double)c_s);
                float zSize2 = (float)(c * (double)radius4 * (double)c_s);
                x02 = c_x + (!dir_x ? xSize2 : 0.0f);
                y1 = c_y + (!dir_y ? zSize2 : 0.0f);
                z1 = c_z + (dir_x ? xSize2 : (dir_y ? zSize2 : 0.0f));
                verts1.add(new Vertex(x02, y1, z1));
                if (index != segments - 1) continue;
                verts1.add(new Vertex((Vertex)verts1.get(0)));
            }
            if (repeat == 0) {
                verts2.addAll(verts0);
                verts2.addAll(verts1);
            } else {
                verts3.addAll(verts0);
                verts3.addAll(verts1);
            }
            boolean bl = repeat == 0 ? !dir_z : (bool = dir_z);
            if (!rems[repeat]) {
                for (int i3 = 0; i3 < verts0.size(); ++i3) {
                    if (i3 >= verts0.size() - 1 || i3 >= seglimit) {
                        if (repeat == 0 || toprot == null) break;
                        ((Vertex)verts0.get((int)i3)).vector = toprot.getRelativeVector(((Vertex)verts0.get((int)i3)).vector);
                        ((Vertex)verts1.get((int)i3)).vector = toprot.getRelativeVector(((Vertex)verts1.get((int)i3)).vector);
                        break;
                    }
                    Vertex[] arr = new Vertex[4];
                    if (!radial) {
                        float size_x = (float)(Math.sin(segpi * (float)i3 * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle_u));
                        float size_y = (float)(Math.cos(segpi * (float)i3 * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle_v));
                        arr[0] = ((Vertex)verts0.get(i3)).nauv(uvs[repeat][0] + 0.5f * circle_u + size_x, uvs[repeat][1] + 0.5f * circle_v + size_y);
                        size_x = (float)(Math.sin(segpi * (float)i3 * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle2_u));
                        size_y = (float)(Math.cos(segpi * (float)i3 * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle2_v));
                        arr[1] = ((Vertex)verts1.get(i3)).nauv(uvs[repeat][0] + 0.5f * circle_u + size_x, uvs[repeat][1] + 0.5f * circle_v + size_y);
                        size_x = (float)(Math.sin(segpi * (float)(i3 + 1) * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle2_u));
                        size_y = (float)(Math.cos(segpi * (float)(i3 + 1) * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle2_v));
                        arr[2] = ((Vertex)verts1.get(i3 + 1)).nauv(uvs[repeat][0] + 0.5f * circle_u + size_x, uvs[repeat][1] + 0.5f * circle_v + size_y);
                        size_x = (float)(Math.sin(segpi * (float)(i3 + 1) * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle_u));
                        size_y = (float)(Math.cos(segpi * (float)(i3 + 1) * 2.0f + (!dir_y ? 0.0f : (float)Math.PI)) * (double)(0.5f * circle_v));
                        arr[3] = ((Vertex)verts0.get(i3 + 1)).nauv(uvs[repeat][0] + 0.5f * circle_u + size_x, uvs[repeat][1] + 0.5f * circle_v + size_y);
                    } else {
                        float diff = seg_u / 4.0f;
                        arr[0] = ((Vertex)verts0.get(i3)).nauv(uvs[repeat][0] + (float)i3 * seg_width * scale_u, uvs[repeat][1]);
                        arr[1] = ((Vertex)verts1.get(i3)).nauv(uvs[repeat][0] + (float)i3 * seg_width * scale_u + diff, uvs[repeat][1] + seg_height * scale_v);
                        arr[2] = ((Vertex)verts1.get(i3 + 1)).nauv(uvs[repeat][0] + (float)(i3 + 1) * seg_width * scale_u - diff, uvs[repeat][1] + seg_height * scale_v);
                        arr[3] = ((Vertex)verts0.get(i3 + 1)).nauv(uvs[repeat][0] + (float)(i3 + 1) * seg_width * scale_u, uvs[repeat][1]);
                    }
                    if (repeat != 0 && toprot != null) {
                        arr[0].vector = ((Vertex)verts0.get((int)i3)).vector = toprot.getRelativeVector(arr[0].vector);
                        arr[1].vector = ((Vertex)verts1.get((int)i3)).vector = toprot.getRelativeVector(arr[1].vector);
                        arr[2].vector = toprot.getRelativeVector(arr[2].vector);
                        arr[3].vector = toprot.getRelativeVector(arr[3].vector);
                    }
                    polis.add(new Polygon(arr));
                    if (!bool) continue;
                    ((Polygon)polis.get(polis.size() - 1)).flip();
                }
            }
            verts0.clear();
            verts1.clear();
            c_x = e_x;
            c_y = e_y;
            c_z = e_z;
            c_s = top_scale;
        }
        int halfv2 = verts2.size() / 2;
        if (map.getValue("ordered", false).booleanValue()) {
            for (i = 0; !(i >= halfv2 || i >= halfv2 - 1 || i >= seglimit && segl); ++i) {
                Vertex[] arr = new Vertex[4];
                if (rems[2]) continue;
                arr[0] = ((Vertex)verts2.get(i + 0)).nauv(uvs[2][0] + width_u * (float)(i + 0), uvs[2][1]);
                arr[1] = ((Vertex)verts3.get(i + 0)).nauv(uvs[2][0] + width_u * (float)(i + 0), uvs[2][1] + height_v);
                arr[2] = ((Vertex)verts3.get(i + 1)).nauv(uvs[2][0] + width_u * (float)(i + 1), uvs[2][1] + height_v);
                arr[3] = ((Vertex)verts2.get(i + 1)).nauv(uvs[2][0] + width_u * (float)(i + 1), uvs[2][1]);
                polis.add(new Polygon(arr));
                if (!dir_z) continue;
                ((Polygon)polis.get(polis.size() - 1)).flip();
            }
            for (i = 0; !(i >= halfv2 || i >= halfv2 - 1 || i >= seglimit && segl); ++i) {
                Vertex[] arr = new Vertex[4];
                if (rems[3]) continue;
                arr = new Vertex[]{((Vertex)verts2.get(i + halfv2 + 0)).nauv(uvs[3][0] + width_u * (float)(i + 0), uvs[3][1]), ((Vertex)verts3.get(i + halfv2 + 0)).nauv(uvs[3][0] + width_u * (float)(i + 0), uvs[3][1] + height_v), ((Vertex)verts3.get(i + halfv2 + 1)).nauv(uvs[3][0] + width_u * (float)(i + 1), uvs[3][1] + height_v), ((Vertex)verts2.get(i + halfv2 + 1)).nauv(uvs[3][0] + width_u * (float)(i + 1), uvs[3][1])};
                polis.add(new Polygon(arr));
                if (dir_z) continue;
                ((Polygon)polis.get(polis.size() - 1)).flip();
            }
            for (i = 0; i < halfv2; ++i) {
                if (i < seglimit || !segl) continue;
                if (!rems[4]) {
                    Vertex[] arr = new Vertex[]{((Vertex)verts2.get(0)).nauv(uvs[4][0], uvs[4][1]), ((Vertex)verts3.get(0)).nauv(uvs[4][0], uvs[4][1] + height_v), ((Vertex)verts3.get(halfv2)).nauv(uvs[4][0] + seg_u, uvs[4][1] + height_v), ((Vertex)verts2.get(halfv2)).nauv(uvs[4][0] + seg_u, uvs[4][1])};
                    polis.add(new Polygon(arr));
                    if (!dir_z) {
                        ((Polygon)polis.get(polis.size() - 1)).flip();
                    }
                }
                if (rems[5]) break;
                Vertex[] arr = new Vertex[]{((Vertex)verts2.get(seglimit)).nauv(uvs[5][0], uvs[5][1]), ((Vertex)verts3.get(seglimit)).nauv(uvs[5][0], uvs[5][1] + height_v), ((Vertex)verts3.get(seglimit + halfv2)).nauv(uvs[5][0] + seg_u, uvs[5][1] + height_v), ((Vertex)verts2.get(seglimit + halfv2)).nauv(uvs[5][0] + seg_u, uvs[5][1])};
                polis.add(new Polygon(arr));
                if (dir_z) {
                    ((Polygon)polis.get(polis.size() - 1)).flip();
                }
                break;
            }
        } else {
            for (i = 0; i < halfv2; ++i) {
                if (i >= seglimit && segl) {
                    if (!rems[4]) {
                        Vertex[] arr = new Vertex[]{((Vertex)verts2.get(0)).nauv(uvs[4][0], uvs[4][1]), ((Vertex)verts3.get(0)).nauv(uvs[4][0], uvs[4][1] + height_v), ((Vertex)verts3.get(halfv2)).nauv(uvs[4][0] + seg_u, uvs[4][1] + height_v), ((Vertex)verts2.get(halfv2)).nauv(uvs[4][0] + seg_u, uvs[4][1])};
                        polis.add(new Polygon(arr));
                        if (!dir_z) {
                            ((Polygon)polis.get(polis.size() - 1)).flip();
                        }
                    }
                    if (rems[5]) break;
                    Vertex[] arr = new Vertex[]{((Vertex)verts2.get(seglimit)).nauv(uvs[5][0], uvs[5][1]), ((Vertex)verts3.get(seglimit)).nauv(uvs[5][0], uvs[5][1] + height_v), ((Vertex)verts3.get(seglimit + halfv2)).nauv(uvs[5][0] + seg_u, uvs[5][1] + height_v), ((Vertex)verts2.get(seglimit + halfv2)).nauv(uvs[5][0] + seg_u, uvs[5][1])};
                    polis.add(new Polygon(arr));
                    if (!dir_z) break;
                    ((Polygon)polis.get(polis.size() - 1)).flip();
                    break;
                }
                if (i < halfv2 - 1) {
                    Vertex[] arr = new Vertex[4];
                    if (!rems[2]) {
                        arr[0] = ((Vertex)verts2.get(i + 0)).nauv(uvs[2][0] + width_u * (float)(i + 0), uvs[2][1]);
                        arr[1] = ((Vertex)verts3.get(i + 0)).nauv(uvs[2][0] + width_u * (float)(i + 0), uvs[2][1] + height_v);
                        arr[2] = ((Vertex)verts3.get(i + 1)).nauv(uvs[2][0] + width_u * (float)(i + 1), uvs[2][1] + height_v);
                        arr[3] = ((Vertex)verts2.get(i + 1)).nauv(uvs[2][0] + width_u * (float)(i + 1), uvs[2][1]);
                        polis.add(new Polygon(arr));
                        if (dir_z) {
                            ((Polygon)polis.get(polis.size() - 1)).flip();
                        }
                    }
                    if (rems[3]) continue;
                    arr = new Vertex[]{((Vertex)verts2.get(i + halfv2 + 0)).nauv(uvs[3][0] + width_u * (float)(i + 0), uvs[3][1]), ((Vertex)verts3.get(i + halfv2 + 0)).nauv(uvs[3][0] + width_u * (float)(i + 0), uvs[3][1] + height_v), ((Vertex)verts3.get(i + halfv2 + 1)).nauv(uvs[3][0] + width_u * (float)(i + 1), uvs[3][1] + height_v), ((Vertex)verts2.get(i + halfv2 + 1)).nauv(uvs[3][0] + width_u * (float)(i + 1), uvs[3][1])};
                    polis.add(new Polygon(arr));
                    if (dir_z) continue;
                    ((Polygon)polis.get(polis.size() - 1)).flip();
                    continue;
                }
                break;
            }
        }
        if ((scale = map.getValue("scale", Float.valueOf(1.0f)).floatValue()) != 1.0f) {
            for (Polygon gon : polis) {
                for (Vertex vert : gon.vertices) {
                    vert.vector = vert.vector.scale(scale);
                }
            }
        }
        for (Polygon gon : polis) {
            poly.polygons.add(gon);
        }
    }
}

