/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.utils;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.packet.PacketEntityUpdate;
import net.fexcraft.lib.mc.network.packet.PacketTileEntityUpdate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ApiUtil {
    private static final int range = 64;

    public static void sendTileEntityUpdatePacket(World world, BlockPos pos, NBTTagCompound nbt) {
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketTileEntityUpdate(world.field_73011_w.getDimension(), pos, nbt), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }

    public static void sendTileEntityUpdatePacket(World world, BlockPos pos, NBTTagCompound nbt, int range) {
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketTileEntityUpdate(world.field_73011_w.getDimension(), pos, nbt), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range));
    }

    public static void sendTileEntityUpdatePacket(int dim, BlockPos pos, NBTTagCompound nbt) {
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketTileEntityUpdate(dim, pos, nbt), new NetworkRegistry.TargetPoint(dim, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0));
    }

    public static void sendTileEntityUpdatePacket(int dim, BlockPos pos, NBTTagCompound nbt, int range) {
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketTileEntityUpdate(dim, pos, nbt), new NetworkRegistry.TargetPoint(dim, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range));
    }

    public static void sendTileEntityUpdatePacket(TileEntity entity, NBTTagCompound nbt, int i) {
        BlockPos pos = entity.func_174877_v();
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketTileEntityUpdate(entity.func_145831_w().field_73011_w.getDimension(), pos, nbt), new NetworkRegistry.TargetPoint(entity.func_145831_w().field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)i));
    }

    public static void sendEntityUpdatePacketToClient(Entity ent, EntityPlayerMP player, NBTTagCompound nbt) {
        PacketHandler.getInstance().sendTo((IMessage)new PacketEntityUpdate(ent, nbt), player);
    }

    public static void sendEntityUpdatePacketToAll(Entity ent, NBTTagCompound nbt) {
        PacketHandler.getInstance().sendToAll((IMessage)new PacketEntityUpdate(ent, nbt));
    }

    public static void sendEntityUpdatePacketToAllAround(Entity ent, NBTTagCompound nbt) {
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketEntityUpdate(ent, nbt), new NetworkRegistry.TargetPoint(ent.field_71093_bK, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 256.0));
    }

    public static void sendEntityUpdatePacketToServer(Entity ent, NBTTagCompound nbt) {
        PacketHandler.getInstance().sendToServer((IMessage)new PacketEntityUpdate(ent, nbt));
    }

    public static final EnumDyeColor getDyeColorFromString(String s) {
        return ApiUtil.getDyeColorFromString(s, EnumDyeColor.WHITE);
    }

    public static final EnumDyeColor getDyeColorFromString(String s, EnumDyeColor def) {
        switch (s) {
            case "white": {
                return EnumDyeColor.WHITE;
            }
            case "orange": {
                return EnumDyeColor.ORANGE;
            }
            case "magenta": {
                return EnumDyeColor.MAGENTA;
            }
            case "light_blue": {
                return EnumDyeColor.LIGHT_BLUE;
            }
            case "yellow": {
                return EnumDyeColor.YELLOW;
            }
            case "lime": {
                return EnumDyeColor.LIME;
            }
            case "pink": {
                return EnumDyeColor.PINK;
            }
            case "gray": {
                return EnumDyeColor.GRAY;
            }
            case "silver": 
            case "light_gray": {
                return EnumDyeColor.SILVER;
            }
            case "cyan": {
                return EnumDyeColor.CYAN;
            }
            case "purple": {
                return EnumDyeColor.PURPLE;
            }
            case "blue": {
                return EnumDyeColor.BLUE;
            }
            case "brown": {
                return EnumDyeColor.BROWN;
            }
            case "green": {
                return EnumDyeColor.GREEN;
            }
            case "red": {
                return EnumDyeColor.RED;
            }
            case "black": {
                return EnumDyeColor.BLACK;
            }
        }
        return def;
    }

    public static final NBTTagCompound writeToNBT(RGB rgb, NBTTagCompound tag, String a) {
        try {
            String s = a == null ? "" : "_" + a;
            tag.func_74768_a("RGB" + s, rgb.packed);
            tag.func_74776_a("RGBA" + s, rgb.alpha);
            return tag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tag;
        }
    }

    public static final void readFromNBT(RGB rgb, NBTTagCompound tag, String a) {
        try {
            String s;
            String string = s = a == null ? "" : "_" + a;
            if (tag.func_74764_b("RGB_Red" + s)) {
                byte red = tag.func_74771_c("RGB_Red" + s);
                byte green = tag.func_74771_c("RGB_Green" + s);
                byte blue = tag.func_74771_c("RGB_Blue" + s);
                rgb.packed = new RGB((byte)red, (byte)green, (byte)blue).packed;
            } else {
                rgb.packed = tag.func_74762_e("RGB" + s);
                rgb.alpha = tag.func_74760_g("RGBA" + s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rgb.packed = RGB.WHITE.packed;
        }
    }
}

