/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.utils;

import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.math.Vec3f;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Axis3DL
implements AxisRotator {
    private Matrix4f matrix = new Matrix4f();
    private float yaw;
    private float pitch;
    private float roll;

    public String toString() {
        return "[ " + this.yaw + "y, " + this.pitch + "p, " + this.roll + "r ]";
    }

    @Override
    public Vec3f getRelativeVector(Vec3f vec) {
        Matrix4f mat = new Matrix4f();
        mat.m00 = vec.x;
        mat.m10 = vec.y;
        mat.m20 = vec.z;
        Matrix4f.rotate((float)(this.roll * (float)Math.PI / 180.0f), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)mat, (Matrix4f)mat);
        Matrix4f.rotate((float)(this.pitch * (float)Math.PI / 180.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)mat, (Matrix4f)mat);
        Matrix4f.rotate((float)(this.yaw * (float)Math.PI / 180.0f), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Matrix4f)mat, (Matrix4f)mat);
        return new Vec3f(mat.m00, mat.m10, mat.m20);
    }

    private final void convertMatrixToAngles() {
        this.yaw = (float)Math.atan2(this.matrix.m20, this.matrix.m00) * 180.0f / (float)Math.PI;
        this.pitch = (float)Math.atan2(-this.matrix.m10, Math.sqrt(this.matrix.m12 * this.matrix.m12 + this.matrix.m11 * this.matrix.m11)) * 180.0f / (float)Math.PI;
        this.roll = (float)Math.atan2(this.matrix.m12, this.matrix.m11) * 180.0f / (float)Math.PI;
    }

    private final void convertToMatrix(boolean rad) {
        this.matrix = new Matrix4f();
        this.matrix.rotate(rad ? this.roll : this.roll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        this.matrix.rotate(rad ? this.pitch : this.pitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        this.matrix.rotate(rad ? this.yaw : this.yaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        this.convertMatrixToAngles();
    }

    @Override
    public void setAngles(float yaw, float pitch, float roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.convertToMatrix(false);
    }
}

