/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import java.util.ArrayList;
import net.fexcraft.lib.tmt.ModelRendererTurbo;

public class VoxelBuilder {
    private ModelRendererTurbo root;
    private Boolean[][][] data;
    private int segx;
    private int segy;
    private int segz;

    public VoxelBuilder(ModelRendererTurbo turbo, int segments) {
        this.root = turbo == null ? new ModelRendererTurbo(null) : turbo;
        this.segx = segments;
        this.segy = segments;
        this.segz = segments;
    }

    public VoxelBuilder(ModelRendererTurbo turbo, int x, int y, int z) {
        this.root = turbo == null ? new ModelRendererTurbo(null) : turbo;
        this.segx = x;
        this.segy = y;
        this.segz = z;
    }

    public VoxelBuilder setVoxels(boolean[][][] content) {
        this.data = new Boolean[this.segx][this.segy][this.segz];
        for (int x = 0; x < this.segx; ++x) {
            for (int y = 0; y < this.segy; ++y) {
                for (int z = 0; z < this.segz; ++z) {
                    this.data[x][y][z] = content[x][y][z];
                }
            }
        }
        return this;
    }

    public VoxelBuilder addVoxels(int xf, int yf, int zf, int xt, int yt, int zt) {
        int z;
        int y;
        int x;
        if (this.data == null) {
            this.data = new Boolean[this.segx][this.segy][this.segz];
            for (x = 0; x < this.segx; ++x) {
                for (y = 0; y < this.segy; ++y) {
                    for (z = 0; z < this.segz; ++z) {
                        this.data[x][y][z] = false;
                    }
                }
            }
        }
        for (x = xf; x < xt; ++x) {
            for (y = yf; y < yt; ++y) {
                for (z = zf; z < zt; ++z) {
                    this.data[x][y][z] = true;
                }
            }
        }
        return this;
    }

    public ModelRendererTurbo build() {
        ArrayList<int[]> rects = this.rectangulate();
        for (int[] rect : rects) {
            int x = rect[3] - rect[0];
            int y = rect[4] - rect[1];
            int z = rect[5] - rect[2];
            this.root.addBox(rect[0], rect[1], rect[2], x + 1, y + 1, z + 1);
        }
        return this.root;
    }

    public ArrayList<int[]> buildCoords() {
        ArrayList<int[]> rects = this.rectangulate();
        ArrayList<int[]> export = new ArrayList<int[]>();
        for (int[] rect : rects) {
            int x = rect[3] - rect[0];
            int y = rect[4] - rect[1];
            int z = rect[5] - rect[2];
            export.add(new int[]{rect[0], rect[1], rect[2], x + 1, y + 1, z + 1});
        }
        return export;
    }

    public ArrayList<int[]> rectangulate() {
        ArrayList<int[]> rects = new ArrayList<int[]>();
        for (int x = 0; x < this.segx; ++x) {
            for (int y = 0; y < this.segy; ++y) {
                for (int z = 0; z < this.segz; ++z) {
                    if (!this.contains(x, y, z)) continue;
                    rects.add(this.find(x, y, z));
                }
            }
        }
        return rects;
    }

    private int[] find(int sx, int sy, int sz) {
        int ix = 1;
        int iy = 1;
        int iz = 1;
        int lx = 0;
        int ly = 0;
        int lz = 0;
        boolean failed = false;
        ArrayList<VV3> allrem = new ArrayList<VV3>();
        ArrayList<VV3> torem = new ArrayList<VV3>();
        do {
            int x;
            int z;
            if (lx != ix) {
                int x2 = sx + ix;
                block1: for (int y = sy; y < sy + ly + 1; ++y) {
                    for (z = sz; z < sz + lz + 1; ++z) {
                        if (!this.contains(x2, y, z)) {
                            failed = true;
                            continue block1;
                        }
                        torem.add(new VV3(x2, y, z));
                    }
                }
                if (failed) {
                    failed = false;
                    ix = lx;
                } else {
                    lx = ix++;
                    allrem.addAll(torem);
                }
                torem.clear();
            }
            if (lz != iz) {
                int z2 = sz + iz;
                block3: for (x = sx; x < sx + lx + 1; ++x) {
                    for (int y = sy; y < sy + ly + 1; ++y) {
                        if (!this.contains(x, y, z2)) {
                            failed = true;
                            continue block3;
                        }
                        torem.add(new VV3(x, y, z2));
                    }
                }
                if (failed) {
                    failed = false;
                    iz = lz;
                } else {
                    lz = iz++;
                    allrem.addAll(torem);
                }
                torem.clear();
            }
            if (ly == iy) continue;
            int y = sy + iy;
            block5: for (x = sx; x < sx + lx + 1; ++x) {
                for (z = sz; z < sz + lz + 1; ++z) {
                    if (!this.contains(x, y, z)) {
                        failed = true;
                        continue block5;
                    }
                    torem.add(new VV3(x, y, z));
                }
            }
            if (failed) {
                failed = false;
                iy = ly;
            } else {
                ly = iy++;
                allrem.addAll(torem);
            }
            torem.clear();
        } while (lx != ix || ly != iy || lz != iz);
        this.removeAll(allrem);
        return new int[]{sx, sy, sz, sx + ix, sy + iy, sz + iz};
    }

    private boolean contains(int x, int y, int z) {
        if (x >= this.segx || y >= this.segy || z >= this.segz) {
            return false;
        }
        return this.data[x][y][z] != null && this.data[x][y][z] != false;
    }

    private void removeAll(ArrayList<VV3> torem) {
        for (VV3 w3 : torem) {
            this.data[((VV3)w3).x][((VV3)w3).y][((VV3)w3).z] = null;
        }
    }

    private static final class VV3 {
        private int x;
        private int y;
        private int z;

        public VV3(int x2, int y2, int z2) {
            this.x = x2;
            this.y = y2;
            this.z = z2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VV3)) {
                return false;
            }
            VV3 xel = (VV3)obj;
            return xel.x == this.x && xel.y == this.y && xel.z == this.z;
        }
    }
}

