/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl.ui;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fcl.ui.ManageConfigCon;
import net.fexcraft.mod.uni.ConfigBase;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class SelCatConfig
extends UserInterface {
    private ConfigBase config;
    private ArrayList<String> cats;
    private int scroll;

    public SelCatConfig(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
    }

    @Override
    public void init() {
        this.config = ((ManageConfigCon)this.container).configs.get(this.container.pos.x);
        this.cats = new ArrayList<String>(this.config.getCategories().keySet());
        ((UIText)this.texts.get("title")).value("Categories: " + this.config.name());
    }

    @Override
    public void predraw(float ticks, int mx, int my) {
        if (this.cats == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int j = this.scroll + i;
            if (j >= this.cats.size()) {
                ((UIButton)this.buttons.get((Object)new StringBuilder().append((String)"entry_").append((int)i).toString())).text.value("");
                continue;
            }
            ((UIButton)this.buttons.get((Object)new StringBuilder().append((String)"entry_").append((int)i).toString())).text.value(this.cats.get(j));
        }
    }

    @Override
    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.equals("up")) {
            --this.scroll;
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            return true;
        }
        if (id.equals("down")) {
            ++this.scroll;
            return true;
        }
        if (id.startsWith("entry_")) {
            int idx = Integer.parseInt(id.substring(6));
            if ((idx += this.scroll) < 0 || idx >= this.cats.size()) {
                return true;
            }
            TagCW com = TagCW.create();
            com.set("mod", this.config.name());
            com.set("cat", this.cats.get(idx));
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }

    @Override
    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.scroll += am;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        return true;
    }

    @Override
    public void getTooltip(int mx, int my, List<String> list) {
        for (int i = 0; i < 6; ++i) {
            int j = this.scroll + i;
            if (j >= this.cats.size() || !((UIButton)this.buttons.get("entry_" + i)).hovered()) continue;
            list.add(ContainerInterface.TRANSFORMAT.apply("ui.fcl.config.entries", new Object[]{this.config.getCategoryEntries(j).size()}));
        }
    }

    @Override
    public boolean keytyped(char c, int code) {
        if (code == 1) {
            TagCW com = TagCW.create();
            com.set("main", true);
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }
}

