/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.app.json;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonValue;

public class JsonMap
extends JsonValue<Map<String, JsonValue<?>>> {
    public JsonMap() {
        this.value = new LinkedHashMap();
    }

    public JsonMap(Object ... elms) {
        this();
        for (int i = 0; i < elms.length && i + 1 < elms.length; i += 2) {
            if (elms[i + 1] instanceof JsonValue) {
                this.add(elms[i].toString(), (JsonValue)elms[i + 1]);
                continue;
            }
            this.add(elms[i].toString(), new JsonValue<Object>(elms[i + 1]));
        }
    }

    public <V> JsonValue<V> get(String key) {
        return (JsonValue)((Map)this.value).get(key);
    }

    public JsonArray getArray(String key) {
        return ((JsonValue)((Map)this.value).get(key)).asArray();
    }

    public JsonArray getArray(String key, int size) {
        if (!((Map)this.value).containsKey(key)) {
            ((Map)this.value).put(key, new JsonArray(size));
        }
        return ((JsonValue)((Map)this.value).get(key)).asArray();
    }

    public List<JsonValue<?>> getArrayElements(String key) {
        return this.getArray(key).elements();
    }

    public JsonMap getMap(String key) {
        if (!((Map)this.value).containsKey(key)) {
            this.addMap(key);
        }
        return ((JsonValue)((Map)this.value).get(key)).asMap();
    }

    public JsonValue<?> add(String key, JsonValue<?> elm) {
        return ((Map)this.value).put(key, elm);
    }

    public JsonValue<?> rem(String key) {
        return (JsonValue)((Map)this.value).remove(key);
    }

    public boolean has(String key) {
        return ((Map)this.value).containsKey(key);
    }

    public boolean has(boolean any, String ... keys) {
        for (String key : keys) {
            if (((Map)this.value).containsKey(key)) {
                if (!any) continue;
                return true;
            }
            if (any) continue;
            return false;
        }
        return !any;
    }

    public boolean contains(JsonValue<?> val) {
        return ((Map)this.value).containsValue(val);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    public JsonValue<?> add(String key, String val) {
        return this.add(key, new JsonValue<String>(val));
    }

    public JsonValue<?> add(String key, byte val) {
        return this.add(key, new JsonValue<Byte>(val));
    }

    public JsonValue<?> add(String key, char val) {
        return this.add(key, new JsonValue<Character>(Character.valueOf(val)));
    }

    public JsonValue<?> add(String key, short val) {
        return this.add(key, new JsonValue<Short>(val));
    }

    public JsonValue<?> add(String key, int val) {
        return this.add(key, new JsonValue<Integer>(val));
    }

    public JsonValue<?> add(String key, long val) {
        return this.add(key, new JsonValue<Long>(val));
    }

    public JsonValue<?> add(String key, float val) {
        return this.add(key, new JsonValue<Float>(Float.valueOf(val)));
    }

    public JsonValue<?> add(String key, double val) {
        return this.add(key, new JsonValue<Double>(val));
    }

    public JsonValue<?> add(String key, boolean val) {
        return this.add(key, new JsonValue<Boolean>(val));
    }

    public JsonValue<?> addArray(String key) {
        return this.add(key, new JsonArray());
    }

    public JsonValue<?> addMap(String key) {
        return this.add(key, new JsonMap());
    }

    public int size() {
        return ((Map)this.value).size();
    }

    public boolean empty() {
        return ((Map)this.value).size() == 0;
    }

    public boolean not_empty() {
        return ((Map)this.value).size() > 0;
    }

    public Set<Map.Entry<String, JsonValue<?>>> entries() {
        return ((Map)this.value).entrySet();
    }

    @Override
    public String toString() {
        return JsonHandler.toString(this);
    }

    public <V> V get(String key, V def) {
        return (V)(((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).value() : def);
    }

    public float getFloat(String key, float def) {
        return ((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).float_value() : def;
    }

    public Float getFloat(String key, Float def) {
        return Float.valueOf(((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).float_value() : def.floatValue());
    }

    public int getInteger(String key, int def) {
        return ((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).integer_value() : def;
    }

    public long getLong(String key, long def) {
        return ((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).long_value() : def;
    }

    public long getLongTime(String key) {
        return ((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).long_value() : new Date().getTime();
    }

    public String getString(String key, String def) {
        return ((Map)this.value).containsKey(key) ? ((JsonValue)((Map)this.value).get(key)).string_value() : def;
    }

    public boolean getBoolean(String key, boolean def) {
        return ((Map)this.value).containsKey(key) ? (Boolean)((JsonValue)((Map)this.value).get(key)).value() : def;
    }

    public UUID getUUID(String key, UUID def) {
        return ((Map)this.value).containsKey(key) ? UUID.fromString(((JsonValue)((Map)this.value).get(key)).string_value()) : def;
    }

    public JsonMap copy() {
        JsonMap map = new JsonMap();
        for (Map.Entry<String, JsonValue<?>> entry : this.entries()) {
            map.add(entry.getKey(), entry.getValue().copy());
        }
        return map;
    }
}

