/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import java.util.function.Supplier;
import net.fexcraft.lib.common.math.MV3D;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.RotationOrder;

public abstract class M4DW {
    public static Supplier<M4DW> SUPPLIER = null;
    protected RotationOrder order = RotationOrder.YXZ;
    public double yaw;
    public double pit;
    public double rol;

    public static M4DW create() {
        return SUPPLIER.get();
    }

    public V3D rotate(V3D vec, V3D des) {
        this.reset(vec);
        this.rotateYPR();
        return this.fill(des);
    }

    public V3D rotate(V3D vec) {
        return this.rotate(vec, new V3D());
    }

    public V3D rotateM(V3D vec) {
        return this.rotate(vec, new MV3D());
    }

    public V3D rotate(double x, double y, double z, V3D des) {
        this.reset(x, y, z);
        this.rotateYPR();
        return this.fill(des);
    }

    public V3D rotate(double x, double y, double z) {
        return this.rotate(x, y, z, new V3D());
    }

    public V3D rotateM(double x, double y, double z) {
        return this.rotate(x, y, z, new MV3D());
    }

    protected abstract V3D fill(V3D var1);

    public abstract void rotate(double var1, int var3);

    private void rotateYPR() {
        if (this.rol != 0.0) {
            this.rotate(this.rol, this.order.axid[2]);
        }
        if (this.pit != 0.0) {
            this.rotate(this.pit, this.order.axid[1]);
        }
        if (this.yaw != 0.0) {
            this.rotate(this.yaw, this.order.axid[0]);
        }
    }

    public void setRadians(double y, double p, double r) {
        this.reset(1.0, 0.0, 0.0);
        this.yaw = y;
        this.pit = p;
        this.rol = r;
        this.rotateYPR();
        this.norm();
    }

    public void setDegrees(double y, double p, double r) {
        this.setRadians(Math.toRadians(y), Math.toRadians(p), Math.toRadians(r));
    }

    public void addRadians(double y, double p, double r) {
        this.reset(1.0, 0.0, 0.0);
        this.yaw += y;
        this.pit += p;
        this.rol += r;
        this.rotateYPR();
        this.norm();
    }

    public void addDegrees(double y, double p, double r) {
        this.addRadians(Math.toRadians(y), Math.toRadians(p), Math.toRadians(r));
    }

    protected void reset(V3D vec) {
        this.reset(vec.x, vec.y, vec.z);
    }

    protected abstract void reset(double var1, double var3, double var5);

    protected abstract void norm();

    public String toString() {
        return String.format("M4DW[ %sy, %sp, %sr ]", this.yaw, this.pit, this.rol);
    }

    public void pointing(V3D fm, V3D to) {
        double dx = to.x - fm.x;
        double dy = to.y - fm.y;
        double dz = to.z - fm.z;
        double dxz = Math.sqrt(dx * dx + dz * dz);
        this.yaw = (float)Math.atan2(dz, dx);
        this.pit = (float)(-Math.atan2(dy, dxz));
        this.rol = 0.0;
        this.reset(1.0, 0.0, 0.0);
        this.rotateYPR();
        this.norm();
    }
}

