/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.tmt.CustomUVBuilder;
import net.fexcraft.lib.tmt.ModelRendererTurbo;

public class CylinderBuilder
implements CustomUVBuilder {
    private ModelRendererTurbo root;
    private float x;
    private float y;
    private float z;
    private float radius;
    private float radius2;
    private float radius3;
    private float radius4;
    private float length;
    private float base_scale = 1.0f;
    private float top_scale = 1.0f;
    private float segoff;
    private int segments;
    private int seglimit;
    private int direction;
    private Vec3f topoff = new Vec3f();
    private boolean[] invisible = new boolean[6];
    private float[][] uv = new float[6][];
    private boolean[] detached = new boolean[6];
    private AxisRotator toprot;
    private boolean radialtexture = false;
    private float seg_width;
    private float seg_height;

    public CylinderBuilder(ModelRendererTurbo root) {
        this.root = root == null ? new ModelRendererTurbo(null) : root;
    }

    public CylinderBuilder setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public CylinderBuilder setRadius(float first, float second) {
        this.radius = first;
        this.radius2 = second;
        return this;
    }

    public CylinderBuilder setRadius(float first_s, float first_c, float second_s, float second_c) {
        this.radius = first_s;
        this.radius2 = second_s;
        this.radius3 = first_c;
        this.radius4 = second_c;
        return this;
    }

    public CylinderBuilder setLength(float length) {
        this.length = length;
        return this;
    }

    public CylinderBuilder setTopOffset(float x, float y, float z) {
        this.topoff = new Vec3f(x, y, z);
        return this;
    }

    public CylinderBuilder setTopOffset(Vec3f vec) {
        this.topoff = vec;
        return this;
    }

    @Deprecated
    public CylinderBuilder setSidesVisible(boolean[] arr) {
        return this.removePolygons(arr);
    }

    @Deprecated
    public CylinderBuilder setSidesVisible(boolean base, boolean top, boolean outer, boolean inner) {
        return this.removePolygons(base, top, outer, inner);
    }

    @Override
    public CylinderBuilder removePolygon(int index) {
        if (index < 0 || index > 5) {
            return this;
        }
        this.invisible[index] = true;
        return this;
    }

    @Override
    public CylinderBuilder removePolygons(int ... poly_indices) {
        for (int index : poly_indices) {
            if (index < 0 || index > 5) continue;
            this.invisible[index] = true;
        }
        return this;
    }

    @Override
    public CylinderBuilder removePolygons(boolean ... sides) {
        for (int index = 0; index < 6; ++index) {
            if (sides.length < index + 1 || !sides[index]) continue;
            this.invisible[index] = true;
        }
        return this;
    }

    @Override
    public CylinderBuilder setPolygonUV(int poly_index, float[] uv) {
        if (poly_index < 0 || poly_index > 5) {
            return this;
        }
        this.uv[poly_index] = uv;
        return this;
    }

    @Override
    public CylinderBuilder setPolygonUVs(int[] poly_indices, float[][] uvs) {
        for (int i = 0; i < poly_indices.length; ++i) {
            if (poly_indices[i] < 0 || poly_indices[i] > 5) continue;
            this.setPolygonUV(poly_indices[i], uvs[i]);
        }
        return this;
    }

    @Override
    public CylinderBuilder setPolygonUVs(float[][] uvs) {
        for (int index = 0; index < 6 && index < uvs.length; ++index) {
            this.setPolygonUV(index, uvs[index]);
        }
        return this;
    }

    @Override
    public CylinderBuilder setDetachedUV(int ... indices) {
        for (int index : indices) {
            if (index < 0 || index > 5) continue;
            this.detached[index] = true;
        }
        return this;
    }

    @Override
    public CylinderBuilder setDetachedUV(boolean ... bools) {
        int index = 0;
        while (index < 6 && index < bools.length) {
            this.setDetachedUV(index++);
        }
        return this;
    }

    private boolean detached(int i) {
        return this.invisible[i] || this.detached[i];
    }

    public CylinderBuilder setSegments(int amount, int limit) {
        this.segments = amount;
        this.seglimit = limit;
        return this;
    }

    public CylinderBuilder setSegments(int amount, int limit, float off) {
        this.segments = amount;
        this.seglimit = limit;
        this.segoff = off;
        return this;
    }

    public CylinderBuilder setSegmentOffset(float off) {
        this.segoff = off;
        return this;
    }

    public CylinderBuilder setScale(float base, float top) {
        this.base_scale = base;
        this.top_scale = top;
        return this;
    }

    public CylinderBuilder setRadialTexture(float seg_width, float seg_height) {
        if (seg_width <= 0.0f || seg_height <= 0.0f) {
            return this;
        }
        this.radialtexture = true;
        this.seg_width = seg_width;
        this.seg_height = seg_height;
        return this;
    }

    public CylinderBuilder setDirection(int dir) {
        this.direction = dir;
        return this;
    }

    public CylinderBuilder setTopRotation(float x, float y, float z) {
        this.toprot = AxisRotator.newDefInstance();
        this.toprot.setAngles(x, y, z);
        return this;
    }

    public CylinderBuilder setTopRotation(Vec3f vec) {
        return this.setTopRotation(vec.x, vec.y, vec.z);
    }

    public ModelRendererTurbo build() {
        boolean dirMirror;
        boolean segl;
        if (this.radius3 == 0.0f) {
            this.radius3 = this.radius;
        }
        if (this.radius4 == 0.0f) {
            this.radius4 = this.radius2;
        }
        if (this.segments < 3) {
            this.segments = 3;
        }
        if (this.seglimit <= 0) {
            this.seglimit = this.segments;
        }
        boolean bl = segl = this.seglimit < this.segments;
        if (this.radius2 == 0.0f && this.toprot == null && !segl && this.radius3 == this.radius) {
            return this.root.addCylinder(this.x, this.y, this.z, this.radius, this.length, this.segments, this.base_scale, this.top_scale, this.direction, (int)Math.floor(this.radius * 2.0f), (int)Math.floor(this.radius * 2.0f), (int)Math.floor(this.length), this.topoff);
        }
        float diameter = (int)Math.floor(this.radius * 2.0f);
        float texheight = (int)Math.floor(this.length);
        if (this.radius < 1.0f) {
            int rad;
            int n = rad = (double)this.radius < 0.5 ? 1 : 2;
            if (diameter < (float)rad) {
                diameter = rad;
            }
        }
        if (this.length < 1.0f) {
            texheight = 1.0f;
        } else if (this.length % 1.0f != 0.0f) {
            texheight = (int)this.length + (this.length % 1.0f > 0.5f ? 1 : 0);
        }
        boolean dirTop = this.direction == 4 || this.direction == 5;
        boolean dirSide = this.direction == 3 || this.direction == 2;
        boolean dirFront = this.direction == 0 || this.direction == 1;
        boolean bl2 = dirMirror = this.direction == 2 || this.direction == 5 || this.direction == 1;
        if (this.base_scale == 0.0f) {
            this.base_scale = 1.0f;
        }
        if (this.top_scale == 0.0f) {
            this.invisible[1] = true;
        }
        ArrayList<TexturedPolygon> polis = new ArrayList<TexturedPolygon>();
        float xLength = dirSide ? this.length : 0.0f;
        float yLength = dirTop ? this.length : 0.0f;
        float zLength = dirFront ? this.length : 0.0f;
        float xStart = dirMirror ? this.x + xLength : this.x;
        float yStart = dirMirror ? this.y + yLength : this.y;
        float zStart = dirMirror ? this.z + zLength : this.z;
        float xEnd = (!dirMirror ? this.x + xLength : this.x) + (this.topoff == null ? 0.0f : this.topoff.x);
        float yEnd = (!dirMirror ? this.y + yLength : this.y) + (this.topoff == null ? 0.0f : this.topoff.y);
        float zEnd = (!dirMirror ? this.z + zLength : this.z) + (this.topoff == null ? 0.0f : this.topoff.z);
        float xCur = xStart;
        float yCur = yStart;
        float zCur = zStart;
        float sCur = this.base_scale;
        float[][] uvs = new float[6][];
        float uScale = 1.0f / this.root.textureWidth;
        float vScale = 1.0f / this.root.textureHeight;
        float uCircle = diameter * uScale;
        float vCircle = diameter * vScale;
        float uCircle2 = (float)((int)Math.floor(this.radius2 * 2.0f)) * uScale;
        float vCircle2 = (float)((int)Math.floor(this.radius2 * 2.0f)) * vScale;
        float vHeight = texheight * vScale;
        float uSeg = this.radius - this.radius2;
        if (uSeg < 1.0f) {
            uSeg = 1.0f;
        } else if (uSeg % 1.0f != 0.0f) {
            uSeg = (int)uSeg + (uSeg % 1.0f > 0.5f ? 1 : 0);
        }
        uSeg *= uScale;
        float x = (float)this.root.texoffx * uScale;
        float y = (float)this.root.texoffy * vScale;
        uvs[0] = new float[]{x, y};
        uvs[1] = new float[]{x + (this.detached(0) || this.radialtexture ? 0.0f : uCircle), y + (this.radialtexture && !this.detached(0) ? this.seg_height : 0.0f)};
        float cirhi = this.detached(0) && this.detached(1) ? 0.0f : (this.radialtexture ? this.seg_height * (float)(this.detached(0) || this.detached(1) ? 1 : 2) * vScale : vCircle);
        float cirwi = this.detached(2) && this.detached(3) ? 0.0f : uCircle + uCircle;
        uvs[2] = new float[]{x, y + cirhi};
        uvs[3] = new float[]{x, y + cirhi + (this.detached(2) ? 0.0f : vHeight)};
        uvs[4] = new float[]{x + cirwi, y + cirhi};
        uvs[5] = new float[]{x + cirwi + (this.detached(2) || this.detached(3) ? uSeg : 0.0f), y + cirhi + (this.detached(2) || this.detached(3) ? 0.0f : vHeight)};
        for (int i = 0; i < this.uv.length; ++i) {
            if (this.invisible[i] || this.uv[i] == null || this.uv[i].length != 2) continue;
            uvs[i][0] = this.uv[i][0] * uScale;
            uvs[i][1] = this.uv[i][1] * vScale;
            if (this.detached[i]) continue;
            float[] fArray = uvs[i];
            fArray[0] = fArray[0] + x;
            float[] fArray2 = uvs[i];
            fArray2[1] = fArray2[1] + y;
        }
        float uWidth = uCircle * 2.0f / (float)this.segments;
        float segpi = (float)Math.PI / (float)this.segments;
        ArrayList<TexturedVertex> verts0 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts1 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts2 = new ArrayList<TexturedVertex>();
        ArrayList<TexturedVertex> verts3 = new ArrayList<TexturedVertex>();
        for (int repeat = 0; repeat < 2; ++repeat) {
            boolean bool;
            for (int index = 0; index < this.segments; ++index) {
                float xSize = (float)((double)(this.root.mirror ^ dirMirror ? -1 : 1) * Math.sin(segpi * (float)index * 2.0f + (float)Math.PI + this.segoff) * (double)this.radius * (double)sCur);
                float zSize = (float)(-Math.cos(segpi * (float)index * 2.0f + (float)Math.PI + this.segoff) * (double)this.radius3 * (double)sCur);
                float xPlace = xCur + (!dirSide ? xSize : 0.0f);
                float yPlace = yCur + (!dirTop ? zSize : 0.0f);
                float zPlace = zCur + (dirSide ? xSize : (dirTop ? zSize : 0.0f));
                verts0.add(new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f));
                if (index == this.segments - 1) {
                    TexturedVertex copy = new TexturedVertex((TexturedVertex)verts0.get(0));
                    verts0.add(copy);
                }
                float xSize2 = (float)((double)(this.root.mirror ^ dirMirror ? -1 : 1) * Math.sin(segpi * (float)index * 2.0f + (float)Math.PI + this.segoff) * (double)this.radius2 * (double)sCur);
                float zSize2 = (float)(-Math.cos(segpi * (float)index * 2.0f + (float)Math.PI + this.segoff) * (double)this.radius4 * (double)sCur);
                xPlace = xCur + (!dirSide ? xSize2 : 0.0f);
                yPlace = yCur + (!dirTop ? zSize2 : 0.0f);
                zPlace = zCur + (dirSide ? xSize2 : (dirTop ? zSize2 : 0.0f));
                verts1.add(new TexturedVertex(xPlace, yPlace, zPlace, 0.0f, 0.0f));
                if (index != this.segments - 1) continue;
                TexturedVertex copy = new TexturedVertex((TexturedVertex)verts1.get(0));
                verts1.add(copy);
            }
            if (repeat == 0) {
                verts2.addAll(verts0);
                verts2.addAll(verts1);
            } else {
                verts3.addAll(verts0);
                verts3.addAll(verts1);
            }
            boolean bl3 = repeat == 0 ? !dirFront : (bool = dirFront);
            if (!this.invisible[repeat]) {
                for (int i = 0; i < verts0.size(); ++i) {
                    if (i >= verts0.size() - 1 || i >= this.seglimit) {
                        if (repeat == 0 || this.toprot == null) break;
                        ((TexturedVertex)verts0.get((int)i)).vector = this.toprot.getRelativeVector(((TexturedVertex)verts0.get((int)i)).vector);
                        ((TexturedVertex)verts1.get((int)i)).vector = this.toprot.getRelativeVector(((TexturedVertex)verts1.get((int)i)).vector);
                        break;
                    }
                    TexturedVertex[] arr = new TexturedVertex[4];
                    if (!this.radialtexture) {
                        double xSize = Math.sin(segpi * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle);
                        double ySize = Math.cos(segpi * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle);
                        arr[0] = ((TexturedVertex)verts0.get(i)).setTexturePosition((double)(uvs[repeat][0] + 0.5f * uCircle) + xSize, (double)(uvs[repeat][1] + 0.5f * vCircle) + ySize);
                        xSize = Math.sin(segpi * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle2);
                        ySize = Math.cos(segpi * (float)i * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle2);
                        arr[1] = ((TexturedVertex)verts1.get(i)).setTexturePosition((double)(uvs[repeat][0] + 0.5f * uCircle) + xSize, (double)(uvs[repeat][1] + 0.5f * vCircle) + ySize);
                        xSize = Math.sin(segpi * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle2);
                        ySize = Math.cos(segpi * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle2);
                        arr[2] = ((TexturedVertex)verts1.get(i + 1)).setTexturePosition((double)(uvs[repeat][0] + 0.5f * uCircle) + xSize, (double)(uvs[repeat][1] + 0.5f * vCircle) + ySize);
                        xSize = Math.sin(segpi * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * uCircle);
                        ySize = Math.cos(segpi * (float)(i + 1) * 2.0f + (!dirTop ? 0.0f : (float)Math.PI)) * (double)(0.5f * vCircle);
                        arr[3] = ((TexturedVertex)verts0.get(i + 1)).setTexturePosition((double)(uvs[repeat][0] + 0.5f * uCircle) + xSize, (double)(uvs[repeat][1] + 0.5f * vCircle) + ySize);
                    } else {
                        float diff = uSeg / 4.0f;
                        arr[0] = ((TexturedVertex)verts0.get(i)).setTexturePosition(uvs[repeat][0] + (float)i * this.seg_width * uScale, uvs[repeat][1]);
                        arr[1] = ((TexturedVertex)verts1.get(i)).setTexturePosition(uvs[repeat][0] + (float)i * this.seg_width * uScale + diff, uvs[repeat][1] + this.seg_height * vScale);
                        arr[2] = ((TexturedVertex)verts1.get(i + 1)).setTexturePosition(uvs[repeat][0] + (float)(i + 1) * this.seg_width * uScale - diff, uvs[repeat][1] + this.seg_height * vScale);
                        arr[3] = ((TexturedVertex)verts0.get(i + 1)).setTexturePosition(uvs[repeat][0] + (float)(i + 1) * this.seg_width * uScale, uvs[repeat][1]);
                    }
                    if (repeat != 0 && this.toprot != null) {
                        arr[0].vector = ((TexturedVertex)verts0.get((int)i)).vector = this.toprot.getRelativeVector(arr[0].vector);
                        arr[1].vector = ((TexturedVertex)verts1.get((int)i)).vector = this.toprot.getRelativeVector(arr[1].vector);
                        arr[2].vector = this.toprot.getRelativeVector(arr[2].vector);
                        arr[3].vector = this.toprot.getRelativeVector(arr[3].vector);
                    }
                    polis.add(new TexturedPolygon(arr));
                    if (!bool) continue;
                    polis.get(polis.size() - 1).flipFace();
                }
            }
            verts0.clear();
            verts1.clear();
            xCur = xEnd;
            yCur = yEnd;
            zCur = zEnd;
            sCur = this.top_scale;
        }
        int halfv2 = verts2.size() / 2;
        for (int i = 0; i < halfv2; ++i) {
            if (i >= this.seglimit && segl) {
                if (!this.invisible[4]) {
                    TexturedVertex[] arr = new TexturedVertex[]{((TexturedVertex)verts2.get(0)).setTexturePosition(uvs[4][0], uvs[4][1]), ((TexturedVertex)verts3.get(0)).setTexturePosition(uvs[4][0], uvs[4][1] + vHeight), ((TexturedVertex)verts3.get(halfv2)).setTexturePosition(uvs[4][0] + uSeg, uvs[4][1] + vHeight), ((TexturedVertex)verts2.get(halfv2)).setTexturePosition(uvs[4][0] + uSeg, uvs[4][1])};
                    polis.add(new TexturedPolygon(arr));
                    if (!dirFront) {
                        polis.get(polis.size() - 1).flipFace();
                    }
                }
                if (this.invisible[5]) break;
                TexturedVertex[] arr = new TexturedVertex[]{((TexturedVertex)verts2.get(this.seglimit)).setTexturePosition(uvs[5][0], uvs[5][1]), ((TexturedVertex)verts3.get(this.seglimit)).setTexturePosition(uvs[5][0], uvs[5][1] + vHeight), ((TexturedVertex)verts3.get(this.seglimit + halfv2)).setTexturePosition(uvs[5][0] + uSeg, uvs[5][1] + vHeight), ((TexturedVertex)verts2.get(this.seglimit + halfv2)).setTexturePosition(uvs[5][0] + uSeg, uvs[5][1])};
                polis.add(new TexturedPolygon(arr));
                if (!dirFront) break;
                polis.get(polis.size() - 1).flipFace();
                break;
            }
            if (i >= halfv2 - 1) break;
            TexturedVertex[] arr = new TexturedVertex[4];
            if (!this.invisible[2]) {
                arr[0] = ((TexturedVertex)verts2.get(i + 0)).setTexturePosition(uvs[2][0] + uWidth * (float)(i + 0), uvs[2][1]);
                arr[1] = ((TexturedVertex)verts3.get(i + 0)).setTexturePosition(uvs[2][0] + uWidth * (float)(i + 0), uvs[2][1] + vHeight);
                arr[2] = ((TexturedVertex)verts3.get(i + 1)).setTexturePosition(uvs[2][0] + uWidth * (float)(i + 1), uvs[2][1] + vHeight);
                arr[3] = ((TexturedVertex)verts2.get(i + 1)).setTexturePosition(uvs[2][0] + uWidth * (float)(i + 1), uvs[2][1]);
                polis.add(new TexturedPolygon(arr));
                if (dirFront) {
                    polis.get(polis.size() - 1).flipFace();
                }
            }
            if (this.invisible[3]) continue;
            arr = new TexturedVertex[]{((TexturedVertex)verts2.get(i + halfv2 + 0)).setTexturePosition(uvs[3][0] + uWidth * (float)(i + 0), uvs[3][1]), ((TexturedVertex)verts3.get(i + halfv2 + 0)).setTexturePosition(uvs[3][0] + uWidth * (float)(i + 0), uvs[3][1] + vHeight), ((TexturedVertex)verts3.get(i + halfv2 + 1)).setTexturePosition(uvs[3][0] + uWidth * (float)(i + 1), uvs[3][1] + vHeight), ((TexturedVertex)verts2.get(i + halfv2 + 1)).setTexturePosition(uvs[3][0] + uWidth * (float)(i + 1), uvs[3][1])};
            polis.add(new TexturedPolygon(arr));
            if (dirFront) continue;
            polis.get(polis.size() - 1).flipFace();
        }
        return this.root.copyTo(polis);
    }

    public ModelRendererTurbo getRoot() {
        return this.root;
    }
}

