/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.crafting.RecipeRegistry;
import net.fexcraft.lib.mc.gui.ClientReceiver;
import net.fexcraft.lib.mc.gui.GuiHandler;
import net.fexcraft.lib.mc.gui.ServerReceiver;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.SimpleUpdateHandler;
import net.fexcraft.lib.mc.registry.CreativeTab;
import net.fexcraft.lib.mc.registry.FCLRegistry;
import net.fexcraft.lib.mc.render.FCLBlockModel;
import net.fexcraft.lib.mc.render.FCLBlockModelLoader;
import net.fexcraft.lib.mc.render.LoaderReg;
import net.fexcraft.lib.mc.utils.Axis3DL;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.fcl.mixint.CWProvider;
import net.fexcraft.mod.fcl.mixint.EWProvider;
import net.fexcraft.mod.fcl.mixint.SWProvider;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.UniChunk;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.UniReg;
import net.fexcraft.mod.uni.impl.IWI;
import net.fexcraft.mod.uni.impl.PacketFileHandler;
import net.fexcraft.mod.uni.impl.SWI;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.impl.TagLWI;
import net.fexcraft.mod.uni.impl.UniFluidTank12;
import net.fexcraft.mod.uni.impl.UniInventory12;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniFluidTank;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIPacketListener;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UUIButton;
import net.fexcraft.mod.uni.ui.UUIField;
import net.fexcraft.mod.uni.ui.UUITab;
import net.fexcraft.mod.uni.ui.UUIText;
import net.fexcraft.mod.uni.util.OnPlayerClone;
import net.fexcraft.mod.uni.world.ChunkWI;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.EntityWI;
import net.fexcraft.mod.uni.world.WorldWI;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.fexcraft.mod.uni.world.WrapperHolderImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="fcl", name="Fexcraft Common Library", version="12.xx", acceptableRemoteVersions="*", acceptedMinecraftVersions="*", updateJSON="http://fexcraft.net/minecraft/fcl/request?mode=getForgeUpdateJson&modid=fcl")
public class FCL {
    public static final String prefix = TextFormatting.BLACK + "[" + TextFormatting.DARK_AQUA + "FCL" + TextFormatting.BLACK + "]" + TextFormatting.GRAY + " ";
    public static final String version = "12.xx";
    public static final String mcv = "1.12.2";
    public static final UUID[] authors = new UUID[]{UUID.fromString("01e4af9b-2a30-471e-addf-f6338ffce04b")};
    public static final Logger LOGGER = LogManager.getLogger((String)"FCL");
    @Mod.Instance(value="fcl")
    private static FCL instance;
    public static UniFCL CONFIG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        EnvInfo.CLIENT = event.getSide().isClient();
        EnvInfo.DEV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        UniReg.LOADER_VERSION = "1.12";
        TagCW.SUPPLIER[0] = () -> new TagCWI();
        TagCW.WRAPPER[0] = obj -> new TagCWI(obj);
        TagLW.SUPPLIER[0] = () -> new TagLWI();
        TagLW.WRAPPER[0] = obj -> new TagLWI(obj);
        UniEntity.ENTITY_GETTER = ent -> new EntityWI((Entity)ent);
        UniChunk.CHUNK_GETTER = ck -> new ChunkWI((Chunk)ck);
        UniStack.STACK_GETTER = obj -> SWI.parse(obj);
        UniStack.TAG_GETTER = key -> {
            ArrayList<StackWrapper> list = new ArrayList<StackWrapper>();
            NonNullList stacks = OreDictionary.getOres((String)key);
            for (ItemStack stack : stacks) {
                list.add(UniStack.getStack(stack.func_77946_l()));
            }
            return list;
        };
        WrapperHolder.INSTANCE = new WrapperHolderImpl();
        WrapperHolder.LEVEL_PROVIDER = lvl -> new WorldWI((World)lvl);
        ItemWrapper.GETTER = id -> (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
        ItemWrapper.SUPPLIER = item -> new IWI((Item)item);
        StackWrapper.ITEM_TYPES.put(StackWrapper.IT_LEAD, item -> item instanceof ItemLead);
        StackWrapper.ITEM_TYPES.put(StackWrapper.IT_FOOD, item -> item instanceof ItemFood);
        UniInventory.IMPL = UniInventory12.class;
        UniFluidTank.IMPL = UniFluidTank12.class;
        if (EnvInfo.CLIENT) {
            UITab.IMPLEMENTATION = UUITab.class;
            UIButton.IMPLEMENTATION = UUIButton.class;
            UIText.IMPLEMENTATION = UUIText.class;
            UIField.IMPLEMENTATION = UUIField.class;
            ContainerInterface.TRANSLATOR = str -> Formatter.format(I18n.func_135052_a((String)str, (Object[])new Object[0]));
            ContainerInterface.TRANSFORMAT = (str, objs) -> Formatter.format(I18n.func_135052_a((String)str, (Object[])objs));
        }
        CONFIG = new UniFCL(event.getModConfigurationDirectory());
        UISlot.GETTERS.put("default", args -> new Slot((IInventory)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], (Object[])args){
            final /* synthetic */ Object[] val$args;
            {
                this.val$args = objectArray;
                super(x0, x1, x2, x3);
            }

            public boolean func_75214_a(ItemStack stack) {
                if (this.val$args[0] instanceof UniInventory) {
                    return ((UniInventory12)this.val$args[0]).valid((Integer)this.val$args[1], UniStack.getStack(stack));
                }
                return super.func_75214_a(stack);
            }
        });
        UniFCL.registerFCLUI(instance);
        FclRecipe.VALIDATE = comp -> {
            if (comp.tag) {
                return OreDictionary.doesOreNameExist((String)comp.id);
            }
            return !comp.stack.empty();
        };
        FclRecipe.GET_TAG_AS_LIST = comp -> {
            ArrayList<StackWrapper> list = new ArrayList<StackWrapper>();
            NonNullList stacks = OreDictionary.getOres((String)comp.id);
            for (ItemStack stack : stacks) {
                StackWrapper wrapper = UniStack.getStack(stack.func_77946_l());
                wrapper.count(comp.amount);
                list.add(wrapper);
            }
            return list;
        };
        FCLRegistry.prepare(event.getSide(), event.getAsmData());
        MinecraftForge.EVENT_BUS.register((Object)new OnPlayerClone());
        if (event.getSide().isClient()) {
            LoaderReg.ister();
            AxisRotator.DefHolder.DEF_IMPL = Axis3DL.class;
            FCLBlockModelLoader.addBlockModel(new ResourceLocation("fcl:models/block/crafting"), (FCLBlockModel)((Class)FCLRegistry.getModel("fcl:models/block/crafting")).newInstance());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws Exception {
        StackWrapper.EMPTY = new SWI(ItemStack.field_190927_a);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (UniFCL.EXAMPLE_RECIPES) {
            FclRecipe.newBuilder("recipe.fcl.testing").add(new ItemStack(Blocks.field_150347_e, 4)).output(new ItemStack(Blocks.field_150446_ar, 5)).register();
            FclRecipe.newBuilder("recipe.fcl.testing").add("ingotIron", 9).output(new ItemStack(Blocks.field_150339_S, 1)).register();
        }
        RecipeRegistry.addShapedRecipe("fcl:crafting", null, new ItemStack(FCLRegistry.getBlock("fcl:crafting"), 1), 3, 2, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150364_r)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150462_ai)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150364_r)}));
    }

    @Mod.EventHandler
    public void init(FMLServerStartingEvent event) {
        FCLRegistry.registerCommands(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws Exception {
        SimpleUpdateHandler.register("fcl", 1, version);
        SimpleUpdateHandler.setUpdateMessage("fcl", prefix + "Update available! (" + SimpleUpdateHandler.getLatestVersionOf("fcl") + ")");
        SimpleUpdateHandler.postInit();
        FCLRegistry.clear(event);
        PacketHandler.init();
        CreativeTab.getIcons();
        UniEntity.GETTER = ent -> ((EWProvider)ent).fcl_wrapper();
        UniChunk.GETTER = ck -> ((CWProvider)ck).fcl_wrapper();
        UniStack.GETTER = stk -> {
            ItemStack stack = (ItemStack)(stk instanceof StackWrapper ? ((StackWrapper)stk).direct() : stk);
            return ((SWProvider)stack).fcl_wrapper();
        };
        UniFCL.regTagPacketListener("fcl:ui", false, new UIPacketListener.Server());
        UniFCL.regTagPacketListener("fcl:gui", false, new ServerReceiver());
        if (event.getSide().isClient()) {
            UniFCL.regTagPacketListener("fcl:ui", true, new UIPacketListener.Client());
            UniFCL.regTagPacketListener("fcl:gui", true, new ClientReceiver());
        }
        Print.log("Loading complete.");
    }

    public static FCL getInstance() {
        return instance;
    }

    public static final String getVersion() {
        return version;
    }

    public static final String getMinecraftVersion() {
        return mcv;
    }

    public static void bindTex(IDL tex) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)tex.local());
    }

    public static void sendServerFile(EntityW player, String lis, String loc, byte[] tex) {
        if (player.isOnClient()) {
            PacketHandler.getInstance().sendToServer((IMessage)new PacketFileHandler.I12_PacketImg().fill(lis, loc));
        } else {
            PacketHandler.getInstance().sendTo((IMessage)new PacketFileHandler.I12_PacketImg().fill(lis, loc, tex), (EntityPlayerMP)player.local());
        }
    }

    public static IDL requestServerFile(String lis, String loc) {
        PacketHandler.getInstance().sendToServer((IMessage)new PacketFileHandler.I12_PacketImg().fill(lis, loc));
        return IDLManager.getIDLCached(loc);
    }

    public static void writeTag(ByteBuf buffer, TagCW com) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)com.local()));
    }

    public static TagCW readTag(ByteBuf buffer) {
        try {
            return TagCW.wrap(ByteBufUtils.readTag((ByteBuf)buffer));
        }
        catch (Exception e) {
            e.printStackTrace();
            return TagCW.create();
        }
    }
}

