/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl.ui;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fcl.ui.ManageConfigCon;
import net.fexcraft.mod.uni.ConfigBase;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class SelEntryConfig
extends UserInterface {
    private ConfigBase config;
    private String category;
    private ArrayList<ConfigBase.ConfigEntry> entries;
    private int scroll;

    public SelEntryConfig(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
    }

    @Override
    public void init() {
        this.config = ((ManageConfigCon)this.container).configs.get(this.container.pos.x);
        this.category = this.config.getCategoryByIndex(this.container.pos.y);
        this.entries = this.config.getCategories().get(this.category);
        ((UIText)this.texts.get("title")).value(this.config.name() + " / " + this.category);
    }

    @Override
    public void predraw(float ticks, int mx, int my) {
        if (this.entries == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int j = this.scroll + i;
            if (j >= this.entries.size()) {
                ((UIButton)this.buttons.get((Object)new StringBuilder().append((String)"entry_").append((int)i).toString())).text.value("");
                continue;
            }
            ((UIButton)this.buttons.get((Object)new StringBuilder().append((String)"entry_").append((int)i).toString())).text.value(this.entries.get((int)j).key);
        }
    }

    @Override
    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.equals("up")) {
            --this.scroll;
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            return true;
        }
        if (id.equals("down")) {
            ++this.scroll;
            return true;
        }
        if (id.startsWith("entry_")) {
            int idx = Integer.parseInt(id.substring(6));
            if ((idx += this.scroll) < 0 || idx >= this.entries.size()) {
                return true;
            }
            TagCW com = TagCW.create();
            com.set("mod", this.config.name());
            com.set("cat", this.category);
            com.set("ent", this.entries.get((int)idx).key);
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }

    @Override
    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.scroll += am;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        return true;
    }

    @Override
    public void getTooltip(int mx, int my, List<String> list) {
        for (int i = 0; i < 6; ++i) {
            int j = this.scroll + i;
            if (j >= this.entries.size() || !((UIButton)this.buttons.get("entry_" + i)).hovered()) continue;
            ConfigBase.ConfigEntry entry = this.entries.get(j);
            list.add("\u00a76" + this.category + "/" + entry.key);
            list.add("\u00a7e" + entry.info());
            list.add(ContainerInterface.TRANSFORMAT.apply("ui.fcl.config.value", new Object[]{this.asString(entry.value())}));
            list.add(ContainerInterface.TRANSFORMAT.apply("ui.fcl.config.default", new Object[]{this.asString(entry.initial())}));
            if (entry.min() != 0.0f || entry.max() != 0.0f) {
                list.add(ContainerInterface.TRANSFORMAT.apply("ui.fcl.config.range", new Object[]{RGB.df.format(entry.min()), RGB.df.format(entry.max())}));
            }
            if (entry.reqLevelRestart() == null) {
                list.add(ContainerInterface.TRANSLATOR.apply("ui.fcl.config.no_req_info"));
                continue;
            }
            if (entry.reqLevelRestart().booleanValue()) {
                list.add(ContainerInterface.TRANSLATOR.apply("ui.fcl.config.req_level_restart0"));
                list.add(ContainerInterface.TRANSLATOR.apply("ui.fcl.config.req_level_restart1"));
                continue;
            }
            if (entry.reqGameRestart().booleanValue()) {
                list.add(ContainerInterface.TRANSLATOR.apply("ui.fcl.config.req_game_restart"));
                continue;
            }
            list.add(ContainerInterface.TRANSLATOR.apply("ui.fcl.config.no_req_restart"));
            list.add(ContainerInterface.TRANSLATOR.apply("ui.fcl.config.no_req_restart_info"));
        }
    }

    private String asString(JsonValue value) {
        if (value.isMap()) {
            return "{ Json Object }";
        }
        if (value.isArray()) {
            return "[ Json Array ]";
        }
        return value.string_value();
    }

    @Override
    public boolean keytyped(char c, int code) {
        if (code == 1) {
            TagCW com = TagCW.create();
            com.set("mod", this.config.name());
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }
}

