/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.ui;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIElement;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UniUI;

public class UserInterface {
    public ContainerInterface container;
    public LinkedHashMap<String, UIText> texts = new LinkedHashMap();
    public LinkedHashMap<String, UIButton> buttons = new LinkedHashMap();
    public LinkedHashMap<String, UIField> fields = new LinkedHashMap();
    public LinkedHashMap<String, UISlot> slots = new LinkedHashMap();
    public LinkedHashMap<String, UITab> tabs = new LinkedHashMap();
    public boolean background;
    public String returnto;
    public Drawer drawer;
    public int width;
    public int height;
    public int _fields;
    public int screen_width;
    public int screen_height;
    public int gLeft;
    public int gTop;
    public UniUI root;

    public UserInterface(JsonMap map, ContainerInterface container) throws Exception {
        this.container = container.set(this);
        if (map.has("texts")) {
            for (Map.Entry<String, JsonValue<?>> entry : map.getMap("texts").entries()) {
                UIText text = (UIText)UIElement.create(UIText.IMPLEMENTATION, this, entry.getValue().asMap());
                this.texts.put(entry.getKey(), text);
                text.translate();
            }
        }
        if (map.has("buttons")) {
            for (Map.Entry<String, JsonValue<?>> entry : map.getMap("buttons").entries()) {
                this.buttons.put(entry.getKey(), (UIButton)UIElement.create(UIButton.IMPLEMENTATION, this, entry.getValue().asMap()));
            }
        }
        if (map.has("fields")) {
            for (Map.Entry<String, JsonValue<?>> entry : map.getMap("fields").entries()) {
                this.fields.put(entry.getKey(), (UIField)UIElement.create(UIField.IMPLEMENTATION, this, entry.getValue().asMap()));
            }
        }
        if (map.has("slots")) {
            for (Map.Entry<String, JsonValue<?>> entry : map.getMap("slots").entries()) {
                this.slots.put(entry.getKey(), new UISlot(this, entry.getValue().asMap()));
            }
        }
        if (map.has("tabs")) {
            for (Map.Entry<String, JsonValue<?>> entry : map.getMap("tabs").entries()) {
                this.tabs.put(entry.getKey(), (UITab)UIElement.create(UITab.IMPLEMENTATION, this, entry.getValue().asMap()));
            }
        } else {
            UITab main = UITab.IMPLEMENTATION.getConstructor(UserInterface.class, JsonMap.class).newInstance(this, map);
            main.texts.putAll(this.texts);
            main.buttons.putAll(this.buttons);
            main.fields.putAll(this.fields);
            main.slots.putAll(this.slots);
            this.tabs.put("main", main);
        }
        this.background = map.getBoolean("background", true);
        JsonArray arr = map.getArray("size");
        this.width = arr.get(0).integer_value();
        this.height = arr.get(1).integer_value();
        this.returnto = map.getString("return", null);
    }

    public boolean onClick(int mx, int my, int mb) {
        UIButton button = null;
        for (UITab tab : this.tabs.values()) {
            if (!tab.visible || !tab.enabled) continue;
            for (Map.Entry<String, UIButton> entry : this.buttons.entrySet()) {
                button = entry.getValue();
                if (!button.visible || !button.enabled || !button.hovered(this.gLeft, this.gTop, mx, my)) continue;
                return button.onclick(this.gLeft, this.gTop, mx, my, mb) || this.onAction(button, entry.getKey(), mx, my, mb);
            }
            for (UIField field : this.fields.values()) {
                if (!field.visible() || !field.hovered(this.gLeft, this.gTop, mx, my) || !field.onclick(mx, my, mb)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        return false;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        return false;
    }

    public void getTooltip(int mx, int my, List<String> list) {
    }

    public void predraw(float ticks, int mx, int my) {
    }

    public void drawbackground(float ticks, int mx, int my) {
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int am, int mx, int my) {
    }

    public boolean keytyped(char c, int code) {
        return false;
    }

    public void init() {
    }

    public static interface Drawer {
        public void draw(float var1, float var2, int var3, int var4, int var5, int var6);

        public void drawFull(float var1, float var2, int var3, int var4);

        default public void draw(int x, int y, StackWrapper stack) {
            this.draw(x, y, stack, false);
        }

        public void draw(int var1, int var2, StackWrapper var3, boolean var4);

        public void bind(IDL var1);

        default public void bindTabTex(UserInterface ui, String tab) {
            this.bind(ui.tabs.get((Object)tab).texture);
        }

        public void apply(RGB var1);

        default public void applyWhite() {
            this.apply(RGB.WHITE);
        }

        public String translate(String var1, Object ... var2);

        public IDL loadExternal(String var1);

        public void drawLine(double var1, double var3, double var5, double var7, float[] var9);
    }
}

