/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.world;

import java.util.List;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.world.MessageSender;
import net.fexcraft.mod.uni.world.WorldW;

public interface EntityW
extends MessageSender {
    public boolean isOnClient();

    public int getId();

    public WorldW getWorld();

    public boolean isPlayer();

    public boolean isAnimal();

    public boolean isHostile();

    public boolean isLiving();

    public boolean isRiding();

    public String getRegName();

    public <E> E local();

    public Object direct();

    public V3D getPos();

    public void setPos(V3D var1);

    public V3D getPrevPos();

    public void setPrevPos(V3D var1);

    public V3I getV3I();

    public void decreaseXZMotion(double var1);

    public void setYawPitch(float var1, float var2, float var3, float var4);

    public void openUI(String var1, V3I var2);

    public void openUI(UIKey var1, V3I var2);

    default public void openUI(UIKey key, int x, int y, int z) {
        this.openUI(key, new V3I(x, y, z));
    }

    public void drop(StackWrapper var1, float var2);

    public boolean isCreative();

    @Override
    public UUID getUUID();

    public StackWrapper getHeldItem(boolean var1);

    public void closeUI();

    public int getInventorySize();

    public StackWrapper getStackAt(int var1);

    public void addStack(StackWrapper var1);

    public V3D getEyeVec();

    public V3D getLookVec();

    public boolean isShiftDown();

    public void playSound(Object var1, float var2, float var3);

    public void remove();

    public boolean isRemoved();

    public void setOnGround(boolean var1);

    public List<StackWrapper> copyInventory();

    public void mount(EntityW var1);

    default public void mount(int id) {
        EntityW ent = this.getWorld().getEntity(id);
        if (ent != null) {
            this.mount(ent);
        }
    }

    public void dismount(V3D var1);

    public boolean inSimRange();

    public int getTicks();

    public int pushTicks();

    public EntityW getVehicle();

    public Object getVehicleDirect();

    public void setLeash(EntityW var1, boolean var2);

    public EntityW getLeash();

    public void move(V3D var1);

    public void breakBlockAt(V3D var1);
}

