/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Supplier;

public class FilledList<E>
implements List<E> {
    private Supplier<E> supplier;
    private Function<E, Boolean> empty;
    private Object[] array;

    public FilledList(int size, Supplier<E> supply, Function<E, Boolean> isempty) {
        this.supplier = supply;
        this.array = new Object[size];
        this.empty = isempty;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        for (Object e : this.array) {
            if (this.empty.apply(e).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Object e : this.array) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public boolean add(E e) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.empty.apply(this.array[i]).booleanValue() || !this.array[i].equals(o)) continue;
            this.array[i] = this.supplier.get();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = this.supplier.get();
        }
    }

    @Override
    public E get(int index) {
        return (E)this.array[index];
    }

    @Override
    public E set(int index, E element) {
        Object prev = this.array[index];
        this.array[index] = element;
        return (E)prev;
    }

    @Override
    public void add(int index, E element) {
        this.set(index, element);
    }

    @Override
    public E remove(int index) {
        Object prev = this.array[index];
        this.array[index] = this.supplier.get();
        return (E)prev;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.empty.apply(this.array[i]).booleanValue() || !this.array[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int idx = -1;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.empty.apply(this.array[i]).booleanValue() || !this.array[i].equals(o)) continue;
            idx = i;
        }
        return idx;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new FLIterator(this, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new FLIterator(this, index);
    }

    @Override
    public List<E> subList(int from, int to) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = from; i < to && i < this.array.length; ++i) {
            list.add(this.array[i]);
        }
        return list;
    }

    private static class FLIterator<E>
    implements ListIterator<E> {
        private FilledList<E> list;
        private int index;

        public FLIterator(FilledList<E> filled, int startat) {
            this.list = filled;
            this.index = startat;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public E next() {
            return this.list.get(this.index);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return this.list.get(this.index - 1);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.list.remove(this.index);
        }

        @Override
        public void set(E e) {
            this.list.set(this.index, e);
        }

        @Override
        public void add(E e) {
        }
    }
}

