/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;

public class V3I {
    public static final V3I NULL = new V3I();
    public int x;
    public int y;
    public int z;

    public V3I() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public V3I(int v) {
        this(v, v, v);
    }

    public V3I(int ix, int iy, int iz) {
        this.x = ix == 0 ? 0 : ix;
        this.y = iy == 0 ? 0 : iy;
        this.z = iz == 0 ? 0 : iz;
    }

    public V3I(V3I vector) {
        this(vector.x, vector.y, vector.z);
    }

    public V3I(V3D vector) {
        this((int)vector.x, (int)vector.y, (int)vector.z);
    }

    public V3I(Vec3f vector) {
        this((int)vector.x, (int)vector.y, (int)vector.z);
    }

    public V3I(String[] array, int index) {
        this.x = array.length >= index ? Integer.parseInt(array[index++]) : 0;
        this.y = array.length >= index ? Integer.parseInt(array[index++]) : 0;
        this.z = array.length >= index ? Integer.parseInt(array[index]) : 0;
    }

    public V3I(int[] array, int index) {
        this.x = array.length >= index ? array[index++] : 0;
        this.y = array.length >= index ? array[index++] : 0;
        this.z = array.length >= index ? array[index] : 0;
    }

    public V3I sub(V3I vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public V3I sub(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    public V3I add(V3I vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public V3I add(int dx, int dy, int dz) {
        return new V3I(this.x + dx, this.y + dy, this.z + dz);
    }

    public V3I scale(int scale) {
        return new V3I(this.x * scale, this.y * scale, this.z * scale);
    }

    public V3I multiply(int by) {
        return new V3I(this.x * by, this.y * by, this.z * by);
    }

    public V3I divide(int div) {
        return (float)div == 0.0f ? this : new V3I(this.x / div, this.y / div, this.z / div);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof V3I) {
            V3I vec = (V3I)obj;
            return vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        long l = Integer.toUnsignedLong(this.x);
        int i = (int)(l ^ l >>> 32);
        l = Integer.toUnsignedLong(this.y);
        i = 31 * i + (int)(l ^ l >>> 32);
        l = Integer.toUnsignedLong(this.z);
        i = 31 * i + (int)(l ^ l >>> 32);
        return i;
    }

    public String toString() {
        return String.format("V3I[ %s, %s, %s ]", this.x, this.y, this.z);
    }

    public V3I middle(V3I target) {
        return new V3I((this.x + target.x) * 2, (this.y + target.y) * 2, (this.z + target.z) * 2);
    }

    public int length() {
        return (int)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public V3I cross(V3I other) {
        return new V3I(this.y * other.z - this.z * other.y, other.x * this.z - other.z * this.x, this.x * other.y - this.y * other.x);
    }

    public double dot(V3I other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public V3I normalize(V3I dest) {
        int len = this.length();
        return dest == null ? new V3I(this.x / len, this.y / len, this.z / len) : dest.set(this.x / len, this.y / len, this.z / len);
    }

    public V3I normalize() {
        return this.normalize(null);
    }

    public V3I set(int nx, int ny, int nz) {
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public int[] toIntegerArray() {
        return new int[]{this.x, this.y, this.z};
    }

    public void copy(V3I vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public boolean isNull() {
        return (float)this.x == 0.0f && (float)this.y == 0.0f && (float)this.z == 0.0f;
    }

    public V3I copy() {
        return new V3I(this.x, this.y, this.z);
    }

    public V3I rotate(int times) {
        if (times > 3) {
            times %= 4;
        }
        switch (times) {
            case 1: {
                return new V3I(-this.z, this.y, this.x);
            }
            case 2: {
                return new V3I(-this.x, this.y, -this.z);
            }
            case 3: {
                return new V3I(this.z, this.y, -this.x);
            }
        }
        return this;
    }

    public String asString() {
        return this.x + ";" + this.y + ";" + this.z;
    }

    public static V3I fromString(String str) {
        return new V3I(str.split(";"), 0);
    }
}

