/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.capabilities.sign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.fexcraft.lib.mc.capabilities.sign.SignCapability;
import net.fexcraft.lib.mc.capabilities.sign.SignCapabilityImpl;
import net.fexcraft.mod.uni.util.FCLCapabilities;
import net.minecraft.block.BlockSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SignCapabilitySerializer
implements ICapabilitySerializable<NBTBase> {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("fcl:sign");
    private static final ArrayList<Class<? extends SignCapability.Listener>> listeners = new ArrayList();
    private SignCapability instance = (SignCapability)FCLCapabilities.SIGN_CAPABILITY.getDefaultInstance();

    public SignCapabilitySerializer(TileEntitySign object) {
        this.instance.setTileEntity(object);
    }

    public static Collection<Class<? extends SignCapability.Listener>> getListeners() {
        return Collections.unmodifiableCollection(listeners);
    }

    public static void addListener(Class<? extends SignCapability.Listener> clazz) {
        listeners.add(clazz);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == FCLCapabilities.SIGN_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == FCLCapabilities.SIGN_CAPABILITY ? FCLCapabilities.SIGN_CAPABILITY.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return FCLCapabilities.SIGN_CAPABILITY.getStorage().writeNBT(FCLCapabilities.SIGN_CAPABILITY, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        FCLCapabilities.SIGN_CAPABILITY.getStorage().readNBT(FCLCapabilities.SIGN_CAPABILITY, (Object)this.instance, null, nbt);
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onAttachEvent(AttachCapabilitiesEvent<TileEntity> event) {
            if (event.getObject() instanceof TileEntitySign) {
                event.addCapability(REGISTRY_NAME, (ICapabilityProvider)new SignCapabilitySerializer((TileEntitySign)event.getObject()));
            }
        }

        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() instanceof BlockSign) {
                TileEntitySign te_sign = (TileEntitySign)event.getWorld().func_175625_s(event.getPos());
                if (te_sign == null || te_sign.field_145915_a == null || te_sign.field_145915_a[0] == null) {
                    return;
                }
                SignCapability cap = (SignCapability)te_sign.getCapability(FCLCapabilities.SIGN_CAPABILITY, null);
                if (cap != null) {
                    cap.onPlayerInteract((PlayerInteractEvent)event, state, te_sign);
                    return;
                }
            }
        }
    }

    public static class Callable
    implements java.util.concurrent.Callable<SignCapability> {
        @Override
        public SignCapability call() throws Exception {
            return new SignCapabilityImpl();
        }
    }

    public static class Storage
    implements Capability.IStorage<SignCapability> {
        public NBTBase writeNBT(Capability<SignCapability> capability, SignCapability instance, EnumFacing side) {
            return instance.writeToNBT(capability, instance, side);
        }

        public void readNBT(Capability<SignCapability> capability, SignCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT(capability, instance, side, nbt);
        }
    }
}

