/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.registry;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.mc.api.registry.fBlock;
import net.fexcraft.lib.mc.api.registry.fCommand;
import net.fexcraft.lib.mc.api.registry.fEntity;
import net.fexcraft.lib.mc.api.registry.fItem;
import net.fexcraft.lib.mc.api.registry.fModel;
import net.fexcraft.lib.mc.api.registry.fTESR;
import net.fexcraft.lib.mc.registry.ItemBlock16;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.uni.EnvInfo;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FCLRegistry {
    private static final String block = fBlock.class.getCanonicalName();
    private static final String item = fItem.class.getCanonicalName();
    private static final String entity = fEntity.class.getCanonicalName();
    private static final String model = fModel.class.getCanonicalName();
    private static final String tesr = fTESR.class.getCanonicalName();
    private static ASMDataTable table;
    private static int eid;
    private static final Map<String, AutoRegisterer> regs;
    private static Map<ResourceLocation, Object> models;

    public static void prepare(Side side, ASMDataTable asmData) {
        table = asmData;
        new AutoRegisterer("fcl");
        if (side.isClient()) {
            FCLRegistry.scanForModels();
            FCLRegistry.registerTESRs();
        }
    }

    private static final void error(Throwable thr, String s) {
        Print.log("Error while constructing " + s + "!");
        thr.printStackTrace();
        Static.stop();
    }

    public static final void clear(FMLPostInitializationEvent event) {
    }

    public static final TreeMap<String, Class<? extends Block>> getBlockMap(String modid) {
        Set data = table.getAll(block);
        TreeMap<String, Class<? extends Block>> map = new TreeMap<String, Class<? extends Block>>();
        for (ASMDataTable.ASMData entry : data) {
            try {
                Class<?> clazz = Class.forName(entry.getClassName());
                fBlock blk = clazz.getAnnotation(fBlock.class);
                if (!blk.modid().equals(modid)) continue;
                map.put(blk.name(), clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static final TreeMap<String, Class<? extends Item>> getItemMap(String modid) {
        Set data = table.getAll(item);
        TreeMap<String, Class<? extends Item>> map = new TreeMap<String, Class<? extends Item>>();
        for (ASMDataTable.ASMData entry : data) {
            try {
                Class<?> clazz = Class.forName(entry.getClassName());
                fItem item = clazz.getAnnotation(fItem.class);
                if (!item.modid().equals(modid)) continue;
                map.put(item.name(), clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static void registerCommands(FMLServerStartingEvent event) {
        Set data = table.getAll(fCommand.class.getCanonicalName());
        for (ASMDataTable.ASMData entry : data) {
            try {
                Class<?> cmd = Class.forName(entry.getClassName());
                event.registerServerCommand((ICommand)cmd.newInstance());
            }
            catch (Exception e) {
                FCLRegistry.error(e, entry.getClassName());
            }
        }
    }

    public static Item getItem(String string) {
        return FCLRegistry.getItem(new ResourceLocation(string));
    }

    public static Item getItem(ResourceLocation rs) {
        if (regs.get(rs.func_110624_b()) != null) {
            ItemBlock iblock;
            Iterator iterator;
            AutoRegisterer reg = regs.get(rs.func_110624_b());
            Item item = (Item)reg.items.get(rs);
            if (item == null && (iterator = reg.itemblocks.iterator()).hasNext() && (iblock = (ItemBlock)iterator.next()).getRegistryName().equals((Object)rs)) {
                item = iblock;
            }
            return item;
        }
        return null;
    }

    public static Block getBlock(String string) {
        return FCLRegistry.getBlock(new ResourceLocation(string));
    }

    public static Block getBlock(ResourceLocation rs) {
        return regs.get(rs.func_110624_b()) == null ? null : (Block)regs.get(rs.func_110624_b()).blocks.get(rs);
    }

    public static void registerEntitiesOf(String modid) {
        Set data = table.getAll(entity);
        TreeMap map = new TreeMap();
        for (ASMDataTable.ASMData entry : data) {
            try {
                Class<?> clazz = Class.forName(entry.getClassName());
                if (!clazz.getAnnotation(fEntity.class).modid().equals(modid)) continue;
                map.put(clazz.getAnnotation(fEntity.class).name(), clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Class clazz : map.values()) {
            try {
                fEntity entity = clazz.getAnnotation(fEntity.class);
                ResourceLocation rs = new ResourceLocation(entity.modid(), entity.name());
                EntityRegistry.registerModEntity((ResourceLocation)rs, (Class)clazz, (String)rs.toString(), (int)eid++, (Object)entity.modid(), (int)entity.tracking_range(), (int)entity.update_frequency(), (boolean)entity.send_velocity_updates());
            }
            catch (Exception e) {
                FCLRegistry.error(e, clazz.getName());
            }
        }
    }

    public static void registerTESRs() {
        if (!EnvInfo.CLIENT) {
            return;
        }
        Set data = table.getAll(tesr);
        for (ASMDataTable.ASMData entry : data) {
            try {
                TileEntitySpecialRenderer cTESR = (TileEntitySpecialRenderer)Class.forName(entry.getClassName()).newInstance();
                ClientRegistry.bindTileEntitySpecialRenderer((Class)((Class)((ParameterizedType)cTESR.getClass().getGenericSuperclass()).getActualTypeArguments()[0]), (TileEntitySpecialRenderer)cTESR);
            }
            catch (Exception e) {}
        }
    }

    public static void registerEntityManually(String modid, String name, Class<? extends Entity> clazz, int id, int tracking_range, int update_frequency, boolean send_velocity_updates) {
        ResourceLocation rs = new ResourceLocation(modid, name);
        EntityRegistry.registerModEntity((ResourceLocation)rs, clazz, (String)rs.toString(), (int)eid++, (Object)modid, (int)tracking_range, (int)update_frequency, (boolean)send_velocity_updates);
    }

    public static void scanForModels() {
        Set data = table.getAll(model);
        for (ASMDataTable.ASMData entry : data) {
            try {
                Class<?> clazz = Class.forName(entry.getClassName());
                fModel model = clazz.getAnnotation(fModel.class);
                models.put(new ResourceLocation(model.registryname()), clazz);
            }
            catch (Throwable e) {
                FCLRegistry.error(e, entry.getClassName());
            }
        }
    }

    public static void scanForModels(File file, ClassLoader loader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ZipEntry entry;
            ZipFile zip = new ZipFile(file);
            ZipInputStream stream = new ZipInputStream(new FileInputStream(file));
            while ((entry = stream.getNextEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                list.add(entry.getName().replace(".class", ""));
            }
            zip.close();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String str : list) {
            try {
                Class<?> clazz = loader.loadClass(str);
                fModel model = clazz.getAnnotation(fModel.class);
                if (model == null) continue;
                models.put(new ResourceLocation(model.registryname()), clazz);
            }
            catch (Throwable e) {
                FCLRegistry.error(e, str);
            }
        }
    }

    @Nullable
    public static <T> T getModel(ResourceLocation loc) {
        return (T)models.get(loc);
    }

    public static <T> T getModel(String rs) {
        return FCLRegistry.getModel(new ResourceLocation(rs));
    }

    public static boolean addModelManually(String resloc, Object model, boolean override) {
        return FCLRegistry.addModelManually(new ResourceLocation(resloc), model, override);
    }

    public static boolean addModelManually(ResourceLocation loc, Object model, boolean override) {
        if (models.containsKey(loc) && !override) {
            Print.format("Tried to register Model with RS[%s] and Class[%s] but key already exists, try setting override to true?", loc, model);
            return false;
        }
        models.put(loc, model);
        return true;
    }

    public static Material getMaterial(String material) {
        switch (material) {
            case "air": {
                return Material.field_151579_a;
            }
            case "grass": {
                return Material.field_151577_b;
            }
            case "ground": {
                return Material.field_151578_c;
            }
            case "wood": {
                return Material.field_151575_d;
            }
            case "rock": {
                return Material.field_151576_e;
            }
            case "iron": {
                return Material.field_151573_f;
            }
            case "anvil": {
                return Material.field_151574_g;
            }
            case "water": {
                return Material.field_151586_h;
            }
            case "lava": {
                return Material.field_151587_i;
            }
            case "leaves": {
                return Material.field_151584_j;
            }
            case "plants": {
                return Material.field_151585_k;
            }
            case "vine": {
                return Material.field_151582_l;
            }
            case "sponge": {
                return Material.field_151583_m;
            }
            case "cloth": {
                return Material.field_151580_n;
            }
            case "fire": {
                return Material.field_151581_o;
            }
            case "sand": {
                return Material.field_151595_p;
            }
            case "circuits": {
                return Material.field_151594_q;
            }
            case "carpet": {
                return Material.field_151593_r;
            }
            case "glass": {
                return Material.field_151592_s;
            }
            case "redstone_light": {
                return Material.field_151591_t;
            }
            case "tnt": {
                return Material.field_151590_u;
            }
            case "coral": {
                return Material.field_151589_v;
            }
            case "ice": {
                return Material.field_151588_w;
            }
            case "packed_ice": {
                return Material.field_151598_x;
            }
            case "snow": {
                return Material.field_151597_y;
            }
            case "crafted_snow": {
                return Material.field_151596_z;
            }
            case "cactus": {
                return Material.field_151570_A;
            }
            case "clay": {
                return Material.field_151571_B;
            }
            case "gourd": {
                return Material.field_151572_C;
            }
            case "dragon_egg": {
                return Material.field_151566_D;
            }
            case "portal": {
                return Material.field_151567_E;
            }
            case "cake": {
                return Material.field_151568_F;
            }
            case "web": {
                return Material.field_151569_G;
            }
        }
        return Material.field_151579_a;
    }

    public static AutoRegisterer newAutoRegistry(String modid) {
        return new AutoRegisterer(modid);
    }

    public static AutoRegisterer getAutoRegisterer(String id) {
        return regs.get(id);
    }

    public static AutoRegisterer getAutoRegistry(String id) {
        return regs.get(id);
    }

    static {
        eid = 0;
        regs = new TreeMap<String, AutoRegisterer>();
        models = new TreeMap<ResourceLocation, Object>();
    }

    public static final class AutoRegisterer {
        private final String modid;
        private TreeMap<ResourceLocation, Block> blocks = new TreeMap();
        private TreeMap<ResourceLocation, Item> items = new TreeMap();
        private ArrayList<ItemBlock> itemblocks = new ArrayList();
        private TreeMap<ResourceLocation, Integer> meta = new TreeMap();
        private TreeMap<ResourceLocation, String[]> arr = new TreeMap();
        private TreeMap<ResourceLocation, IRecipe> recipes = new TreeMap();

        public AutoRegisterer(String mod) {
            this.modid = mod;
            regs.put(this.modid, this);
            MinecraftForge.EVENT_BUS.register((Object)this);
            TreeMap<String, Class<? extends Block>> mapb = FCLRegistry.getBlockMap(this.modid);
            for (Class<? extends Block> clazz : mapb.values()) {
                try {
                    fBlock block = clazz.getAnnotation(fBlock.class);
                    Block mBlock = clazz.newInstance();
                    mBlock.setRegistryName(block.modid(), block.name());
                    mBlock.func_149663_c(mBlock.getRegistryName().toString());
                    this.blocks.put(mBlock.getRegistryName(), mBlock);
                    ItemBlock iblock = block.item().getConstructor(Block.class).newInstance(mBlock);
                    iblock.setRegistryName(mBlock.getRegistryName());
                    iblock.func_77655_b(mBlock.func_149739_a());
                    if (iblock instanceof ItemBlock16) {
                        ((ItemBlock16)iblock).setItemBurnTime(block.burn_time());
                    }
                    this.itemblocks.add(iblock);
                    if (block.variants() > 1) {
                        this.meta.put(mBlock.getRegistryName(), block.variants());
                    }
                    if (block.custom_variants().length > 0) {
                        this.arr.put(mBlock.getRegistryName(), block.custom_variants());
                    }
                    if (!(mBlock instanceof ITileEntityProvider)) continue;
                    try {
                        GameRegistry.registerTileEntity(block.tileentity(), (ResourceLocation)mBlock.getRegistryName());
                    }
                    catch (IllegalArgumentException e) {
                        if (!EnvInfo.DEV) continue;
                        e.printStackTrace();
                        if (e.getMessage() != null && e.getMessage().equals("value already present: class net.minecraft.tileentity.TileEntity")) continue;
                        Static.halt();
                    }
                }
                catch (Exception e) {
                    FCLRegistry.error(e, clazz.getName());
                }
            }
            TreeMap<String, Class<? extends Item>> mapi = FCLRegistry.getItemMap(this.modid);
            for (Class<? extends Item> clazz : mapi.values()) {
                try {
                    fItem item = clazz.getAnnotation(fItem.class);
                    Item mItem = clazz.newInstance();
                    mItem.setRegistryName(item.modid(), item.name());
                    mItem.func_77655_b(mItem.getRegistryName().toString());
                    this.items.put(mItem.getRegistryName(), mItem);
                    if (item.variants() > 1) {
                        this.meta.put(mItem.getRegistryName(), item.variants());
                    }
                    if (item.custom_variants().length <= 0) continue;
                    this.arr.put(mItem.getRegistryName(), item.custom_variants());
                }
                catch (Exception e) {
                    FCLRegistry.error(e, clazz.getName());
                }
            }
        }

        @SubscribeEvent
        public void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry reg = event.getRegistry();
            for (Block block : this.blocks.values()) {
                reg.register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry reg = event.getRegistry();
            for (Item item : this.items.values()) {
                reg.register((IForgeRegistryEntry)item);
                this.registerModelLoc(item);
            }
            for (ItemBlock itemBlock : this.itemblocks) {
                reg.register((IForgeRegistryEntry)itemBlock);
                this.registerModelLoc((Item)itemBlock);
            }
        }

        @SubscribeEvent
        public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IForgeRegistry reg = event.getRegistry();
            for (Map.Entry<ResourceLocation, IRecipe> entry : this.recipes.entrySet()) {
                try {
                    entry.getValue().setRegistryName(entry.getKey());
                    reg.register((IForgeRegistryEntry)entry.getValue());
                }
                catch (Exception e) {
                    IRecipe recipe = entry.getValue();
                    Print.debug(recipe.getRegistryName() + " | " + recipe.func_77571_b().toString());
                    for (Ingredient ing : recipe.func_192400_c()) {
                        for (ItemStack stack : ing.func_193365_a()) {
                            Print.log(stack.toString());
                        }
                    }
                    e.printStackTrace();
                }
            }
        }

        private final void registerModelLoc(Item item) {
            if (!EnvInfo.CLIENT) {
                return;
            }
            if (this.meta.get(item.getRegistryName()) != null) {
                int meta = this.meta.get(item.getRegistryName());
                if (this.arr.get(item.getRegistryName()) == null) {
                    for (int i = 0; i < meta; ++i) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + i, "inventory"));
                    }
                } else {
                    String[] arr = this.arr.get(item.getRegistryName());
                    for (int i = 0; i < meta; ++i) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + arr[i], "inventory"));
                    }
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }

        public void addBlock(String name, Block block, Class<? extends ItemBlock> item, int meta, String[] custom) {
            block.setRegistryName(this.modid, name);
            block.func_149663_c(block.getRegistryName().toString());
            this.blocks.put(new ResourceLocation(this.modid, name), block);
            if (item == null) {
                ItemBlock16 iblock = new ItemBlock16(block);
                iblock.setRegistryName(block.getRegistryName());
                iblock.func_77655_b(block.func_149739_a());
                this.itemblocks.add(iblock);
            } else {
                try {
                    this.itemblocks.add(item.getConstructor(Block.class).newInstance(block));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (meta > 1) {
                this.meta.put(block.getRegistryName(), meta);
            }
            if (custom != null) {
                this.arr.put(block.getRegistryName(), custom);
            }
        }

        public void addItem(String name, Item item, int meta, String[] custom) {
            item.setRegistryName(this.modid, name);
            item.func_77655_b(item.getRegistryName().toString());
            this.items.put(new ResourceLocation(this.modid, name), item);
            if (meta > 1) {
                this.meta.put(item.getRegistryName(), meta);
            }
            if (custom != null) {
                this.arr.put(item.getRegistryName(), custom);
            }
        }

        public void addRecipe(ResourceLocation rs, IRecipe recipe) {
            this.recipes.put(rs, recipe);
        }
    }
}

