/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.render;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.mc.registry.FCLRegistry;
import net.fexcraft.lib.mc.render.FCLBlockModel;
import net.fexcraft.lib.mc.utils.Axis3DL;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class FCLBlockModelLoader
implements ICustomModelLoader {
    private static final FCLBlockModelLoader INSTANCE = new FCLBlockModelLoader();
    private static final TreeMap<ResourceLocation, FCLBlockModel> MAP = new TreeMap();
    private static final TreeMap<ResourceLocation, Model> MODELS = new TreeMap();

    public void func_110549_a(IResourceManager resourcemanager) {
        MODELS.clear();
        BakedModel.tempres.clear();
        BakedModel.quads.clear();
    }

    @Nullable
    public static final Object addBlockModel(ResourceLocation loc, FCLBlockModel model) {
        if (!loc.toString().contains(":models/block/")) {
            ResourceLocation rs = new ResourceLocation(loc.func_110624_b(), "models/block/" + loc.func_110623_a());
            return MAP.put(rs, model);
        }
        return MAP.put(loc, model);
    }

    @Nullable
    public FCLBlockModel getBlockModel(ResourceLocation modellocation) {
        return MAP.get(modellocation);
    }

    public boolean accepts(ResourceLocation modellocation) {
        if (!MAP.containsKey(modellocation)) {
            Object model = FCLRegistry.getModel(modellocation);
            if (model != null) {
                try {
                    MAP.put(modellocation, (FCLBlockModel)((Class)model).newInstance());
                    return true;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
        return MAP.containsKey(modellocation);
    }

    public IModel loadModel(ResourceLocation modellocation) throws Exception {
        return new Model(modellocation);
    }

    public String toString() {
        return "[FCL BLOCK MODEL LOADER]";
    }

    public static FCLBlockModelLoader getInstance() {
        return INSTANCE;
    }

    private static class OverrideList
    extends ItemOverrideList {
        private static final OverrideList INSTANCE = new OverrideList();

        private OverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel bakedmodel, ItemStack stack, World world, EntityLivingBase entity) {
            return bakedmodel;
        }
    }

    public static class BakedModel
    implements IBakedModel {
        private final ResourceLocation modellocation;
        public static TreeMap<String, ResourceLocation> tempres = new TreeMap();
        private static HashMap<String, List<BakedQuad>> quads = new HashMap();
        private TextureAtlasSprite deftex;
        private VertexFormat format;
        private FCLBlockModel model;
        private Model root;
        private Vec3f translate;
        private float scale = 0.0625f;
        private Axis3DL axis;
        private Axis3DL axis1;
        private Axis3DL axis2;

        public BakedModel(ResourceLocation modellocation, Model state, VertexFormat format, FCLBlockModel blockmodel) {
            this.modellocation = modellocation;
            this.format = format;
            this.root = state;
            this.model = blockmodel;
            this.deftex = this.root.textures.values().toArray(new TextureAtlasSprite[0])[0];
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            String statekey;
            String string = statekey = this.model.useDefaultCacheKey() ? BakedModel.getStateKey(state) : this.model.getCacheKey(state, side, this.root.customdata, rand);
            if (quads.containsKey(statekey)) {
                return quads.get(statekey);
            }
            ArrayList<BakedQuad> newquads = new ArrayList<BakedQuad>();
            this.axis = new Axis3DL();
            this.axis1 = new Axis3DL();
            this.axis2 = null;
            this.translate = new Vec3f();
            if (this.root.customdata != null && !this.root.customdata.isEmpty()) {
                boolean rectify;
                float z;
                float x = this.root.customdata.containsKey("x") ? Float.parseFloat((String)this.root.customdata.get("x")) : 0.0f;
                float y = this.root.customdata.containsKey("y") ? Float.parseFloat((String)this.root.customdata.get("y")) : 0.0f;
                float f = z = this.root.customdata.containsKey("z") ? Float.parseFloat((String)this.root.customdata.get("z")) : 0.0f;
                if (x != 0.0f || y != 0.0f || z != 0.0f) {
                    this.axis2 = new Axis3DL();
                    this.axis2.setAngles(y, z, x);
                }
                boolean bl = rectify = this.root.customdata.containsKey("rectify") ? Boolean.parseBoolean((String)this.root.customdata.get("rectify")) : true;
                if (rectify) {
                    this.axis1.setAngles(180.0f, 180.0f, 0.0f);
                }
                this.translate.x = this.root.customdata.containsKey("t-x") ? Float.parseFloat((String)this.root.customdata.get("t-x")) : 0.0f;
                this.translate.y = this.root.customdata.containsKey("t-y") ? Float.parseFloat((String)this.root.customdata.get("t-y")) : 0.0f;
                this.translate.z = this.root.customdata.containsKey("t-z") ? Float.parseFloat((String)this.root.customdata.get("t-z")) : 0.0f;
                this.scale = this.root.customdata.containsKey("scale") ? Float.parseFloat((String)this.root.customdata.get("scale")) : 0.0625f;
            } else {
                this.axis1.setAngles(180.0f, 180.0f, 0.0f);
            }
            Collection<ModelRendererTurbo> mrts = this.model.getPolygons(state, side, this.root.customdata, rand);
            try {
                for (ModelRendererTurbo mrt : mrts) {
                    TextureAtlasSprite sprite = mrt.texName == null ? this.deftex : this.getTex(this.root, mrt.texName);
                    this.axis.setAngles(-mrt.rotationAngleY, -mrt.rotationAngleZ, -mrt.rotationAngleX);
                    for (TexturedPolygon polygon : mrt.getFaces()) {
                        if (polygon.getVertices().length != 4) continue;
                        Vec3f vec0 = new Vec3f(polygon.getVertices()[1].vector.sub(polygon.getVertices()[0].vector));
                        Vec3f vec1 = new Vec3f(polygon.getVertices()[1].vector.sub(polygon.getVertices()[2].vector));
                        Vec3f vec2 = vec1.cross(vec0).normalize();
                        vec2 = this.axis1.getRelativeVector(this.axis.getRelativeVector(vec2));
                        if (this.axis2 != null) {
                            vec2 = this.axis2.getRelativeVector(vec2);
                        }
                        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
                        builder.setContractUVs(true);
                        builder.setQuadOrientation(EnumFacing.func_176737_a((float)vec2.x, (float)vec2.y, (float)vec2.z));
                        builder.setTexture(sprite);
                        this.putVertexData(builder, mrt, polygon.getVertices()[0], vec2, OBJModel.TextureCoordinate.getDefaultUVs()[0], sprite);
                        this.putVertexData(builder, mrt, polygon.getVertices()[1], vec2, OBJModel.TextureCoordinate.getDefaultUVs()[1], sprite);
                        this.putVertexData(builder, mrt, polygon.getVertices()[2], vec2, OBJModel.TextureCoordinate.getDefaultUVs()[2], sprite);
                        this.putVertexData(builder, mrt, polygon.getVertices()[3], vec2, OBJModel.TextureCoordinate.getDefaultUVs()[3], sprite);
                        newquads.add((BakedQuad)builder.build());
                    }
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
            quads.put(statekey, newquads);
            this.model.reset(state, side, this.root.customdata, rand);
            return newquads;
        }

        public static final String getStateKey(IBlockState state) {
            String key = state.func_177230_c().getRegistryName().toString();
            if (state.func_177227_a().size() > 0) {
                key = key + ",";
            }
            Iterator it = state.func_177227_a().iterator();
            while (it.hasNext()) {
                IProperty prop = (IProperty)it.next();
                key = key + prop.func_177701_a() + "=" + state.func_177229_b(prop);
                if (!it.hasNext()) continue;
                key = key + ",";
            }
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState ext = (IExtendedBlockState)state;
                if (key.length() > 0 && ext.getUnlistedNames().size() > 0) {
                    key = key + ",";
                }
                Iterator ite = ext.getUnlistedNames().iterator();
                while (ite.hasNext()) {
                    IUnlistedProperty prop = (IUnlistedProperty)ite.next();
                    key = key + prop.getName() + "=" + ext.getValue(prop);
                    if (!ite.hasNext()) continue;
                    key = key + ",";
                }
            }
            return key;
        }

        private TextureAtlasSprite getTex(Model root, String texName) {
            if (!tempres.containsKey(texName)) {
                tempres.put(texName, new ResourceLocation(texName));
            }
            return (TextureAtlasSprite)root.textures.get(tempres.get(texName));
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, ModelRendererTurbo mrt, TexturedVertex vert, Vec3f normal, OBJModel.TextureCoordinate textureinate, TextureAtlasSprite texture) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        Vec3f vec = this.axis.getRelativeVector(vert.vector);
                        vec = this.axis1.getRelativeVector(vec.add(mrt.rotationPointX, mrt.rotationPointY, mrt.rotationPointZ));
                        if (this.axis2 != null) {
                            vec = this.axis2.getRelativeVector(vec);
                        }
                        builder.put(e, new float[]{vec.x * this.scale + this.translate.x, vec.y * this.scale + this.translate.y, vec.z * this.scale + this.translate.z, 1.0f});
                        continue block6;
                    }
                    case COLOR: {
                        if (mrt.getColor() != null) {
                            float[] color = mrt.getColor().toFloatArray();
                            builder.put(e, new float[]{color[0], color[1], color[2], color[3]});
                            continue block6;
                        }
                        builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                        continue block6;
                    }
                    case UV: {
                        if (!mrt.textured) {
                            builder.put(e, new float[]{texture.func_94214_a(0.0), texture.func_94207_b(0.0), 0.0f, 1.0f});
                            continue block6;
                        }
                        builder.put(e, new float[]{texture.func_94214_a((double)(vert.textureX * 16.0f)), texture.func_94207_b((double)(vert.textureY * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{normal.x, normal.y, normal.z, 0.0f});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType perspective) {
            FCLBlockModel model = INSTANCE.getBlockModel(this.modellocation);
            if (model != null) {
                // empty if block
            }
            return Pair.of((Object)this, null);
        }

        public boolean func_188618_c() {
            return true;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.root.particle == null ? this.deftex : this.root.particle;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return OverrideList.INSTANCE;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_177555_b() {
            return this.root.amoc;
        }
    }

    private static class Model
    implements IModel {
        private final ResourceLocation modellocation;
        private HashMap<ResourceLocation, TextureAtlasSprite> textures = new HashMap();
        private Collection<ResourceLocation> textur;
        private FCLBlockModel blockmodel;
        protected TextureAtlasSprite particle;
        private static final IModelState defstate = new IModelState(){

            public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
                return Optional.empty();
            }
        };
        private Map<String, String> customdata;
        private boolean amoc;

        private Model(ResourceLocation rs) {
            this.modellocation = rs;
            MODELS.put(rs, this);
            this.blockmodel = (FCLBlockModel)MAP.get(rs);
            this.getTexturesFromModel();
        }

        public Model(Model model, ImmutableMap<String, String> data) {
            this.modellocation = model.modellocation;
            this.blockmodel = model.blockmodel;
            this.customdata = data;
            if (model.customdata != null) {
                for (Map.Entry<String, String> entry : model.customdata.entrySet()) {
                    if (this.customdata.containsKey(entry.getKey())) continue;
                    this.customdata.put(entry.getKey(), entry.getValue());
                }
            }
            this.amoc = this.customdata.containsKey("ambient_occlusion") && Boolean.parseBoolean(this.customdata.get("ambient_occlusion"));
            this.getTexturesFromModel();
        }

        public Collection<ResourceLocation> getDependencies() {
            return Collections.emptyList();
        }

        public IModelState getDefaultState() {
            return defstate;
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> func) {
            for (ResourceLocation loc : this.textur) {
                this.textures.put(loc, func.apply(loc));
                if (!loc.func_110623_a().endsWith("particle")) continue;
                this.particle = this.textures.get(loc);
            }
            return new BakedModel(this.modellocation, this, format, this.blockmodel);
        }

        private void getTexturesFromModel() {
            Collection<ResourceLocation> coll = this.blockmodel.getTextures(this.customdata);
            if (coll == null) {
                coll = new ArrayList<ResourceLocation>();
            }
            if (this.customdata != null && this.customdata.containsKey("textures")) {
                JsonArray array = JsonHandler.parse(this.customdata.get("textures"), false).asArray();
                for (JsonValue<?> elm : array.elements()) {
                    coll.add(new ResourceLocation(elm.string_value()));
                }
            }
            if (coll.size() == 0) {
                String str = this.modellocation.toString().replace("models/block", "blocks");
                if (str.contains(".")) {
                    str = str.substring(0, str.indexOf("."));
                }
                coll.add(new ResourceLocation(str));
            }
            this.textur = coll;
        }

        public Collection<ResourceLocation> getTextures() {
            return this.textur;
        }

        public IModel process(ImmutableMap<String, String> data) {
            if (this.customdata == null && data != null) {
                return new Model(this, data);
            }
            if (this.customdata == null && data.isEmpty()) {
                return this;
            }
            boolean same = true;
            for (Map.Entry entry : data.entrySet()) {
                if (this.customdata.containsKey(entry.getKey()) && this.customdata.get(entry.getKey()).equals(entry.getValue())) continue;
                same = false;
                break;
            }
            if (!same) {
                return new Model(this, data);
            }
            return this;
        }
    }
}

