/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.mc.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTToJson {
    public static final JsonObject getJsonFromTag(NBTTagCompound compound) {
        return NBTToJson.convert(compound, true);
    }

    public static final JsonObject getJsonFromTag(NBTTagCompound compound, boolean sort) {
        return NBTToJson.convert(compound, sort);
    }

    private static final JsonObject convert(NBTTagCompound compound, boolean sort) {
        JsonObject obj = new JsonObject();
        ArrayList list = new ArrayList(compound.func_150296_c());
        if (sort) {
            Collections.sort(list);
        }
        for (String str : list) {
            JsonElement elm = NBTToJson.element(compound.func_74781_a(str), sort);
            if (elm == null) continue;
            obj.add(str, elm);
        }
        return obj;
    }

    private static final JsonElement element(NBTBase base, boolean sort) {
        if (base instanceof NBTTagByte) {
            return new JsonPrimitive((Number)((NBTTagByte)base).func_150290_f());
        }
        if (base instanceof NBTTagByteArray) {
            byte[] arr = ((NBTTagByteArray)base).func_150292_c();
            JsonArray array = new JsonArray();
            for (int i = 0; i < arr.length; ++i) {
                array.add((Number)arr[i]);
            }
            return array;
        }
        if (base instanceof NBTTagCompound) {
            return NBTToJson.convert((NBTTagCompound)base, sort);
        }
        if (base instanceof NBTTagDouble) {
            return new JsonPrimitive((Number)((NBTTagDouble)base).func_150286_g());
        }
        if (base instanceof NBTTagFloat) {
            return new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)base).func_150288_h()));
        }
        if (base instanceof NBTTagInt) {
            return new JsonPrimitive((Number)((NBTTagInt)base).func_150287_d());
        }
        if (base instanceof NBTTagIntArray) {
            int[] arr = ((NBTTagIntArray)base).func_150302_c();
            JsonArray array = new JsonArray();
            for (int i = 0; i < arr.length; ++i) {
                array.add((Number)arr[i]);
            }
            return array;
        }
        if (base instanceof NBTTagList) {
            JsonArray array = new JsonArray();
            NBTTagList list = (NBTTagList)base;
            for (NBTBase nbt : list) {
                if (nbt instanceof NBTTagCompound) {
                    array.add((JsonElement)NBTToJson.convert((NBTTagCompound)nbt, sort));
                    continue;
                }
                array.add(NBTToJson.element(nbt, sort));
            }
            return array;
        }
        if (base instanceof NBTTagLong) {
            return new JsonPrimitive((Number)((NBTTagLong)base).func_150291_c());
        }
        if (base instanceof NBTTagShort) {
            return new JsonPrimitive((Number)((NBTTagShort)base).func_150289_e());
        }
        if (base instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)base).func_150285_a_());
        }
        return null;
    }
}

