/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import org.lwjgl.opengl.GL11;

public class DefaultRenderer
extends ModelRendererTurbo.Renderer {
    @Override
    public void render(ModelRendererTurbo mrt, float scale) {
        if (mrt.glId == null || mrt.forcedRecompile) {
            this.compile(mrt, scale);
        }
        if (mrt.rotationAngleX != 0.0f || mrt.rotationAngleY != 0.0f || mrt.rotationAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(mrt.rotationPointX * scale), (float)(mrt.rotationPointY * scale), (float)(mrt.rotationPointZ * scale));
            mrt.rotationOrder.rotate(mrt);
            GL11.glCallList((int)mrt.glId);
            if (mrt.childModels != null) {
                for (ModelRendererTurbo child : mrt.childModels) {
                    child.render(scale);
                }
            }
            GL11.glPopMatrix();
        } else if (mrt.rotationPointX != 0.0f || mrt.rotationPointY != 0.0f || mrt.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(mrt.rotationPointX * scale), (float)(mrt.rotationPointY * scale), (float)(mrt.rotationPointZ * scale));
            GL11.glCallList((int)mrt.glId);
            if (mrt.childModels != null) {
                for (ModelRendererTurbo child : mrt.childModels) {
                    child.render(scale);
                }
            }
            GL11.glTranslatef((float)(-mrt.rotationPointX * scale), (float)(-mrt.rotationPointY * scale), (float)(-mrt.rotationPointZ * scale));
        } else {
            GL11.glCallList((int)mrt.glId);
            if (mrt.childModels != null) {
                for (ModelRendererTurbo child : mrt.childModels) {
                    child.render(scale);
                }
            }
        }
    }

    private void compile(ModelRendererTurbo mrt, float scale) {
        mrt.glId = GL11.glGenLists((int)1);
        GL11.glNewList((int)mrt.glId, (int)4864);
        if (mrt.textured) {
            for (TexturedPolygon poly : mrt.getFaces()) {
                poly.draw(scale, mrt.linesColor, null);
            }
        } else {
            for (int i = 0; i < mrt.getFaces().size(); ++i) {
                mrt.getFaces().get(i).draw(scale, mrt.linesColor, mrt.getColor(i));
            }
        }
        GL11.glEndList();
    }
}

