/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.fcl.ui.CraftRecipeCon;
import net.fexcraft.mod.fcl.ui.CraftRecipeUI;
import net.fexcraft.mod.fcl.ui.ManageConfigCon;
import net.fexcraft.mod.fcl.ui.SelCatConfig;
import net.fexcraft.mod.fcl.ui.SelCatRecipe;
import net.fexcraft.mod.fcl.ui.SelEntryConfig;
import net.fexcraft.mod.fcl.ui.SelModConfig;
import net.fexcraft.mod.fcl.ui.SelRecipeCon;
import net.fexcraft.mod.fcl.ui.SelResRecipe;
import net.fexcraft.mod.uni.ConfigBase;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.UniReg;
import net.fexcraft.mod.uni.packet.PacketFileListener;
import net.fexcraft.mod.uni.packet.PacketTagListener;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.world.MessageSender;

public class UniFCL
extends ConfigBase {
    public static UIKey SELECT_CONFIG = new UIKey(100, "fcl:sel_cfg");
    public static UIKey SELECT_CONFIG_CATEGORY = new UIKey(101, "fcl:sel_cfg_cat");
    public static UIKey SELECT_CONFIG_ENTRY = new UIKey(102, "fcl:sel_cfg_entry");
    public static UIKey EDIT_CONFIG = new UIKey(103, "fcl:edit_cfg");
    public static UIKey SELECT_RECIPE_CATEGORY = new UIKey(104, "fcl:sel_rec_cat");
    public static UIKey SELECT_RECIPE_RESULT = new UIKey(105, "fcl:sel_rec_res");
    public static UIKey RECIPE_CRAFTING = new UIKey(106, "fcl:craft_recipe");
    public static UUID NULL_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static boolean EXAMPLE_RECIPES;
    public static boolean URL_TEXTURES;
    public static final ConcurrentHashMap<String, PacketTagListener> TAG_C;
    public static final ConcurrentHashMap<String, PacketTagListener> TAG_S;
    public static final ConcurrentHashMap<String, PacketFileListener> SFL_C;
    public static final ConcurrentHashMap<String, PacketFileListener> SFL_S;
    public static String SF_PATH;
    public static File SF_FOLDER;
    public static final MessageSender LOG;

    public UniFCL(File configdir) {
        super(new File(configdir, "/fcl.json"), "Fexcraft Common Library");
    }

    public static void registerFCLUI(FCL instance) {
        UniReg.registerMod("fcl", instance);
        UniReg.registerUI(SELECT_CONFIG, SelModConfig.class);
        UniReg.registerMenu(SELECT_CONFIG, "fcl:uis/select_config", ManageConfigCon.class);
        UniReg.registerUI(SELECT_CONFIG_CATEGORY, SelCatConfig.class);
        UniReg.registerMenu(SELECT_CONFIG_CATEGORY, "fcl:uis/select_config", ManageConfigCon.class);
        UniReg.registerUI(SELECT_CONFIG_ENTRY, SelEntryConfig.class);
        UniReg.registerMenu(SELECT_CONFIG_ENTRY, "fcl:uis/select_config", ManageConfigCon.class);
        UniReg.registerUI(SELECT_RECIPE_CATEGORY, SelCatRecipe.class);
        UniReg.registerMenu(SELECT_RECIPE_CATEGORY, "fcl:uis/select_recipe", SelRecipeCon.class);
        UniReg.registerUI(SELECT_RECIPE_RESULT, SelResRecipe.class);
        UniReg.registerMenu(SELECT_RECIPE_RESULT, "fcl:uis/select_recipe", SelRecipeCon.class);
        UniReg.registerUI(RECIPE_CRAFTING, CraftRecipeUI.class);
        UniReg.registerMenu(RECIPE_CRAFTING, "fcl:uis/recipe_crafting", CraftRecipeCon.class);
    }

    @Override
    protected void fillInfo(JsonMap map) {
        map.add("info", "FCL (Fexcraft Common Library) Config File");
    }

    @Override
    protected void fillEntries() {
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, "testing", "example_recipes", true).cons((entry, map) -> {
            EXAMPLE_RECIPES = entry.getBoolean((JsonMap)map);
        }).info("Should FCL testing/example recipes in the Crafting block be enabled?").req(false, true));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, "testing", "dev-mode", false).cons((entry, map) -> {
            EnvInfo.DEV = entry.getBoolean((JsonMap)map) || EnvInfo.DEV;
        }).info("If FCL DEV mode is true, related mods may print more information into the logs or specific features may work differently.", "Do not change this setting unless you know what you're doing.").req(false, false));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, "general", "url-textures", true).cons((entry, map) -> {
            URL_TEXTURES = entry.getBoolean((JsonMap)map);
        }).info("Should URL (http/online) textures be enabled in dependent mods?").req(false, false));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, "general", "shared-files", "/fcl/shared-files/").cons((entry, map) -> {
            SF_PATH = entry.getString((JsonMap)map);
        }).info("Location of the 'shared-files' folder relative to server root,", "if you have mods using the FCL Server Hosted Files Feature.").req(true, true));
    }

    @Override
    protected void onReload(JsonMap map) {
        SF_FOLDER = null;
    }

    public static byte[] getServerFile(String loc) throws IOException {
        if (SF_FOLDER == null && !(SF_FOLDER = new File(FCL.CONFIG.getFile().getParentFile().getParentFile(), SF_PATH)).exists()) {
            SF_FOLDER.mkdirs();
        }
        File file = new File(SF_FOLDER, loc.split(":")[1]);
        return Files.toByteArray((File)file);
    }

    public static IDL requestServerFile(String lis, String loc) {
        return FCL.requestServerFile(lis, loc);
    }

    public static void regServerFileListener(String id, boolean client, PacketFileListener lis) {
        (client ? SFL_C : SFL_S).put(id, lis);
    }

    public static void regTagPacketListener(String id, boolean client, PacketTagListener lis) {
        (client ? TAG_C : TAG_S).put(id, lis);
    }

    static {
        TAG_C = new ConcurrentHashMap();
        TAG_S = new ConcurrentHashMap();
        SFL_C = new ConcurrentHashMap();
        SFL_S = new ConcurrentHashMap();
        LOG = new MessageSender(){

            @Override
            public void send(String s) {
                FCL.LOGGER.info(s);
            }

            @Override
            public void send(String str, Object ... args) {
                FCL.LOGGER.info(str, args);
            }

            @Override
            public void bar(String s) {
                FCL.LOGGER.info(s);
            }

            @Override
            public void bar(String str, Object ... args) {
                FCL.LOGGER.info(str, args);
            }

            @Override
            public String getName() {
                return "LOG";
            }

            @Override
            public UUID getUUID() {
                return NULL_UUID;
            }
        };
    }
}

