/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.ui;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.uni.impl.PacketTagHandler;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.ui.UniUI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UniCon
extends Container {
    protected EntityPlayer player;
    protected ContainerInterface con;
    protected UIKey ui_type;
    @SideOnly(value=Side.CLIENT)
    protected UniUI uni;
    protected int slots;

    public UniCon(ContainerInterface con, UIKey key, EntityPlayer player) {
        this.con = con;
        this.player = player;
        this.ui_type = key;
        if (ContainerInterface.SEND_TO_CLIENT == null) {
            ContainerInterface.SEND_TO_CLIENT = (com, pass) -> PacketHandler.getInstance().sendTo((IMessage)new PacketTagHandler.I12_PacketTag("fcl:ui", (TagCW)com), (EntityPlayerMP)pass.entity.local());
        }
        if (ContainerInterface.SEND_TO_SERVER == null) {
            ContainerInterface.SEND_TO_SERVER = com -> PacketHandler.getInstance().sendToServer((IMessage)new PacketTagHandler.I12_PacketTag("fcl:ui", (TagCW)com));
        }
        con.uiid = this.ui_type;
        if (con.ui_map.has("slots")) {
            this.initInv();
        }
        con.root = this;
        con.init();
    }

    private void initInv() {
        ArrayList<UISlot> uislots = new ArrayList<UISlot>();
        for (Map.Entry<String, JsonValue<?>> entry : this.con.ui_map.getMap("slots").entries()) {
            try {
                uislots.add(new UISlot(this.con.ui, entry.getValue().asMap()));
            }
            catch (Exception e) {
                Print.log("error during inventory slot parsing");
                e.printStackTrace();
            }
        }
        this.slots = 0;
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        for (UISlot slot : uislots) {
            InventoryPlayer inventory = slot.playerinv ? this.player.field_71071_by : (IInventory)this.con.inventory.cast();
            for (int y = 0; y < slot.repeat_y; ++y) {
                for (int x = 0; x < slot.repeat_x; ++x) {
                    try {
                        this.addSlot((Slot)UISlot.get(slot.type, new Object[]{inventory, x + y * slot.repeat_x + slot.index, slot.x + x * 18, slot.y + y * 18}));
                    }
                    catch (Exception e) {
                        Print.log("error during inventory slot creation");
                        e.printStackTrace();
                    }
                    if (slot.playerinv) continue;
                    ++this.slots;
                }
            }
        }
    }

    public void addSlot(String type, Object ... args) {
        try {
            Slot slot = (Slot)UISlot.get(type, args);
            this.addSlot(slot);
            ++this.slots;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player != null;
    }

    public void setup(UniUI ui) {
        this.uni = ui;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.slots ? !this.func_75135_a(itemstack1, this.slots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.slots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public ContainerInterface container() {
        return this.con;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.con.onClosed();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.con.update((Object)this);
    }

    public void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public StackWrapper getPickedStack() {
        return UniStack.getStack(this.player.field_71071_by.func_70445_o());
    }
}

