/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.world;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WrapperHolderImpl
extends WrapperHolder {
    private static WorldW client;
    private static V3I mvec;

    @Override
    public <W extends WorldW> W getClientWorld0() {
        if (client == null) {
            client = WrapperHolderImpl.getWorld(Minecraft.func_71410_x().field_71441_e);
        }
        return (W)client;
    }

    @Override
    public EntityW getClientPlayer0() {
        return UniEntity.getEntity(Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public <S> S getServer0() {
        return (S)FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    @Override
    protected boolean isOp0(EntityW player, int lvl) {
        UserListOpsEntry entry = (UserListOpsEntry)FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152683_b((Object)((EntityPlayerMP)player.direct()).func_146103_bH());
        return entry != null && entry.func_152644_a() >= lvl;
    }

    @Override
    protected EntityW getPlayer0(UUID uuid) {
        for (EntityPlayerMP player : Static.getServer().func_184103_al().func_181057_v()) {
            if (!player.func_146103_bH().getId().equals(uuid)) continue;
            UniEntity ent = UniEntity.get(player);
            return ent != null ? ent.entity : null;
        }
        return null;
    }

    @Override
    protected List<UniEntity> getPlayers0() {
        ArrayList<UniEntity> list = new ArrayList<UniEntity>();
        for (EntityPlayerMP player : Static.getServer().func_184103_al().func_181057_v()) {
            UniEntity ent = UniEntity.get(player);
            if (ent == null) continue;
            list.add(ent);
        }
        return list;
    }

    @Override
    protected boolean isSinglePlayer0() {
        return Static.getServer() != null && Static.getServer().func_71264_H();
    }

    @Override
    public File getWorldFolder0(WorldW wr, String name) {
        World world = (World)wr.local();
        File wf = new File(world.func_72860_G().func_75765_b(), wr.type().int_key() == 0 ? "" : world.field_73011_w.getSaveFolder());
        if (!(wf = new File(wf, name)).exists()) {
            wf.mkdirs();
        }
        return wf;
    }

    @Override
    public V3I getPos0(Object o) {
        BlockPos pos = (BlockPos)o;
        return new V3I(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public V3I getPos0(long l) {
        return this.getPos0(BlockPos.func_177969_a((long)l));
    }

    @Override
    public CubeSide getSide0(Object o) {
        EnumFacing facing = (EnumFacing)o;
        switch (facing) {
            case UP: {
                return CubeSide.UP;
            }
            case DOWN: {
                return CubeSide.DOWN;
            }
            case NORTH: {
                return CubeSide.NORTH;
            }
            case WEST: {
                return CubeSide.WEST;
            }
            case EAST: {
                return CubeSide.EAST;
            }
            case SOUTH: {
                return CubeSide.SOUTH;
            }
        }
        return CubeSide.NORTH;
    }

    @Override
    public <S> S getLocalSide0(CubeSide side) {
        switch (side) {
            case UP: {
                return (S)EnumFacing.UP;
            }
            case DOWN: {
                return (S)EnumFacing.DOWN;
            }
            case NORTH: {
                return (S)EnumFacing.NORTH;
            }
            case SOUTH: {
                return (S)EnumFacing.SOUTH;
            }
            case EAST: {
                return (S)EnumFacing.EAST;
            }
            case WEST: {
                return (S)EnumFacing.WEST;
            }
        }
        return (S)EnumFacing.NORTH;
    }

    @Override
    public List<UUID> getOnlinePlayerIDs0() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (GameProfile prof : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152600_g()) {
            list.add(prof.getId());
        }
        return list;
    }

    @Override
    public UUID getUUIDFor0(String string) {
        GameProfile gp = Static.getServer().func_152358_ax().func_152655_a(string);
        return gp == null ? null : gp.getId();
    }

    @Override
    public String getNameFor0(UUID uuid) {
        GameProfile gp = Static.getServer().func_152358_ax().func_152652_a(uuid);
        return gp == null ? "N/F" : gp.getName();
    }

    @Override
    public void schedule0(Runnable run) {
        Static.getServer().func_152344_a(run);
    }

    @Override
    public void reset() {
        client = null;
    }

    @Override
    public TagCW read0(File file) {
        try {
            return TagCW.wrap(CompressedStreamTools.func_74797_a((File)file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return TagCW.create();
        }
    }

    @Override
    public void write0(TagCW compound, File file) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)((NBTTagCompound)compound.local()), (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected V3I mutPos0(Object obj) {
        BlockPos pos = (BlockPos)obj;
        return mvec.set(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    protected V3I mutPos0(int x, int y, int z) {
        return mvec.set(x, y, z);
    }

    @Override
    protected InputStream getDataResource0(IDL loc) throws IOException {
        return WrapperHolder.class.getClassLoader().getResourceAsStream("data/" + loc.space() + "/" + loc.path());
    }

    static {
        mvec = new V3I();
    }
}

