/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.lang;

public class BitList {
    private boolean[] bits = new boolean[16];

    public boolean get(int index) {
        return this.bits[index];
    }

    public void set(int index, boolean value) {
        this.bits[index] = value;
    }

    public void set(int value) {
        for (int i = 0; i < 16; ++i) {
            this.bits[i] = (value & 1 << i) != 0;
        }
    }

    public boolean fromInt(int index, int value) {
        return (value & 1 << index) != 0;
    }

    public int toInt() {
        int output = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.bits[i]) {
                output |= 1 << i;
                continue;
            }
            output &= ~(1 << i);
        }
        return output;
    }

    public BitList() {
    }

    public BitList(boolean[] bools) {
        for (int i = 0; i < bools.length && i < 16; ++i) {
            this.bits[i] = bools[i];
        }
    }

    public boolean[] shorten(int size, int offset) {
        boolean[] newarr = new boolean[size];
        for (int i = 0; i < size && i + offset < this.bits.length; ++i) {
            newarr[i] = this.bits[i + offset];
        }
        return newarr;
    }

    public void integrate(boolean[] bools, int offset) {
        BitList list = new BitList();
        list.bits = this.bits;
        for (int i = 0; i < bools.length && i < 16 && i + offset < 16; ++i) {
            list.bits[i + offset] = bools[i];
        }
    }

    public String toString() {
        Object str = "BitList[";
        for (int i = 0; i < this.bits.length; ++i) {
            str = (String)str + (this.bits[i] ? 1 : 0) + (i >= this.bits.length ? "" : ",");
        }
        return (String)str + "][" + this.toInt() + "]";
    }
}

