/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

public class Vec3f {
    public float x;
    public float y;
    public float z;

    public Vec3f() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vec3f(float x, float y, float z) {
        this.x = x == -0.0f ? 0.0f : x;
        this.y = y == -0.0f ? 0.0f : y;
        this.z = z == -0.0f ? 0.0f : z;
    }

    public Vec3f(float v) {
        this(v, v, v);
    }

    public Vec3f(double v) {
        this((float)v);
    }

    public Vec3f(Vec3f vector) {
        this(vector.x, vector.y, vector.z);
    }

    public Vec3f(double xVec, double yVec, double zVec) {
        this((float)xVec, (float)yVec, (float)zVec);
    }

    public Vec3f(String[] array, int index) {
        this.x = array.length >= index ? Float.parseFloat(array[index++]) : 0.0f;
        this.y = array.length >= index ? Float.parseFloat(array[index++]) : 0.0f;
        this.z = array.length >= index ? Float.parseFloat(array[index]) : 0.0f;
    }

    public Vec3f(float[] array, int index) {
        this.x = array.length >= index ? array[index++] : 0.0f;
        this.y = array.length >= index ? array[index++] : 0.0f;
        this.z = array.length >= index ? array[index] : 0.0f;
    }

    public Vec3f sub(Vec3f vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public Vec3f sub(float x, float y, float z) {
        return this.add(-x, -y, -z);
    }

    public Vec3f add(Vec3f vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vec3f add(float x, float y, float z) {
        return new Vec3f(this.x + x, this.y + y, this.z + z);
    }

    public Vec3f scale(float scale) {
        return new Vec3f(this.x * scale, this.y * scale, this.z * scale);
    }

    public Vec3f multiply(float scale) {
        return new Vec3f(this.x * scale, this.y * scale, this.z * scale);
    }

    public Vec3f divide(float div) {
        return div == 0.0f ? this : new Vec3f(this.x / div, this.y / div, this.z / div);
    }

    public float dis(Vec3f vec) {
        float x = vec.x - this.x;
        float y = vec.y - this.y;
        float z = vec.z - this.z;
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public float sqdis(Vec3f vec) {
        float x = vec.x - this.x;
        float y = vec.y - this.y;
        float z = vec.z - this.z;
        return x * x + y * y + z * z;
    }

    public float sqdis(float x, float y, float z) {
        float xx = x - this.x;
        float yy = y - this.y;
        float zz = z - this.z;
        return xx * xx + yy * yy + zz * zz;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Vec3f) {
            Vec3f vec = (Vec3f)obj;
            return Float.compare(vec.x, this.x) == 0 && Float.compare(vec.y, this.y) == 0 && Float.compare(vec.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        long l = Float.floatToIntBits(this.x);
        int i = (int)(l ^ l >>> 32);
        l = Float.floatToIntBits(this.y);
        i = 31 * i + (int)(l ^ l >>> 32);
        l = Float.floatToIntBits(this.z);
        i = 31 * i + (int)(l ^ l >>> 32);
        return i;
    }

    public String toString() {
        return String.format("Vec3f[ %s, %s, %s ]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public Vec3f middle(Vec3f target) {
        return new Vec3f((double)(this.x + target.x) * 0.5, (double)(this.y + target.y) * 0.5, (double)(this.z + target.z) * 0.5);
    }

    public Vec3f distance(Vec3f dest, float am) {
        Vec3f vec = new Vec3f((double)(this.x + dest.x) * 0.5, (double)(this.y + dest.y) * 0.5, (double)(this.z + dest.z) * 0.5);
        vec = Vec3f.direction(vec.x - this.x, vec.y - this.y, vec.z - this.z);
        return new Vec3f(this.x + vec.x * am, this.y + vec.y * am, this.z + vec.z * am);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(float ... arr) {
        return Math.sqrt(arr[0] * arr[0] + arr[1] * arr[1] + arr[2] * arr[2]);
    }

    public static double length(Vec3f vec) {
        return Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
    }

    public static Vec3f direction(float ... arr) {
        double l = Vec3f.length(arr[0], arr[1], arr[2]);
        return new Vec3f((double)arr[0] / l, (double)arr[1] / l, (double)arr[2] / l);
    }

    public static Vec3f direction(Vec3f vec) {
        double l = Vec3f.length(vec.x, vec.y, vec.z);
        return new Vec3f((double)vec.x / l, (double)vec.y / l, (double)vec.z / l);
    }

    public Vec3f cross(Vec3f other) {
        return new Vec3f(this.y * other.z - this.z * other.y, other.x * this.z - other.z * this.x, this.x * other.y - this.y * other.x);
    }

    public float dot(Vec3f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vec3f normalize(Vec3f dest) {
        float len = (float)this.length();
        if (len == 0.0f) {
            return dest == null ? new Vec3f() : dest.set(0.0f, 0.0f, 0.0f);
        }
        return dest == null ? new Vec3f(this.x / len, this.y / len, this.z / len) : dest.set(this.x / len, this.y / len, this.z / len);
    }

    public Vec3f normalize() {
        return this.normalize(null);
    }

    private Vec3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public double[] toDoubleArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public void copy(Vec3f pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public boolean isNull() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }
}

