/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.tmt;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.TexturedVertex;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.tmt.Coord2D;
import net.fexcraft.lib.tmt.Shape3D;

public class Shape2D {
    public ArrayList<Coord2D> coords;

    public Shape2D() {
        this.coords = new ArrayList();
    }

    public Shape2D(Coord2D[] coordArray) {
        this.coords = new ArrayList();
        for (Coord2D coord : coordArray) {
            this.coords.add(coord);
        }
    }

    public Shape2D(ArrayList<Coord2D> coordList) {
        this.coords = coordList;
    }

    public Coord2D[] getCoordArray() {
        return (Coord2D[])this.coords.toArray();
    }

    public Shape3D extrude(float x, float y, float z, float rotX, float rotY, float rotZ, float depth, int u, int v, float textureWidth, float textureHeight, int shapeTextureWidth, int shapeTextureHeight, int sideTextureWidth, int sideTextureHeight, float[] faceLengths) {
        TexturedVertex[] verts = new TexturedVertex[this.coords.size() * 2];
        TexturedVertex[] vertsTop = new TexturedVertex[this.coords.size()];
        TexturedVertex[] vertsBottom = new TexturedVertex[this.coords.size()];
        TexturedPolygon[] poly = new TexturedPolygon[this.coords.size() + 2];
        Vec3f extrudeVector = new Vec3f(0.0f, 0.0f, depth);
        this.setVectorRotations(extrudeVector, rotX, rotY, rotZ);
        if (faceLengths != null && faceLengths.length < this.coords.size()) {
            faceLengths = null;
        }
        float totalLength = 0.0f;
        for (int idx = 0; idx < this.coords.size(); ++idx) {
            Coord2D cur = this.coords.get(idx);
            Coord2D next = this.coords.get((idx + 1) % this.coords.size());
            float texU1 = (cur.u + (float)u) / textureWidth;
            float texU2 = ((float)(shapeTextureWidth * 2) - cur.u + (float)u) / textureWidth;
            float texV = (cur.v + (float)v) / textureHeight;
            Vec3f vec = new Vec3f(cur.x, cur.y, 0.0f);
            this.setVectorRotations(vec, rotX, rotY, rotZ);
            verts[idx] = new TexturedVertex(x + vec.x, y + vec.y, z + vec.z, texU1, texV);
            verts[idx + this.coords.size()] = new TexturedVertex(x + vec.x - extrudeVector.x, y + vec.y - extrudeVector.y, z + vec.z - extrudeVector.z, texU2, texV);
            vertsTop[idx] = new TexturedVertex(verts[idx]);
            vertsBottom[this.coords.size() - idx - 1] = new TexturedVertex(verts[idx + this.coords.size()]);
            if (faceLengths != null) {
                totalLength += faceLengths[idx];
                continue;
            }
            totalLength = (float)((double)totalLength + Math.sqrt(Math.pow(cur.x - next.x, 2.0) + Math.pow(cur.y - next.y, 2.0)));
        }
        poly[this.coords.size()] = new TexturedPolygon(vertsTop);
        poly[this.coords.size() + 1] = new TexturedPolygon(vertsBottom);
        float currentLengthPosition = totalLength;
        for (int idx = 0; idx < this.coords.size(); ++idx) {
            Coord2D cur = this.coords.get(idx);
            Coord2D next = this.coords.get((idx + 1) % this.coords.size());
            float currentLength = (float)Math.sqrt(Math.pow(cur.x - next.x, 2.0) + Math.pow(cur.y - next.y, 2.0));
            if (faceLengths != null) {
                currentLength = faceLengths[faceLengths.length - idx - 1];
            }
            float ratioPosition = currentLengthPosition / totalLength;
            float ratioLength = (currentLengthPosition - currentLength) / totalLength;
            float texU1 = (ratioLength * (float)sideTextureWidth + (float)u) / textureWidth;
            float texU2 = (ratioPosition * (float)sideTextureWidth + (float)u) / textureWidth;
            float texV1 = ((float)v + (float)shapeTextureHeight) / textureHeight;
            float texV2 = ((float)v + (float)shapeTextureHeight + (float)sideTextureHeight) / textureHeight;
            TexturedVertex[] polySide = new TexturedVertex[]{new TexturedVertex(verts[idx], texU2, texV1), new TexturedVertex(verts[this.coords.size() + idx], texU2, texV2), new TexturedVertex(verts[this.coords.size() + (idx + 1) % this.coords.size()], texU1, texV2), new TexturedVertex(verts[(idx + 1) % this.coords.size()], texU1, texV1)};
            poly[idx] = new TexturedPolygon(polySide);
            currentLengthPosition -= currentLength;
        }
        return new Shape3D(verts, poly);
    }

    protected Vec3f setVectorRotations(Vec3f extrudeVector, float xRot, float yRot, float zRot) {
        float x = xRot;
        float y = yRot;
        float z = zRot;
        float xC = (float)Math.cos(x);
        float xS = (float)Math.sin(x);
        float yC = (float)Math.cos(y);
        float yS = (float)Math.sin(y);
        float zC = (float)Math.cos(z);
        float zS = (float)Math.sin(z);
        double xVec = extrudeVector.x;
        double yVec = extrudeVector.y;
        double zVec = extrudeVector.z;
        double xy = (double)xC * yVec - (double)xS * zVec;
        double xz = (double)xC * zVec + (double)xS * yVec;
        double yz = (double)yC * xz - (double)yS * xVec;
        double yx = (double)yC * xVec + (double)yS * xz;
        double zx = (double)zC * yx - (double)zS * xy;
        double zy = (double)zC * xy + (double)zS * yx;
        xVec = zx;
        yVec = zy;
        zVec = yz;
        return new Vec3f(xVec, yVec, zVec);
    }
}

