/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl.ui;

import java.lang.invoke.StringConcatFactory;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fcl.ui.SelRecipeCon;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class SelResRecipe
extends UserInterface {
    private String category;
    private int scroll;

    public SelResRecipe(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.category = SelRecipeCon.categories.get(container.pos.x);
    }

    @Override
    public void init() {
        SelRecipeCon.results.clear();
        TagCW req = TagCW.create();
        req.set("sync_res", true);
        req.set("c", this.category);
        ContainerInterface.SEND_TO_SERVER.accept(req);
        ((UIText)this.texts.get("title")).value("ui.fcl.recipe.results");
        ((UIText)this.texts.get("title")).translate(ContainerInterface.translate(this.category));
    }

    @Override
    public void predraw(float ticks, int mx, int my) {
        for (int i = 0; i < 12; ++i) {
            int j = this.scroll + i;
            if (j >= SelRecipeCon.results.size()) {
                ((UIButton)this.buttons.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"entry_\u0001"}, (int)i))).text.value("");
                continue;
            }
            ((UIButton)this.buttons.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"entry_\u0001"}, (int)i))).text.value(SelRecipeCon.results.get(j).getName());
        }
    }

    @Override
    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.equals("up")) {
            --this.scroll;
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            return true;
        }
        if (id.equals("down")) {
            ++this.scroll;
            return true;
        }
        if (id.startsWith("entry_")) {
            int idx = Integer.parseInt(id.substring(6));
            if ((idx += this.scroll) < 0 || idx >= SelRecipeCon.results.size()) {
                return true;
            }
            TagCW com = TagCW.create();
            com.set("cat", this.category);
            com.set("res", SelRecipeCon.reskeys.get(idx));
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }

    @Override
    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.scroll += am;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        return true;
    }

    @Override
    public void getTooltip(int mx, int my, List<String> list) {
        for (int i = 0; i < 12; ++i) {
            int j = this.scroll + i;
            if (j >= SelRecipeCon.results.size() || !((UIButton)this.buttons.get("entry_" + i)).hovered()) continue;
            list.add("\u00a79" + SelRecipeCon.results.get(j).getName());
        }
    }

    @Override
    public boolean keytyped(char c, int code) {
        if (code == 1) {
            TagCW com = TagCW.create();
            com.set("main", true);
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }
}

