/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fexcraft.mod.fcl.FCL;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniFluidTank;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class UniFluidTank21
extends UniFluidTank {
    private SingleVariantStorage<FluidVariant> storage;
    private int cap;

    public UniFluidTank21(final int capacity) {
        this.cap = capacity;
        this.storage = new SingleVariantStorage<FluidVariant>(this){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return capacity;
            }
        };
    }

    @Override
    public int capacity() {
        return this.cap;
    }

    @Override
    public TagCW save() {
        TagCW tag = TagCW.create();
        tag.set("var", TagCW.wrap(FluidVariant.CODEC.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)FCL.SERVER.get().method_30611()), (Object)((FluidVariant)this.storage.variant)).getOrThrow()));
        tag.set("am", this.storage.amount);
        return tag;
    }

    @Override
    public void load(TagCW com) {
        if (com.has("var")) {
            try {
                class_5455.class_6890 ra = FCL.SERVER.isPresent() ? FCL.SERVER.get().method_30611() : ((class_1937)((WorldW)WrapperHolder.getClientWorld()).local()).method_30349();
                this.storage.variant = (TransferVariant)((Pair)FluidVariant.CODEC.decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)ra), (Object)((class_2520)com.getCompound("var").local())).getOrThrow()).getFirst();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.storage.amount = com.getLong("am");
    }

    @Override
    public <T> T local() {
        return (T)this.storage;
    }

    @Override
    public int amount() {
        return Math.toIntExact(this.storage.amount);
    }

    @Override
    public void amount(String type, int am) {
        this.clear();
        FluidVariant var = FluidVariant.of((class_3611)((class_3611)class_7923.field_41173.method_63535(class_2960.method_60654((String)type))));
        if (var == null) {
            return;
        }
        this.storage.variant = var;
        this.storage.amount = am;
    }

    @Override
    public void drain(int am, boolean con) {
        if (!con) {
            return;
        }
        this.storage.amount -= (long)am;
        this.storage.amount = this.storage.amount < 0L ? 0L : (this.storage.amount > (long)this.cap ? (long)this.cap : this.storage.amount);
    }

    @Override
    public void fill(int am, boolean con) {
        if (!con) {
            return;
        }
        this.storage.amount += (long)am;
        this.storage.amount = this.storage.amount < 0L ? 0L : (this.storage.amount > (long)this.cap ? (long)this.cap : this.storage.amount);
    }

    @Override
    public String getFluid() {
        return ((class_5321)((FluidVariant)this.storage.variant).getRegistryEntry().method_40230().get()).method_29177().method_12832();
    }

    @Override
    public String getFluidFromStack(StackWrapper sw) {
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)((class_1799)sw.local()));
        Storage stor = (Storage)context.find(FluidStorage.ITEM);
        if (stor == null) {
            return null;
        }
        Iterator iterator = stor.iterator();
        if (iterator.hasNext()) {
            StorageView var = (StorageView)iterator.next();
            return ((class_5321)((FluidVariant)var.getResource()).getRegistryEntry().method_40230().get()).method_29177().method_12832();
        }
        return null;
    }

    @Override
    public org.apache.commons.lang3.tuple.Pair<StackWrapper, Boolean> drainFrom(StackWrapper stack, int amount) {
        if (stack.empty()) {
            return org.apache.commons.lang3.tuple.Pair.of((Object)stack, (Object)false);
        }
        ContainerItemContext context = ContainerItemContext.withConstant((class_1799)((class_1799)stack.local()));
        Storage stor = (Storage)context.find(FluidStorage.ITEM);
        if (stor == null) {
            return org.apache.commons.lang3.tuple.Pair.of((Object)stack, (Object)false);
        }
        FluidVariant ver = null;
        for (StorageView var : stor) {
            if (!((FluidVariant)this.storage.variant).isBlank() && !((FluidVariant)var.getResource()).equals((Object)this.storage.variant)) continue;
            ver = (FluidVariant)var.getResource();
            break;
        }
        if (ver == null) {
            return org.apache.commons.lang3.tuple.Pair.of((Object)stack, (Object)false);
        }
        try (Transaction tran = Transaction.openOuter();){
            context.extract(context.getItemVariant(), 1000L, (TransactionContext)tran);
            tran.commit();
        }
        if (((FluidVariant)this.storage.variant).isBlank()) {
            this.storage.variant = ver;
        }
        this.storage.amount += 1000L;
        class_1799 steck = context.getItemVariant().getItem() instanceof class_1755 ? new class_1799((class_1935)class_1802.field_8550) : context.getItemVariant().toStack();
        return org.apache.commons.lang3.tuple.Pair.of((Object)UniStack.getStack(steck), (Object)true);
    }

    @Override
    public void clear() {
        this.storage.variant = FluidVariant.blank();
        this.storage.amount = 0L;
    }
}

