/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.ui;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIElement;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public abstract class UIButton
extends UIElement {
    public static Class<? extends UIButton> IMPLEMENTATION;
    public UIText text;
    public String action;
    public String target;
    public String tooltip;
    public IDL texture;
    public boolean colorbased;
    public int htx;
    public int hty;
    public int dtx;
    public int dty;
    public RGB hcolor = new RGB(16112194);
    public RGB ecolor = new RGB(0xFFFFFF);
    public RGB dcolor = new RGB(0xA3A3A3);
    public RGB[][] palette = null;
    public int[] palsize = null;

    public UIButton(UserInterface ui, JsonMap map) throws Exception {
        super(ui, map);
        this.action = map.getString("action", null);
        this.target = map.getString("target", null);
        this.tooltip = map.getString("tooltip", null);
        if (this.tooltip != null) {
            this.tooltip = ContainerInterface.TRANSLATOR.apply(this.tooltip);
        }
        if (map.has("text")) {
            this.text = UIText.IMPLEMENTATION.getConstructor(UserInterface.class, JsonMap.class).newInstance(ui, map.getMap("text"));
        }
        if (map.getBoolean("colorbased", true)) {
            if (map.has("color")) {
                this.hcolor.packed = this.dcolor.packed = Integer.parseInt(map.getString("color", "0"), 16);
                this.ecolor.packed = this.dcolor.packed;
            }
            this.ecolor.packed = Integer.parseInt(map.getString("e_color", Integer.toHexString(this.ecolor.packed)), 16);
            this.dcolor.packed = Integer.parseInt(map.getString("d_color", Integer.toHexString(this.dcolor.packed)), 16);
            this.hcolor.packed = Integer.parseInt(map.getString("h_color", Integer.toHexString(this.hcolor.packed)), 16);
            if (map.has("alpha")) {
                this.hcolor.alpha = this.dcolor.alpha = map.get("alpha").float_value();
                this.ecolor.alpha = this.dcolor.alpha;
            }
            this.ecolor.alpha = map.getFloat("e_alpha", this.ecolor.alpha);
            this.hcolor.alpha = map.getFloat("h_alpha", this.hcolor.alpha);
            this.dcolor.alpha = map.getFloat("d_alpha", this.dcolor.alpha);
            if (map.has("palette")) {
                JsonArray pal = map.getArray("palette");
                this.palette = new RGB[pal.get(0).integer_value()][pal.get(1).integer_value()];
                this.palsize = new int[]{pal.get(2).integer_value(), pal.get(3).integer_value()};
                for (int i = 0; i < this.palette.length; ++i) {
                    for (int j = 0; j < this.palette[i].length; ++j) {
                        this.palette[i][j] = RGB.WHITE.copy();
                    }
                }
            }
        }
        this.dtx = this.htx = this.tx;
        this.dty = this.hty = this.ty;
        if (map.has("uv")) {
            JsonArray arr = map.getArray("uv");
            if (arr.size() > 2) {
                this.htx = arr.get(2).integer_value();
                this.hty = arr.get(3).integer_value();
            }
            if (arr.size() > 4) {
                this.dtx = arr.get(4).integer_value();
                this.dty = arr.get(5).integer_value();
            }
        }
        this.texture = map.has("texture") ? IDLManager.getIDLCached(map.get("texture").string_value()) : null;
    }

    public boolean clicked(int l, int t, int mx, int my) {
        return this.enabled && this.visible && this.hovered(l, t, this.x, this.y);
    }

    public boolean onclick(int l, int t, int mx, int my, int mb) {
        return false;
    }

    public boolean onscroll(int l, int t, int x, int y, int am) {
        return false;
    }
}

