/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.world;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;

public abstract class WrapperHolder {
    public static final ConcurrentHashMap<Object, WorldW> WORLDS = new ConcurrentHashMap();
    public static Function<Object, WorldW> LEVEL_PROVIDER;
    public static WrapperHolder INSTANCE;

    public static WorldW getWorld(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!WORLDS.containsKey(obj)) {
            WORLDS.put(obj, LEVEL_PROVIDER.apply(obj));
        }
        return WORLDS.get(obj);
    }

    public static boolean isSinglePlayer() {
        return INSTANCE.isSinglePlayer0();
    }

    public static <S> S getServer() {
        return INSTANCE.getServer0();
    }

    public abstract <S> S getServer0();

    public static boolean isOp(EntityW entity) {
        return INSTANCE.isOp0(entity, 1);
    }

    public static boolean isOp(EntityW entity, int lvl) {
        return INSTANCE.isOp0(entity, lvl);
    }

    protected abstract boolean isOp0(EntityW var1, int var2);

    public static EntityW getPlayer(UUID uuid) {
        return INSTANCE.getPlayer0(uuid);
    }

    protected abstract EntityW getPlayer0(UUID var1);

    public static List<UniEntity> getPlayers() {
        return INSTANCE.getPlayers0();
    }

    protected abstract List<UniEntity> getPlayers0();

    protected abstract boolean isSinglePlayer0();

    public static <W extends WorldW> W getClientWorld() {
        return INSTANCE.getClientWorld0();
    }

    public abstract <W extends WorldW> W getClientWorld0();

    public static EntityW getClientPlayer() {
        return INSTANCE.getClientPlayer0();
    }

    public abstract EntityW getClientPlayer0();

    public static File getWorldFolder(WorldW world, String name) {
        return INSTANCE.getWorldFolder0(world, name);
    }

    public abstract File getWorldFolder0(WorldW var1, String var2);

    public static V3I getPos(Object obj) {
        return INSTANCE.getPos0(obj);
    }

    public abstract V3I getPos0(Object var1);

    public static V3I getPos(long l) {
        return INSTANCE.getPos0(l);
    }

    public abstract V3I getPos0(long var1);

    public static CubeSide getSide(Object o) {
        return INSTANCE.getSide0(o);
    }

    public abstract CubeSide getSide0(Object var1);

    public static <S> S getLocalSide(CubeSide side) {
        return INSTANCE.getLocalSide0(side);
    }

    public abstract <S> S getLocalSide0(CubeSide var1);

    public static List<UUID> getOnlinePlayerIDs() {
        return INSTANCE.getOnlinePlayerIDs0();
    }

    public abstract List<UUID> getOnlinePlayerIDs0();

    public static UUID getUUIDFor(String string) {
        return INSTANCE.getUUIDFor0(string);
    }

    public abstract UUID getUUIDFor0(String var1);

    public static String getNameFor(UUID uuid) {
        return INSTANCE.getNameFor0(uuid);
    }

    public abstract String getNameFor0(UUID var1);

    public static void schedule(Runnable run) {
        INSTANCE.schedule0(run);
    }

    public abstract void schedule0(Runnable var1);

    public abstract void reset();

    public static TagCW read(File file) {
        return INSTANCE.read0(file);
    }

    protected abstract TagCW read0(File var1);

    public static void write(TagCW compound, File file) {
        INSTANCE.write0(compound, file);
    }

    protected abstract void write0(TagCW var1, File var2);

    public static V3I mutPos(Object pos) {
        return INSTANCE.mutPos0(pos);
    }

    protected abstract V3I mutPos0(Object var1);

    public static V3I mutPos(int x, int y, int z) {
        return INSTANCE.mutPos0(x, y, z);
    }

    protected abstract V3I mutPos0(int var1, int var2, int var3);

    public static InputStream getDataResource(IDL loc) throws IOException {
        return INSTANCE.getDataResource0(loc);
    }

    protected abstract InputStream getDataResource0(IDL var1) throws IOException;
}

