/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.app.json;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;

public class JsonHandler {
    private static String NUMBER = "^\\-?\\d+$";
    private static String FLOATN = "^\\-?\\d+\\.\\d+$";

    public static JsonValue<?> parse(String str, boolean defmap) {
        return JsonHandler.parse(new ByteArrayInputStream(str.getBytes()), defmap);
    }

    public static JsonValue<?> parse(InputStream stream, boolean defmap) {
        JsonValue root = null;
        Parser parser = new Parser();
        ISW isw = new ISW(stream);
        try {
            isw.next();
            root = isw.starts('{') ? parser.parseMap(new JsonMap(), isw) : (isw.starts('[') ? parser.parseArray(new JsonArray(), isw) : (defmap ? new JsonMap() : new JsonArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return defmap ? new JsonMap() : new JsonArray();
        }
        return root;
    }

    public static JsonValue<?> parse(File file, boolean defmap) {
        try {
            return JsonHandler.parse(new FileInputStream(file), defmap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defmap ? new JsonMap() : new JsonArray();
        }
    }

    public static JsonMap parse(File file) {
        return JsonHandler.parse(file, true).asMap();
    }

    public static JsonMap parse(InputStream stream) throws IOException {
        return JsonHandler.parse(stream, true).asMap();
    }

    public static JsonValue<?> parseValue(String val) {
        if ((val = val.trim()).equals("null")) {
            return new JsonValue<String>(val);
        }
        if (Pattern.matches(NUMBER, val)) {
            long leng = Long.parseLong(val);
            if (leng < Integer.MAX_VALUE) {
                return new JsonValue<Integer>((int)leng);
            }
            return new JsonValue<Long>(leng);
        }
        if (Pattern.matches(FLOATN, val)) {
            return new JsonValue<Float>(Float.valueOf(Float.parseFloat(val)));
        }
        if (val.equals("true")) {
            return new JsonValue<Boolean>(true);
        }
        if (val.equals("false")) {
            return new JsonValue<Boolean>(false);
        }
        return new JsonValue<String>(val);
    }

    public static String toString(JsonValue<?> obj) {
        return JsonHandler.toString(obj, 0, false, PrintOption.DEFAULT);
    }

    public static String toString(JsonValue<?> obj, PrintOption opt) {
        return JsonHandler.toString(obj, 0, false, opt);
    }

    public static String toString(JsonValue<?> obj, int depth, boolean append, PrintOption opt) {
        String n;
        Object ret = "";
        Object tab = "";
        String tabo = "    ";
        String space = opt.spaced ? " " : "";
        String colspace = !opt.flat || opt.spaced ? " " : "";
        String clospace = opt.flat ? " " : "";
        Object app = append ? "," + space : "";
        String string = n = opt.flat ? "" : "\n";
        if (!opt.flat) {
            for (int j = 0; j < depth; ++j) {
                tab = (String)tab + tabo;
            }
        } else {
            tabo = "";
        }
        if (obj == null) {
            ret = (String)ret + "[ \"null\" ]";
        } else if (obj.isMap()) {
            if (obj.asMap().empty()) {
                ret = (String)ret + "{}" + (String)app + n;
            } else {
                ret = (String)ret + "{" + space + n;
                Iterator it = ((Map)obj.asMap().value).entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ret = (String)ret + (String)tab + tabo + "\"" + (String)entry.getKey() + "\":" + colspace + JsonHandler.toString((JsonValue)entry.getValue(), depth + 1, it.hasNext(), opt);
                }
                ret = (String)ret + (String)tab + clospace + "}" + (String)app + n;
            }
        } else if (obj.isArray()) {
            if (obj.asArray().empty()) {
                ret = (String)ret + "[]" + (String)app + n;
            } else {
                boolean flat = obj instanceof JsonArray.Flat || JsonHandler.shouldBeFlat(obj.asArray());
                ret = (String)ret + "[" + space + (flat ? "" : n);
                Iterator it = ((List)obj.asArray().value).iterator();
                while (it.hasNext()) {
                    if (!flat) {
                        ret = (String)ret + (String)tab + tabo;
                    }
                    ret = (String)ret + JsonHandler.toString((JsonValue)it.next(), depth + 1, it.hasNext(), flat ? PrintOption.FLAT_SPACED : opt);
                }
                if (!flat) {
                    ret = (String)ret + (String)tab;
                }
                ret = (String)ret + (flat && !opt.flat ? " " : clospace) + "]" + (String)app + n;
            }
        } else {
            ret = (String)ret + String.valueOf(obj.value instanceof String ? "\"" + obj.value.toString() + "\"" : obj.value) + (String)app + n;
        }
        return ret;
    }

    private static boolean shouldBeFlat(JsonArray array) {
        for (JsonValue<?> val : array.elements()) {
            if (val.value instanceof Number) continue;
            return false;
        }
        return true;
    }

    public static void print(File file, JsonValue<?> obj, PrintOption opt) {
        try {
            Files.write(file.toPath(), JsonHandler.toString(obj, opt).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void print(File file, JsonValue<?> obj) {
        JsonHandler.print(file, obj, PrintOption.DEFAULT);
    }

    public static JsonMap parseURL(String ... adr) {
        try {
            URL url = new URL(adr[0]);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(adr.length > 1 ? "POST" : "GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            connection.setConnectTimeout(10000);
            connection.setDoOutput(adr.length > 1);
            if (adr.length > 1) {
                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                wr.writeBytes(adr[1]);
                wr.flush();
                wr.close();
            }
            JsonMap obj = JsonHandler.parse(connection.getInputStream());
            connection.disconnect();
            return obj;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new JsonMap();
        }
    }

    public static JsonMap wrap(Map<String, Object> map, JsonMap json) {
        if (json == null) {
            json = new JsonMap();
        }
        if (map == null) {
            return json;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Collection) {
                json.add(entry.getKey(), JsonHandler.wrap((Collection)entry.getValue(), null));
                continue;
            }
            if (entry.getValue() instanceof Map) {
                json.add(entry.getKey(), JsonHandler.wrap((Map)entry.getValue(), null));
                continue;
            }
            if (entry.getValue() instanceof String) {
                json.add(entry.getKey(), String.valueOf(entry.getValue()));
                continue;
            }
            json.add(entry.getKey(), JsonHandler.parseValue(String.valueOf(entry.getValue())));
        }
        return json;
    }

    public static JsonArray wrap(Collection<?> collection, JsonArray json) {
        if (json == null) {
            json = new JsonArray();
        }
        for (Object obj : collection) {
            if (obj instanceof Collection) {
                json.add(JsonHandler.wrap((Collection)obj, null));
                continue;
            }
            if (obj instanceof Map) {
                json.add(JsonHandler.wrap((Map)obj, null));
                continue;
            }
            if (obj instanceof String) {
                json.add(String.valueOf(obj));
                continue;
            }
            json.add(JsonHandler.parseValue(String.valueOf(obj)));
        }
        return json;
    }

    public static Object dewrap(String obj) {
        return JsonHandler.dewrap(JsonHandler.parse(obj, true).asMap());
    }

    public static HashMap<String, Object> dewrap(JsonMap map) {
        HashMap<String, Object> hashmap = new HashMap<String, Object>();
        for (Map.Entry<String, JsonValue<?>> entry : map.entries()) {
            if (entry.getValue().isMap()) {
                hashmap.put(entry.getKey(), JsonHandler.dewrap(entry.getValue().asMap()));
                continue;
            }
            if (entry.getValue().isArray()) {
                hashmap.put(entry.getKey(), JsonHandler.dewrap(entry.getValue().asArray()));
                continue;
            }
            hashmap.put(entry.getKey(), entry.getValue().value);
        }
        return hashmap;
    }

    public static ArrayList<Object> dewrap(JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonValue obj : (List)array.value) {
            if (obj.isMap()) {
                list.add(JsonHandler.dewrap(obj.asMap()));
                continue;
            }
            if (obj.isArray()) {
                list.add(JsonHandler.dewrap(obj.asArray()));
                continue;
            }
            list.add(obj.value);
        }
        return list;
    }

    public static <T> ArrayList<T> dewrapc(JsonArray array) {
        ArrayList<Cloneable> list = new ArrayList<Cloneable>();
        for (JsonValue obj : (List)array.value) {
            if (obj.isMap()) {
                list.add(JsonHandler.dewrap(obj.asMap()));
                continue;
            }
            if (obj.isArray()) {
                list.add(JsonHandler.dewrap(obj.asArray()));
                continue;
            }
            list.add((Cloneable)obj.value);
        }
        return list;
    }

    private static class Parser {
        private Parser() {
        }

        private JsonValue<?> parseMap(JsonMap root, ISW isw) throws IOException {
            if (isw.starts('{')) {
                isw.next();
            }
            while (isw.has()) {
                isw.skip();
                if (isw.cher == '\"') {
                    String key = isw.till('\"');
                    isw.skip();
                    isw.next();
                    isw.skip();
                    if (isw.cher == '{') {
                        root.add(key, this.parseMap(new JsonMap(), isw));
                        continue;
                    }
                    if (isw.cher == '[') {
                        root.add(key, this.parseArray(new JsonArray(), isw));
                        continue;
                    }
                    if (isw.cher == '\"') {
                        root.add(key, isw.till('\"'));
                        continue;
                    }
                    root.add(key, JsonHandler.parseValue(isw.till()));
                    continue;
                }
                if (isw.cher == ',') {
                    isw.next();
                    continue;
                }
                if (isw.cher == '}') break;
                isw.next();
            }
            if (isw.starts('}')) {
                isw.next();
            }
            return root;
        }

        private JsonValue<?> parseArray(JsonArray root, ISW isw) throws IOException {
            if (isw.starts('[')) {
                isw.next();
            }
            while (isw.has()) {
                isw.skip();
                if (isw.cher == '\"') {
                    root.add(isw.till('\"'));
                    continue;
                }
                if (isw.cher == '{') {
                    root.add(this.parseMap(new JsonMap(), isw));
                    continue;
                }
                if (isw.cher == '[') {
                    root.add(this.parseArray(new JsonArray(), isw));
                    continue;
                }
                if (isw.cher == ',') {
                    isw.next();
                    continue;
                }
                if (isw.cher == ']') break;
                root.add(JsonHandler.parseValue(isw.till()));
            }
            if (isw.starts(']')) {
                isw.next();
            }
            return root;
        }
    }

    public static class ISW {
        protected InputStreamReader stream;
        protected char cher;
        protected boolean has = true;

        public ISW(InputStream stream) {
            this.stream = new InputStreamReader(stream, StandardCharsets.UTF_8);
        }

        public boolean starts(char c) throws IOException {
            return this.cher == c;
        }

        private void next() throws IOException {
            int i = this.stream.read();
            if (i < 0) {
                this.has = false;
                return;
            }
            this.cher = (char)i;
        }

        public boolean has() {
            return this.has;
        }

        public void skip() throws IOException {
            if (this.has && (this.cher <= ' ' || this.cher == '\n' || this.cher == '\r')) {
                this.next();
                this.skip();
            }
        }

        public String till(char c) throws IOException {
            StringBuffer buffer = new StringBuffer();
            if (this.cher == '\"') {
                this.next();
            }
            while (this.has && this.cher != c) {
                buffer.append(this.cher);
                this.next();
            }
            this.next();
            return buffer.toString();
        }

        public String till() throws IOException {
            StringBuffer buffer = new StringBuffer();
            while (this.has && this.cher != ',' && this.cher != '}' && this.cher != ']') {
                buffer.append(this.cher);
                this.next();
            }
            return buffer.toString();
        }
    }

    public static class PrintOption {
        public static final PrintOption FLAT = new PrintOption().flat(true).spaced(false);
        public static final PrintOption SPACED = new PrintOption().flat(false).spaced(true);
        public static final PrintOption FLAT_SPACED = new PrintOption().flat(true).spaced(true);
        public static final PrintOption DEFAULT = SPACED;
        boolean flat;
        boolean spaced;

        public PrintOption flat(boolean bool) {
            this.flat = bool;
            return this;
        }

        public PrintOption spaced(boolean bool) {
            this.spaced = bool;
            return this;
        }
    }
}

