/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.lib.frl.RotationOrder;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.lib.frl.gen.Generator;
import net.fexcraft.lib.tmt.ModelRendererTurbo;

public class Polyhedron<GL extends GLO> {
    public ArrayList<Polygon> polygons = new ArrayList();
    public ArrayList<Polyhedron<GL>> sub;
    public float rotX;
    public float rotY;
    public float rotZ;
    public float posX;
    public float posY;
    public float posZ;
    public float texU;
    public float texV;
    public boolean recompile;
    public boolean visible = true;
    public RotationOrder rotOrder = RotationOrder.YXZ;
    public String name;
    public GL glObj = GLO.SUPPLIER.get();
    public Integer glId;

    public Polyhedron() {
    }

    public Polyhedron(String name) {
        this.name = name;
    }

    public Polyhedron<GL> rescale(float scale) {
        for (Polygon gon : this.polygons) {
            gon.rescale(scale);
        }
        this.posX *= scale;
        this.posY *= scale;
        this.posZ *= scale;
        return this;
    }

    public Polyhedron<GL> color(RGB color) {
        for (Polygon gon : this.polygons) {
            gon.color(color);
        }
        return this;
    }

    public void render() {
        Renderer.RENDERER.render(this);
    }

    public Polyhedron<GL> importMRT(ModelRendererTurbo turbo, boolean insoff, float scale) {
        this.name = turbo.boxName;
        for (TexturedPolygon tp : turbo.getFaces()) {
            Vertex[] verts = new Vertex[tp.getVertices().length];
            for (int i = 0; i < verts.length; ++i) {
                verts[i] = new Vertex(tp.getVertices()[i].vector.scale(scale), tp.getVertices()[i].textureX, tp.getVertices()[i].textureY);
                if (insoff) {
                    verts[i].vector = verts[i].vector.add(turbo.rotationPointX * scale, turbo.rotationPointY * scale, turbo.rotationPointZ * scale);
                }
                boolean uz = i < 2;
                Vec3f vec0 = tp.getVertices()[uz ? 1 : i - 1].vector.sub(tp.getVertices()[uz ? 0 : i - 2].vector);
                Vec3f vec1 = tp.getVertices()[uz ? 1 : i - 1].vector.sub(tp.getVertices()[uz ? 2 : i].vector);
                verts[i].norm(vec1.cross(vec0).normalize());
            }
            this.polygons.add(new Polygon(verts));
        }
        if (!insoff) {
            this.posX = turbo.rotationPointX * scale;
            this.posY = turbo.rotationPointY * scale;
            this.posZ = turbo.rotationPointZ * scale;
        }
        this.rotX = turbo.rotationAngleX;
        this.rotY = turbo.rotationAngleY;
        this.rotZ = turbo.rotationAngleZ;
        this.texU = turbo.texoffx;
        this.texV = turbo.texoffy;
        return this;
    }

    public Polyhedron<GL> importMRT(TexturedPolygon tp, float scale) {
        Vertex[] verts = new Vertex[tp.getVertices().length];
        for (int i = 0; i < verts.length; ++i) {
            verts[i] = new Vertex(tp.getVertices()[i].vector.scale(scale), tp.getVertices()[i].textureX, tp.getVertices()[i].textureY);
            boolean uz = i < 2;
            Vec3f vec0 = tp.getVertices()[uz ? 1 : i - 1].vector.sub(tp.getVertices()[uz ? 0 : i - 2].vector);
            Vec3f vec1 = tp.getVertices()[uz ? 1 : i - 1].vector.sub(tp.getVertices()[uz ? 2 : i].vector);
            verts[i].norm(vec1.cross(vec0).normalize());
        }
        this.polygons.add(new Polygon(verts));
        return this;
    }

    public void clear() {
        this.polygons.clear();
        Renderer.RENDERER.delete(this);
    }

    public Polyhedron<GL> setGlObj(GL newobj) {
        this.glObj = newobj;
        return this;
    }

    public Polyhedron<GL> pos(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        return this;
    }

    public Polyhedron<GL> rot(float x, float y, float z) {
        this.rotX = x;
        this.rotY = y;
        this.rotZ = z;
        return this;
    }

    public Polyhedron<GL> pos(double x, double y, double z) {
        this.posX = (float)x;
        this.posY = (float)y;
        this.posZ = (float)z;
        return this;
    }

    public Polyhedron<GL> rot(double x, double y, double z) {
        this.rotX = (float)x;
        this.rotY = (float)y;
        this.rotZ = (float)z;
        return this;
    }

    public Generator<GL> newGen() {
        return new Generator(this);
    }

    public Polyhedron copy(boolean full) {
        Polyhedron<GL> hed = new Polyhedron<GL>();
        ((GLO)hed.glObj).copy(this.glObj, full);
        hed.visible = this.visible;
        hed.pos(this.posX, this.posY, this.posZ);
        hed.rot(this.rotX, this.rotY, this.rotZ);
        hed.rotOrder = this.rotOrder;
        hed.texU = this.texU;
        hed.texV = this.texV;
        hed.name = this.name;
        if (full) {
            for (Polygon poly : this.polygons) {
                hed.polygons.add(poly.copy(full));
            }
        } else {
            hed.polygons.addAll(this.polygons);
        }
        return hed;
    }
}

