/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl.gen;

import java.util.List;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.gen.Generator_Cuboid;
import net.fexcraft.lib.frl.gen.Generator_Cylinder;
import net.fexcraft.lib.frl.gen.ValueMap;

public class Generator<GL extends GLO> {
    protected static final Vec3f NULL_VEC = new Vec3f(0.0f, 0.0f, 0.0f);
    protected Polyhedron<GL> poly;
    protected ValueMap map = new ValueMap();

    public Generator(Polyhedron<GL> poli) {
        this.poly = poli != null ? poli : new Polyhedron();
    }

    public Generator(Polyhedron<GL> poli, float texW, float texH) {
        this(poli);
        this.map.put("texture_width", Float.valueOf(texW));
        this.map.put("texture_height", Float.valueOf(texH));
    }

    public Generator(Polyhedron<GL> poli, float texW, float texH, Type type) {
        this(poli, texW, texH);
        this.map.put("type", type);
    }

    public Generator(Polyhedron<GL> poli, Type type) {
        this(poli, 0.0f, 0.0f, type);
    }

    public Polyhedron<GL> get() {
        return this.poly;
    }

    public Polyhedron<GL> make() {
        Type type = this.map.getValue("type", Type.NONE);
        switch (type.ordinal()) {
            case 2: {
                Generator_Cylinder.make(this.poly, this.map);
                break;
            }
            case 1: {
                Generator_Cuboid.make(this.poly, this.map);
                break;
            }
        }
        return this.poly;
    }

    public Generator<GL> setValue(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public Generator<GL> set(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public Generator<GL> removePolygon(int index) {
        if (!this.map.has("rem_poly")) {
            this.map.addArray("rem_poly", Integer.TYPE);
        }
        this.map.getArray("rem_poly").add(index);
        return this;
    }

    public Generator<GL> removePolygon(int ... idxs) {
        for (int i : idxs) {
            this.removePolygon(i);
        }
        return this;
    }

    public ValueMap getMap() {
        return this.map;
    }

    protected static boolean[] intToBoolArray(List<Integer> array, int size) {
        boolean[] bool = new boolean[size];
        if (array == null || array.size() == 0) {
            return bool;
        }
        for (int i = 0; i < array.size(); ++i) {
            int j = array.get(i);
            if (j < 0 || j >= bool.length) continue;
            bool[j] = true;
        }
        return bool;
    }

    protected static boolean detached(boolean[] rems, boolean[] deuv, int i) {
        return rems[i] || deuv[i];
    }

    public static enum Type {
        NONE,
        CUBOID,
        CYLINDER;

    }
}

