/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fcl.ui;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fcl.ui.CraftRecipeCon;
import net.fexcraft.mod.fcl.ui.SelRecipeCon;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class CraftRecipeUI
extends UserInterface {
    private FclRecipe.Component comp;
    private String category;
    private IDL key;
    private int selrec;
    private int compscr;
    private int amount = 1;
    private byte ticker;
    private int current;

    public CraftRecipeUI(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.category = SelRecipeCon.categories.get(container.pos.x);
        this.key = IDLManager.getIDL(SelRecipeCon.reskeys.get(container.pos.y));
    }

    @Override
    public void init() {
        TagCW req = TagCW.create();
        req.set("sync_rec", true);
        req.set("c", this.category);
        req.set("r", this.key.colon());
        ContainerInterface.SEND_TO_SERVER.accept(req);
    }

    private void updateText() {
        if (CraftRecipeCon.results.isEmpty()) {
            return;
        }
        ((UIText)this.texts.get("recipe")).value(CraftRecipeCon.results.get((int)this.selrec).output.getName());
        ((UIText)this.texts.get("selected")).value(ContainerInterface.transformat("ui.fcl.recipe.selected", this.selrec + 1, CraftRecipeCon.results.size()));
        ((UIText)this.texts.get("amount")).value(ContainerInterface.transformat("ui.fcl.recipe.amount", this.amount));
    }

    @Override
    public void predraw(float ticks, int mx, int my) {
        this.ticker = (byte)(this.ticker + 1);
        if (this.ticker > 10) {
            this.ticker = 0;
            ++this.current;
        }
        this.updateText();
    }

    @Override
    public void postdraw(float ticks, int mx, int my) {
        if (CraftRecipeCon.results.isEmpty()) {
            return;
        }
        FclRecipe rec = CraftRecipeCon.results.get(this.selrec);
        this.drawer.draw(this.gLeft + 7, this.gTop + 10, rec.output, true);
        for (int x = 0; x < 12; ++x) {
            int z;
            for (int y = 0; y < 5 && (z = y * 12 + x + this.compscr * 12) < rec.components.size(); ++y) {
                this.comp = rec.components.get(z);
                if (this.comp.tag) {
                    if (this.comp.list == null) {
                        this.comp.refreshList();
                    }
                    if (this.comp.list.isEmpty()) continue;
                    this.drawer.draw(this.gLeft + 6 + x * 18, this.gTop + 34 + y * 18, this.comp.list.get(this.current % this.comp.list.size()), true);
                    continue;
                }
                this.drawer.draw(this.gLeft + 6 + x * 18, this.gTop + 34 + y * 18, this.comp.stack, true);
            }
        }
    }

    @Override
    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "prev": {
                --this.selrec;
                if (this.selrec < 0) {
                    this.selrec = 0;
                }
                this.updateText();
                return true;
            }
            case "next": {
                ++this.selrec;
                if (this.selrec >= CraftRecipeCon.results.size()) {
                    this.selrec = CraftRecipeCon.results.size() - 1;
                }
                this.updateText();
                return true;
            }
            case "up": {
                --this.compscr;
                if (this.compscr < 0) {
                    this.compscr = 0;
                }
                return true;
            }
            case "down": {
                ++this.compscr;
                return true;
            }
            case "less": {
                --this.amount;
                if (this.amount < 1) {
                    this.amount = 1;
                }
                this.updateText();
                return true;
            }
            case "more": {
                ++this.amount;
                if (this.amount > 64) {
                    this.amount = 64;
                }
                this.updateText();
                return true;
            }
            case "craft": 
            case "craftexit": {
                TagCW com = TagCW.create();
                com.set("exit", id.equals("craftexit"));
                com.set("cat", this.category);
                com.set("res", this.key.colon());
                com.set("idx", this.selrec);
                com.set("am", this.amount);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
        }
        return false;
    }

    @Override
    public void getTooltip(int mx, int my, List<String> list) {
        int x;
        int y;
        int z;
        if (CraftRecipeCon.results.isEmpty()) {
            return;
        }
        if (mx >= this.gLeft + 7 && mx <= this.gLeft + 23 && my >= this.gTop + 10 && my <= this.gTop + 26) {
            list.add(CraftRecipeCon.results.get((int)this.selrec).output.getName());
        }
        if (mx >= this.gLeft + 6 && mx <= this.gLeft + 222 && my >= this.gTop + 34 && my <= this.gTop + 104 && (z = (y = (my - this.gTop - 34) / 18) * 12 + (x = (mx - this.gLeft - 6) / 18) + this.compscr * 12) >= 0 && z < CraftRecipeCon.results.get((int)this.selrec).components.size()) {
            this.comp = CraftRecipeCon.results.get((int)this.selrec).components.get(z);
            if (this.comp.tag) {
                if (this.comp.list != null && this.comp.list.size() > 0) {
                    list.add(this.comp.list.get(this.current % this.comp.list.size()).getName());
                }
            } else {
                list.add(this.comp.stack.getName());
            }
        }
    }

    @Override
    public boolean keytyped(char c, int code) {
        if (code == 1) {
            TagCW com = TagCW.create();
            com.set("ret", this.category);
            ContainerInterface.SEND_TO_SERVER.accept(com);
            return true;
        }
        return false;
    }
}

