/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.inv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;

public abstract class UniInventory {
    public static Class<? extends UniInventory> IMPL = null;
    protected HashMap<Integer, UniItemValidator> validators = new HashMap();
    protected ArrayList<StackWrapper> stacks;
    protected List<Object> local;
    protected boolean drop_on_close;
    protected int stacksize = 64;
    protected String name = "Universal Inventory";

    public UniInventory(List<Object> local) {
        this.local = local;
        this.stacks = new ArrayList();
        for (int i = 0; i < local.size(); ++i) {
            this.stacks.add(i, UniStack.createStack(local.get(i)));
        }
    }

    public static UniInventory create(List<Object> stacks) {
        try {
            return IMPL.getConstructor(List.class).newInstance(stacks);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static UniInventory create(int size) {
        try {
            return IMPL.getConstructor(Integer.TYPE).newInstance(size);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public UniInventory stacksize(int set) {
        this.stacksize = set;
        return this;
    }

    public UniInventory drop(boolean bool) {
        this.drop_on_close = bool;
        return this;
    }

    public UniInventory name(String str) {
        this.name = str;
        return this;
    }

    public <INV> INV cast() {
        return (INV)this;
    }

    public void addValidator(int idx, UniItemValidator val) {
        this.validators.put(idx, val);
    }

    public void addValidator(int from, int to, UniItemValidator val) {
        for (int idx = from; idx < to; ++idx) {
            this.validators.put(idx, val);
        }
    }

    public boolean empty() {
        boolean empty = true;
        for (StackWrapper stack : this.stacks) {
            if (stack.empty()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public int size() {
        return this.stacks.size();
    }

    public StackWrapper get(int idx) {
        if (idx < 0 || idx >= this.stacks.size()) {
            return StackWrapper.EMPTY;
        }
        return this.stacks.get(idx);
    }

    public void set(int idx, StackWrapper stack) {
        if (idx < 0 || idx >= this.stacks.size()) {
            return;
        }
        this.local.set(idx, stack.local());
        this.stacks.set(idx, stack);
    }

    public void set(int idx, TagCW com) {
        this.set(idx, UniStack.createStack(com));
    }

    public StackWrapper get(int idx, int am) {
        if (idx < 0 || idx >= this.stacks.size()) {
            return StackWrapper.EMPTY;
        }
        StackWrapper stack = this.stacks.get(idx);
        if (stack.empty()) {
            return stack;
        }
        if (am >= stack.count()) {
            this.set(idx, StackWrapper.EMPTY);
            return stack;
        }
        StackWrapper copy = stack.copy();
        copy.count(am);
        stack.decr(am);
        return copy;
    }

    public StackWrapper remove(int idx) {
        StackWrapper stack = this.get(idx);
        this.set(idx, StackWrapper.EMPTY);
        return stack;
    }

    public boolean empty(int idx) {
        return this.get(idx).empty();
    }

    public void mark() {
    }

    public void open(UniEntity ent) {
    }

    public void close(UniEntity ent) {
        if (!this.drop_on_close) {
            return;
        }
        for (StackWrapper stack : this.stacks) {
            if (stack.empty()) continue;
            ent.entity.addStack(stack);
        }
    }

    public boolean valid(int idx, StackWrapper stack) {
        UniItemValidator val = this.validators.get(idx);
        return val == null || val.isValid(idx, stack);
    }

    public void clear() {
        this.local.clear();
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, StackWrapper.EMPTY);
        }
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "UniInventory[" + this.name + "]";
    }

    public StackWrapper insert(int idx, StackWrapper stack, boolean sim) {
        StackWrapper loc = this.stacks.get(idx);
        if (loc.empty()) {
            if (!sim) {
                this.set(idx, stack);
            }
            return StackWrapper.EMPTY;
        }
        if (loc.equals(stack) && loc.count() < loc.maxsize()) {
            int dif = loc.maxsize() - loc.count();
            if (!sim) {
                loc.incr(Math.min(dif, stack.count()));
            }
            if ((dif -= stack.count()) <= 0) {
                return StackWrapper.EMPTY;
            }
            stack.decr(dif);
        }
        return stack;
    }

    public static interface UniItemValidator {
        public boolean isValid(int var1, StackWrapper var2);
    }
}

