/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.fexcraft.mod.uni.packet.PacketBase;

public class PacketFile
implements PacketBase<PacketFile> {
    public String lis;
    public String loc;
    public byte[] img;

    @Override
    public PacketFile fill(Object ... data) {
        this.lis = data[0] == null ? "def" : (String)data[0];
        this.loc = (String)data[1];
        if (data.length > 2) {
            this.img = (byte[])data[2];
        }
        return this;
    }

    @Override
    public void encode(ByteBuf buffer) {
        byte[] bytes = this.lis.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
        bytes = this.loc.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length);
        buffer.writeBytes(bytes);
        if (this.img == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(this.img.length);
        buffer.writeBytes(this.img);
    }

    @Override
    public void decode(ByteBuf buffer) {
        byte[] dest = new byte[buffer.readInt()];
        buffer.readBytes(dest);
        this.lis = new String(dest, StandardCharsets.UTF_8);
        dest = new byte[buffer.readInt()];
        buffer.readBytes(dest);
        this.loc = new String(dest, StandardCharsets.UTF_8);
        int length = buffer.readInt();
        if (length == 0) {
            return;
        }
        this.img = new byte[length];
        buffer.readBytes(this.img);
    }
}

