/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.common.math;

import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.math.Vec3f;

public class V3D {
    public static final V3D NULL = new V3D();
    public double x;
    public double y;
    public double z;

    public V3D() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public V3D(double v) {
        this(v, v, v);
    }

    public V3D(double dx, double dy, double dz) {
        this.x = dx == -0.0 ? 0.0 : dx;
        this.y = dy == -0.0 ? 0.0 : dy;
        this.z = dz == -0.0 ? 0.0 : dz;
    }

    public V3D(V3I vector) {
        this(vector.x, vector.y, vector.z);
    }

    public V3D(V3D vector) {
        this(vector.x, vector.y, vector.z);
    }

    public V3D(Vec3f vector) {
        this(vector.x, vector.y, vector.z);
    }

    public V3D(String[] array, int index) {
        this.x = array.length > index ? Double.parseDouble(array[index++]) : 0.0;
        this.y = array.length > index ? Double.parseDouble(array[index++]) : 0.0;
        this.z = array.length > index ? Double.parseDouble(array[index]) : 0.0;
    }

    public V3D(float[] array, int index) {
        this.x = array.length > index ? (double)array[index++] : 0.0;
        this.y = array.length > index ? (double)array[index++] : 0.0;
        this.z = array.length > index ? (double)array[index] : 0.0;
    }

    public V3D sub(V3D vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public V3D sub(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public V3D add(V3D vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public V3D add(double dx, double dy, double dz) {
        return new V3D(this.x + dx, this.y + dy, this.z + dz);
    }

    public V3D scale(double scale) {
        return new V3D(this.x * scale, this.y * scale, this.z * scale);
    }

    public V3D multiply(double by) {
        return new V3D(this.x * by, this.y * by, this.z * by);
    }

    public V3D divide(double div) {
        return div == 0.0 ? this : new V3D(this.x / div, this.y / div, this.z / div);
    }

    public double dis(V3D vec) {
        double x = vec.x - this.x;
        double y = vec.y - this.y;
        double z = vec.z - this.z;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public double dis(double ox, double oy, double oz) {
        double x = ox - this.x;
        double y = oy - this.y;
        double z = oz - this.z;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public double sqdis(V3D vec) {
        double x = vec.x - this.x;
        double y = vec.y - this.y;
        double z = vec.z - this.z;
        return x * x + y * y + z * z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof V3D) {
            V3D vec = (V3D)obj;
            return Double.compare(vec.x, this.x) == 0 && Double.compare(vec.y, this.y) == 0 && Double.compare(vec.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int i = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        i = 31 * i + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        i = 31 * i + (int)(l ^ l >>> 32);
        return i;
    }

    public String toString() {
        return String.format("V3D[ %s, %s, %s ]", this.x, this.y, this.z);
    }

    public V3D middle(V3D target) {
        return new V3D((this.x + target.x) * 0.5, (this.y + target.y) * 0.5, (this.z + target.z) * 0.5);
    }

    public V3D distance(V3D dest, double am) {
        V3D vec = new V3D((this.x + dest.x) * 0.5, (this.y + dest.y) * 0.5, (this.z + dest.z) * 0.5);
        vec = V3D.direction(vec.x - this.x, vec.y - this.y, vec.z - this.z);
        return new V3D(this.x + vec.x * am, this.y + vec.y * am, this.z + vec.z * am);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(double ... arr) {
        return Math.sqrt(arr[0] * arr[0] + arr[1] * arr[1] + arr[2] * arr[2]);
    }

    public static double length(V3D vec) {
        return Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
    }

    public static V3D direction(double ... arr) {
        double l = V3D.length(arr[0], arr[1], arr[2]);
        return new V3D(arr[0] / l, arr[1] / l, arr[2] / l);
    }

    public static V3D direction(V3D vec) {
        double l = V3D.length(vec.x, vec.y, vec.z);
        return new V3D(vec.x / l, vec.y / l, vec.z / l);
    }

    public V3D cross(V3D other) {
        return new V3D(this.y * other.z - this.z * other.y, other.x * this.z - other.z * this.x, this.x * other.y - this.y * other.x);
    }

    public double dot(V3D other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public V3D normalize(V3D dest) {
        double len = this.length();
        return dest == null ? new V3D(this.x / len, this.y / len, this.z / len) : dest.set(this.x / len, this.y / len, this.z / len);
    }

    public V3D normalize() {
        return this.normalize(null);
    }

    private V3D set(double dx, double dy, double dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
        return this;
    }

    public float[] toFloatArray() {
        return new float[]{(float)this.x, (float)this.y, (float)this.z};
    }

    public double[] toDoubleArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public void copy(V3D vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public V3D copy() {
        return new V3D(this.x, this.y, this.z);
    }

    public static V3D add(V3D vec, V3D dest) {
        dest.x += vec.x;
        dest.y += vec.y;
        dest.z += vec.z;
        return dest;
    }

    public static V3D sub(V3D vec, V3D dest) {
        dest.x -= vec.x;
        dest.y -= vec.y;
        dest.z -= vec.z;
        return dest;
    }
}

