/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl.gen;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.lib.frl.gen.Generator;
import net.fexcraft.lib.frl.gen.ValueMap;

public class Generator_Cuboid {
    public static <GL extends GLO> void make(Polyhedron<GL> poly, ValueMap map) {
        float scale;
        float[] v7;
        float[] v6;
        float[] v5;
        float[] v4;
        float[] v3;
        float[] v2;
        float[] v1;
        float[] v0;
        boolean shaped = map.has("corners");
        boolean anyrem = map.has("rem_poly");
        float x = ((Float)map.getValue("x")).floatValue();
        float y = ((Float)map.getValue("y")).floatValue();
        float z = ((Float)map.getValue("z")).floatValue();
        float w = ((Float)map.getValue("width")).floatValue();
        float h = ((Float)map.getValue("height")).floatValue();
        float d = ((Float)map.getValue("depth")).floatValue();
        float exp = map.getValue("exp", 0).intValue();
        boolean centered = map.getValue("centered", false);
        boolean[] rems = Generator.intToBoolArray(map.getArray("rem_poly"), 6);
        boolean[] deuv = Generator.intToBoolArray(map.getArray("detached_uv"), 6);
        ArrayList<Object> uv = map.getArray("uv", 6, null);
        float texw = ((Float)map.getValue("texture_width")).floatValue();
        float texh = ((Float)map.getValue("texture_height")).floatValue();
        if (centered) {
            x -= w * 0.5f;
            y -= h * 0.5f;
            z -= d * 0.5f;
        }
        if (shaped) {
            ArrayList<Object> array = map.getArray("corners", 8, null);
            Vec3f c0 = array.get(0) == null ? Generator.NULL_VEC : (Vec3f)array.get(0);
            Vec3f c1 = array.get(1) == null ? Generator.NULL_VEC : (Vec3f)array.get(1);
            Vec3f c2 = array.get(2) == null ? Generator.NULL_VEC : (Vec3f)array.get(2);
            Vec3f c3 = array.get(3) == null ? Generator.NULL_VEC : (Vec3f)array.get(3);
            Vec3f c4 = array.get(4) == null ? Generator.NULL_VEC : (Vec3f)array.get(4);
            Vec3f c5 = array.get(5) == null ? Generator.NULL_VEC : (Vec3f)array.get(5);
            Vec3f c6 = array.get(6) == null ? Generator.NULL_VEC : (Vec3f)array.get(6);
            Vec3f c7 = array.get(7) == null ? Generator.NULL_VEC : (Vec3f)array.get(7);
            float xw = x + w;
            float yh = y + h;
            float zd = z + d;
            v0 = new float[]{x - c0.x, y - c0.y, z - c0.z};
            v1 = new float[]{xw + c1.x, y - c1.y, z - c1.z};
            v2 = new float[]{xw + c5.x, yh + c5.y, z - c5.z};
            v3 = new float[]{x - c4.x, yh + c4.y, z - c4.z};
            v4 = new float[]{x - c3.x, y - c3.y, zd + c3.z};
            v5 = new float[]{xw + c2.x, y - c2.y, zd + c2.z};
            v6 = new float[]{xw + c6.x, yh + c6.y, zd + c6.z};
            v7 = new float[]{x - c7.x, yh + c7.y, zd + c7.z};
        } else {
            float x1 = x + w + (w == 0.0f ? 0.01f : 0.0f);
            float y1 = y + h + (h == 0.0f ? 0.01f : 0.0f);
            float z1 = z + d + (d == 0.0f ? 0.01f : 0.0f);
            v0 = new float[]{x, y, z};
            v1 = new float[]{x1 += exp, y, z};
            v2 = new float[]{x1, y1 += exp, z};
            v3 = new float[]{x, y1, z};
            v4 = new float[]{x, y, z1 += exp};
            v5 = new float[]{x1, y, z1};
            v6 = new float[]{x1, y1, z1};
            v7 = new float[]{x, y1, z1};
        }
        Polygon[] polys = new Polygon[6];
        Vertex tv0 = new Vertex(v0).uv(0.0f, 0.0f);
        Vertex tv1 = new Vertex(v1).uv(0.0f, 8.0f);
        Vertex tv2 = new Vertex(v2).uv(8.0f, 8.0f);
        Vertex tv3 = new Vertex(v3).uv(8.0f, 0.0f);
        Vertex tv4 = new Vertex(v4).uv(0.0f, 0.0f);
        Vertex tv5 = new Vertex(v5).uv(0.0f, 8.0f);
        Vertex tv6 = new Vertex(v6).uv(8.0f, 8.0f);
        Vertex tv7 = new Vertex(v7).uv(8.0f, 0.0f);
        float tx = poly.texU;
        float ty = poly.texV;
        float w0 = w;
        float h0 = h;
        float d0 = d;
        if (w0 % 1.0f != 0.0f) {
            float f = w0 < 1.0f ? 1.0f : (w0 = (float)((int)w0 + (w0 % 1.0f > 0.5f ? 1 : 0)));
        }
        if (h0 % 1.0f != 0.0f) {
            float f = h0 < 1.0f ? 1.0f : (h0 = (float)((int)h0 + (h0 % 1.0f > 0.5f ? 1 : 0)));
        }
        if (d0 % 1.0f != 0.0f) {
            float f = d0 < 1.0f ? 1.0f : (d0 = (float)((int)d0 + (d0 % 1.0f > 0.5f ? 1 : 0)));
        }
        if (!anyrem) {
            polys[0] = Generator_Cuboid.genPolygonWithUV(0, uv.get(0), deuv[0], texw, texh, new Vertex[]{tv5, tv1, tv2, tv6}, tx, ty, d0 + w0, d0, d0, h0);
            polys[1] = Generator_Cuboid.genPolygonWithUV(1, uv.get(1), deuv[1], texw, texh, new Vertex[]{tv0, tv4, tv7, tv3}, tx, ty, 0.0f, d0, d0, h0);
            polys[2] = Generator_Cuboid.genPolygonWithUV(2, uv.get(2), deuv[2], texw, texh, new Vertex[]{tv5, tv4, tv0, tv1}, tx, ty, d0, 0.0f, w0, d0);
            polys[3] = Generator_Cuboid.genPolygonWithUV(3, uv.get(3), deuv[3], texw, texh, new Vertex[]{tv2, tv3, tv7, tv6}, tx, ty, d0 + w0, 0.0f, w0, d0);
            polys[4] = Generator_Cuboid.genPolygonWithUV(4, uv.get(4), deuv[4], texw, texh, new Vertex[]{tv1, tv0, tv3, tv2}, tx, ty, d0, d0, w0, h0);
            polys[5] = Generator_Cuboid.genPolygonWithUV(5, uv.get(5), deuv[5], texw, texh, new Vertex[]{tv4, tv5, tv6, tv7}, tx, ty, d0 + w0 + d0, d0, w0, h0);
        } else {
            float x3;
            float yp = Generator.detached(rems, deuv, 2) && Generator.detached(rems, deuv, 3) ? 0.0f : d0;
            float x0 = Generator.detached(rems, deuv, 1) ? 0.0f : d0;
            float x1 = Generator.detached(rems, deuv, 2) ? 0.0f : w0;
            float x2 = Generator.detached(rems, deuv, 4) ? 0.0f : w0;
            float f = x3 = Generator.detached(rems, deuv, 0) ? 0.0f : d0;
            if (!rems[0]) {
                polys[0] = Generator_Cuboid.genPolygonWithUV(0, uv.get(0), deuv[0], texw, texh, new Vertex[]{tv5, tv1, tv2, tv6}, tx, ty, x0 + x2, yp, d0, h0);
            }
            if (!rems[1]) {
                polys[1] = Generator_Cuboid.genPolygonWithUV(1, uv.get(1), deuv[1], texw, texh, new Vertex[]{tv0, tv4, tv7, tv3}, tx, ty, 0.0f, yp, d0, h0);
            }
            if (!rems[2]) {
                polys[2] = Generator_Cuboid.genPolygonWithUV(2, uv.get(2), deuv[2], texw, texh, new Vertex[]{tv5, tv4, tv0, tv1}, tx, ty, x0, 0.0f, w0, d0);
            }
            if (!rems[3]) {
                polys[3] = Generator_Cuboid.genPolygonWithUV(3, uv.get(3), deuv[3], texw, texh, new Vertex[]{tv2, tv3, tv7, tv6}, tx, ty, x0 + x1, 0.0f, w0, d0);
            }
            if (!rems[4]) {
                polys[4] = Generator_Cuboid.genPolygonWithUV(4, uv.get(4), deuv[4], texw, texh, new Vertex[]{tv1, tv0, tv3, tv2}, tx, ty, x0, yp, w0, h0);
            }
            if (!rems[5]) {
                polys[5] = Generator_Cuboid.genPolygonWithUV(5, uv.get(5), deuv[5], texw, texh, new Vertex[]{tv4, tv5, tv6, tv7}, tx, ty, x0 + x2 + x3, yp, w0, h0);
            }
        }
        if (anyrem) {
            int polis = 0;
            int processed = 0;
            for (int i = 0; i < polys.length; ++i) {
                if (polys[i] == null) continue;
                ++polis;
            }
            Polygon[] polygons = new Polygon[polis];
            for (int i = 0; i < polys.length; ++i) {
                if (polys[i] == null) continue;
                polygons[processed] = polys[i];
                ++processed;
            }
            polys = polygons;
        }
        if ((scale = map.getValue("scale", Float.valueOf(1.0f)).floatValue()) != 1.0f) {
            for (Polygon gon : polys) {
                for (Vertex vert : gon.vertices) {
                    vert.vector = vert.vector.scale(scale);
                }
            }
        }
        for (Polygon gon : polys) {
            poly.polygons.add(gon);
        }
    }

    private static Polygon genPolygonWithUV(int index, float[] uv, boolean detached, float w, float h, Vertex[] vertices, float tu, float tv, float x, float y, float ex, float ey) {
        float[] cuv;
        float[] fArray = cuv = index < 0 || uv == null ? null : uv;
        if (index > -1 && detached) {
            tu = 0.0f;
            tv = 0.0f;
        }
        if (cuv == null) {
            float xs = tu + x;
            float xe = tu + x + ex;
            float ys = tv + y;
            float ye = tv + y + ey;
            vertices[0] = vertices[0].nauv(xe / w, ys / h);
            vertices[1] = vertices[1].nauv(xs / w, ys / h);
            vertices[2] = vertices[2].nauv(xs / w, ye / h);
            vertices[3] = vertices[3].nauv(xe / w, ye / h);
        } else if (cuv.length == 2) {
            float xs = tu + cuv[0];
            float xe = tu + cuv[0] + ex;
            float ys = tv + cuv[1];
            float ye = tv + cuv[1] + ey;
            vertices[0] = vertices[0].nauv(xe / w, ys / h);
            vertices[1] = vertices[1].nauv(xs / w, ys / h);
            vertices[2] = vertices[2].nauv(xs / w, ye / h);
            vertices[3] = vertices[3].nauv(xe / w, ye / h);
        } else if (cuv.length == 4) {
            float xs = tu + cuv[0];
            float xe = tu + cuv[2];
            float ys = tv + cuv[1];
            float ye = tv + cuv[3];
            vertices[0] = vertices[0].nauv(xe / w, ys / h);
            vertices[1] = vertices[1].nauv(xs / w, ys / h);
            vertices[2] = vertices[2].nauv(xs / w, ye / h);
            vertices[3] = vertices[3].nauv(xe / w, ye / h);
        } else if (cuv.length == 8) {
            vertices[0] = vertices[0].nauv((tu + cuv[0]) / w, (tv + cuv[1]) / h);
            vertices[1] = vertices[1].nauv((tu + cuv[2]) / w, (tv + cuv[3]) / h);
            vertices[2] = vertices[2].nauv((tu + cuv[4]) / w, (tv + cuv[5]) / h);
            vertices[3] = vertices[3].nauv((tu + cuv[6]) / w, (tv + cuv[7]) / h);
        }
        return new Polygon(vertices);
    }
}

