/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.frl.gen;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Vec3f;

public class Path {
    public Vec3f start;
    public Vec3f end;
    public Vec3f[] rootpath;
    public Vec3f[] vecpath;
    public float length;
    public int segmentator = 4;

    public Path(Vec3f[] vec316fs, Vec3f vector) {
        this.start = vec316fs[0];
        this.end = vector;
        this.rootpath = new Vec3f[vec316fs.length + 1];
        for (int i = 0; i < this.rootpath.length - 1; ++i) {
            this.rootpath[i] = vec316fs[i].copy();
        }
        this.rootpath[this.rootpath.length - 1] = vector.copy();
        this.construct();
    }

    public Path(Vec3f[] vec316fs) {
        this.start = vec316fs[0];
        this.end = vec316fs[vec316fs.length - 1];
        this.rootpath = new Vec3f[vec316fs.length];
        for (int i = 0; i < this.rootpath.length; ++i) {
            this.rootpath[i] = vec316fs[i].copy();
        }
        this.construct();
    }

    public Path() {
    }

    protected void construct() {
        this.vecpath = new Vec3f[this.rootpath.length];
        if (this.vecpath.length == 2) {
            this.vecpath[0] = this.rootpath[0];
            this.vecpath[1] = this.rootpath[this.rootpath.length - 1];
            this.length = this.vecpath[0].dis(this.vecpath[1]);
        } else {
            for (int i = 0; i < this.rootpath.length; ++i) {
                this.vecpath[i] = this.rootpath[i];
            }
            Vec3f[] vecs = this.curve(this.vecpath);
            this.vecpath = new Vec3f[vecs.length + 2];
            this.vecpath[0] = new Vec3f(this.start);
            for (int i = 0; i < vecs.length; ++i) {
                this.vecpath[i + 1] = vecs[i];
            }
            this.vecpath[this.vecpath.length - 1] = new Vec3f(this.end);
            this.length = this.calcLength();
        }
    }

    private Vec3f[] curve(Vec3f[] vecpoints) {
        ArrayList<Vec3f> vecs = new ArrayList<Vec3f>();
        float length = this.getLength(vecpoints);
        float increment = 1.0f / length / (float)this.segmentator;
        double d = 0.0;
        while (d < 1.0) {
            Vec3f[] moved = vecpoints;
            while (moved.length > 2) {
                Vec3f[] arr = new Vec3f[moved.length - 1];
                for (int i = 0; i < moved.length - 1; ++i) {
                    arr[i] = Path.move(moved[i], moved[i + 1], (double)moved[i].dis(moved[i + 1]) * d);
                }
                moved = arr;
            }
            vecs.add(Path.move(moved[0], moved[1], (double)moved[0].dis(moved[1]) * (d += (double)increment)));
        }
        return vecs.toArray(new Vec3f[0]);
    }

    public static Vec3f move(Vec3f vec0, Vec3f vec1, double dis) {
        double[] dest = Path.newVector(vec1);
        double[] beg = Path.newVector(vec0);
        dest = Path.direction(dest[0] - beg[0], dest[1] - beg[1], dest[2] - beg[2]);
        dest = Path.newVector(beg[0] + dest[0] * dis, beg[1] + dest[1] * dis, beg[2] + dest[2] * dis);
        return new Vec3f(dest[0], dest[1], dest[2]);
    }

    public static double[] newVector(double x, double y, double z) {
        return new double[]{x, y, z};
    }

    public static double length(double ... arr) {
        return Math.sqrt(arr[0] * arr[0] + arr[1] * arr[1] + arr[2] * arr[2]);
    }

    public static double distance(double[] first, double[] second) {
        return Path.length(second[0] - first[0], second[1] - first[1], second[2] - first[2]);
    }

    public static double[] direction(double ... arr) {
        double l = Path.length(arr[0], arr[1], arr[2]);
        return new double[]{arr[0] / l, arr[1] / l, arr[2] / l};
    }

    public static double[] newVector(Vec3f vec) {
        return new double[]{vec.x, vec.y, vec.z};
    }

    public float getLength(Vec3f[] vecs) {
        vecs = vecs == null ? this.vecpath : vecs;
        float temp = 0.0f;
        for (int i = 0; i < vecs.length - 1; ++i) {
            temp += vecs[i].dis(vecs[i + 1]);
        }
        return temp;
    }

    protected float calcLength() {
        return this.getLength(null);
    }

    public Path read(JsonMap map) {
        JsonArray arr = map.getArray("start");
        this.start = new Vec3f(arr.get(0).float_value(), arr.get(1).float_value(), arr.get(2).float_value());
        arr = map.getArray("end");
        this.end = new Vec3f(arr.get(0).float_value(), arr.get(1).float_value(), arr.get(2).float_value());
        arr = map.getArray("vectors");
        this.rootpath = new Vec3f[((List)arr.value).size()];
        int[] idx = new int[]{0};
        ((List)arr.value).forEach(entry -> {
            JsonArray array = entry.asArray();
            int n = idx[0];
            idx[0] = n + 1;
            this.rootpath[n] = new Vec3f(array.get(0).float_value(), array.get(1).float_value(), array.get(2).float_value());
        });
        this.construct();
        this.length = map.has("length") ? map.getFloat("length", 0.0f) : this.calcLength();
        return this;
    }

    public JsonMap write(JsonMap map) {
        JsonArray arr = new JsonArray();
        arr.add(this.start.x);
        arr.add(this.start.y);
        arr.add(this.start.z);
        map.add("start", arr);
        arr = new JsonArray();
        arr.add(this.end.x);
        arr.add(this.end.y);
        arr.add(this.end.z);
        map.add("end", arr);
        JsonArray array = new JsonArray();
        for (Vec3f vec : this.rootpath) {
            arr = new JsonArray();
            arr.add(vec.x);
            arr.add(vec.y);
            arr.add(vec.z);
            array.add(arr);
        }
        map.add("vectors", array);
        map.add("length", this.length);
        return map;
    }

    public Vec3f getFirstVector() {
        return this.vecpath.length == 0 ? null : this.vecpath[0];
    }

    public Vec3f getLastVector() {
        return this.vecpath.length == 0 ? null : this.vecpath[this.vecpath.length - 1];
    }

    public <T extends Path> T createOpposite(T instance) {
        instance.start = this.end;
        instance.end = this.start;
        instance.rootpath = new Vec3f[this.rootpath.length];
        int j = this.rootpath.length - 1;
        for (int i = 0; i < instance.rootpath.length; ++i) {
            instance.rootpath[i] = this.rootpath[j--].copy();
        }
        instance.construct();
        instance.length = instance.calcLength();
        return instance;
    }

    public float[] getPosition(float distance) {
        if (distance >= this.length) {
            if (distance == this.length) {
                this.vecpath[this.vecpath.length - 1].toFloatArray();
            }
            return new float[]{distance - this.length};
        }
        float traveled = 0.0f;
        for (int i = 0; i < this.vecpath.length - 1; ++i) {
            float multi = this.vecpath[i].dis(this.vecpath[i + 1]);
            float temp = traveled + multi;
            if (temp >= distance) {
                if (temp == distance) {
                    return this.vecpath[i + 1].toFloatArray();
                }
                return this.vecpath[i + 1].distance(this.vecpath[i], temp - distance).toFloatArray();
            }
            traveled += multi;
        }
        return this.vecpath[0].toFloatArray();
    }

    public Vec3f getVectorPosition(float distance, boolean reverse) {
        if (reverse) {
            distance = this.oppositePassed(distance);
        }
        if (distance >= this.length) {
            return new Vec3f(this.vecpath[this.vecpath.length - 1]);
        }
        float traveled = 0.0f;
        for (int i = 0; i < this.vecpath.length - 1; ++i) {
            float multi = this.vecpath[i].dis(this.vecpath[i + 1]);
            float temp = traveled + multi;
            if (temp >= distance) {
                if (temp == distance) {
                    return new Vec3f(this.vecpath[i + 1]);
                }
                return this.vecpath[i + 1].distance(this.vecpath[i], temp - distance);
            }
            traveled += multi;
        }
        return new Vec3f(this.vecpath[0]);
    }

    public String toString() {
        return String.format("Path[%s-%s, %s]", this.start, this.end, this.vecpath.length);
    }

    public float oppositePassed(float sec) {
        return sec >= this.length ? 0.0f : (sec <= 0.0f ? this.length : this.length - sec);
    }
}

