/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.scr;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.lib.scr.ScriptElm;

public class ScriptBlock {
    public HashMap<String, ScriptElm> local = new LinkedHashMap<String, ScriptElm>();
    public final String[] parameters;

    public ScriptBlock(String[] params) {
        this.parameters = params;
    }

    public String print(int depth) {
        StringBuffer buffer = new StringBuffer();
        String tab = this.depth(depth);
        String tac = tab + "    ";
        buffer.append(tab + this.print_name());
        if (this.parameters.length > 0) {
            buffer.append("(");
            for (int idx = 0; idx < this.parameters.length; ++idx) {
                buffer.append(this.parameters[idx]);
                if (idx >= this.parameters.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("){\n");
        } else {
            buffer.append("(){\n");
        }
        for (Map.Entry<String, ScriptElm> entry : this.local.entrySet()) {
            buffer.append(tac + String.valueOf((Object)entry.getValue().scr_type()) + " " + entry.getKey());
            buffer.append((String)(entry.getValue().scr_str().length() == 0 ? "\n" : " = " + entry.getValue().scr_str() + "\n"));
        }
        if (this.local.size() > 0) {
            buffer.append("\n");
        }
        buffer.append(tab + "}\n");
        return buffer.toString();
    }

    public String print_name() {
        return "";
    }

    private String depth(int depth) {
        StringBuffer buffer = new StringBuffer();
        while (depth > 0) {
            buffer.append("    ");
            --depth;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.print(0);
    }
}

