/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.lib.scr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.fexcraft.lib.common.utils.Print;
import net.fexcraft.lib.scr.Script;
import net.fexcraft.lib.scr.ScriptAction;
import net.fexcraft.lib.scr.ScriptBlock;
import net.fexcraft.lib.scr.ScriptElm;
import net.fexcraft.lib.scr.elm.BoolElm;
import net.fexcraft.lib.scr.elm.FltElm;
import net.fexcraft.lib.scr.elm.IntElm;
import net.fexcraft.lib.scr.elm.ListElm;
import net.fexcraft.lib.scr.elm.MapElm;
import net.fexcraft.lib.scr.elm.StrElm;

public class ScriptParser {
    public static final boolean LOG = true;

    public static Script parse(String scr_name, InputStream stream) {
        Script scr = new Script(scr_name);
        ISW isw = new ISW(stream);
        try {
            isw.next();
            while (isw.has()) {
                isw.skipw();
                if (isw.starts('r') && ScriptParser.found(isw, "requires")) {
                    scr.deps.add(isw.till_end());
                    continue;
                }
                if (isw.starts('i') && ScriptParser.found(isw, "int")) {
                    ScriptParser.parseInt(isw, (key, elm) -> scr.global.put((String)key, (ScriptElm)elm));
                    continue;
                }
                if (isw.starts('f') && ScriptParser.found(isw, "flt")) {
                    ScriptParser.parseFlt(isw, (key, elm) -> scr.global.put((String)key, (ScriptElm)elm));
                    continue;
                }
                if (isw.starts('s') && ScriptParser.found(isw, "str")) {
                    ScriptParser.parseStr(isw, (key, elm) -> scr.global.put((String)key, (ScriptElm)elm));
                    continue;
                }
                if (isw.starts('b') && ScriptParser.found(isw, "bln")) {
                    ScriptParser.parseBln(isw, (key, elm) -> scr.global.put((String)key, (ScriptElm)elm));
                    continue;
                }
                if (isw.starts('m') && ScriptParser.found(isw, "map")) {
                    ScriptParser.parseMap(isw, (key, elm) -> scr.global.put((String)key, (ScriptElm)elm));
                    continue;
                }
                if (isw.starts('l') && ScriptParser.found(isw, "lst")) {
                    ScriptParser.parseList(isw, (key, elm) -> scr.global.put((String)key, (ScriptElm)elm));
                    continue;
                }
                if (isw.starts('a') && ScriptParser.found(isw, "act")) {
                    String name = isw.till('(');
                    ArrayList<String> parms = new ArrayList<String>();
                    int line = isw.linenum;
                    while (isw.linenum == line) {
                        String par = isw.till(',', ')').trim();
                        if (par.length() <= 0) continue;
                        parms.add(par);
                    }
                    scr.actions.put(name, new ScriptAction(name, parms.toArray(new String[0])));
                    ScriptParser.parseBlock(isw, scr, null, scr.actions.get(name));
                    continue;
                }
                isw.nextline();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return scr;
    }

    private static void parseInt(ISW isw, BiConsumer<String, ScriptElm> cons) throws IOException {
        String key = isw.till_space();
        IntElm elm = null;
        isw.skipw();
        if (isw.starts('=')) {
            isw.next();
            isw.skipw();
            boolean hex = isw.starts('#');
            if (hex) {
                isw.next();
            }
            int num = isw.linenum;
            String val = isw.till_end();
            try {
                elm = new IntElm(Integer.parseInt(val, hex ? 16 : 10));
            }
            catch (Exception e) {
                Print.console(">>> Failed to parse integer element value at line '" + num + "'!");
                e.printStackTrace();
            }
        }
        if (elm == null) {
            elm = new IntElm(0);
        }
        cons.accept(key, elm);
    }

    private static void parseFlt(ISW isw, BiConsumer<String, ScriptElm> cons) throws IOException {
        String key = isw.till_space();
        FltElm elm = null;
        isw.skipw();
        if (isw.starts('=')) {
            isw.next();
            isw.skipw();
            int num = isw.linenum;
            String val = isw.till_end();
            try {
                elm = new FltElm(Float.parseFloat(val));
            }
            catch (Exception e) {
                Print.console(">>> Failed to parse float element value at line '" + num + "'!");
                e.printStackTrace();
            }
        }
        if (elm == null) {
            elm = new FltElm(0.0f);
        }
        cons.accept(key, elm);
    }

    private static void parseStr(ISW isw, BiConsumer<String, ScriptElm> cons) throws IOException {
        String key = isw.till_space();
        StrElm elm = new StrElm("");
        isw.skipw();
        if (isw.starts('=')) {
            isw.next();
            isw.skipw();
            elm.scr_set(isw.till_str().trim());
        }
        cons.accept(key, elm);
    }

    private static void parseBln(ISW isw, BiConsumer<String, ScriptElm> cons) throws IOException {
        String key = isw.till_space();
        BoolElm elm = new BoolElm(false);
        isw.skipw();
        if (isw.starts('=')) {
            isw.next();
            isw.skipw();
            elm.scr_set(Boolean.parseBoolean(isw.till_end().trim()));
        }
        cons.accept(key, elm);
    }

    private static void parseMap(ISW isw, BiConsumer<String, ScriptElm> cons) throws IOException {
        String key = isw.till_space();
        MapElm elm = null;
        isw.skipw();
        if (isw.starts('=')) {
            isw.next();
            isw.skipw();
            elm = new MapElm(isw.till_end().trim());
        }
        cons.accept(key, elm == null ? new MapElm() : elm);
    }

    private static void parseList(ISW isw, BiConsumer<String, ScriptElm> cons) throws IOException {
        String key = isw.till_space();
        isw.nextline();
        cons.accept(key, new ListElm());
    }

    private static void parseBlock(ISW isw, Script scr, ScriptBlock root, ScriptBlock block) throws IOException {
        while (isw.has()) {
            int line = isw.linenum;
            isw.skipw();
            if (isw.starts(';') && ScriptParser.found(isw, ";;")) break;
            if (isw.starts('i')) {
                isw.next();
                if (isw.starts('f')) {
                    isw.next();
                    if (isw.starts('(')) {
                        isw.nextline();
                        continue;
                    }
                    Print.console(">>> Incomplete or invalid 'if' at line '" + line + "'!");
                    isw.nextline();
                    continue;
                }
                if (isw.starts('n') && ScriptParser.found(isw, "nt")) {
                    ScriptParser.parseInt(isw, (key, elm) -> block.local.put((String)key, (ScriptElm)elm));
                    continue;
                }
                Print.console(">>> Unknown code at line '" + isw.linenum + "', expected 'if' or 'int'.");
                Print.console(">>> Found: " + isw.line + " <-- ");
                isw.nextline();
                continue;
            }
            if (isw.starts('f') && ScriptParser.found(isw, "flt")) {
                ScriptParser.parseFlt(isw, (key, elm) -> block.local.put((String)key, (ScriptElm)elm));
                continue;
            }
            if (isw.starts('s') && ScriptParser.found(isw, "str")) {
                ScriptParser.parseStr(isw, (key, elm) -> block.local.put((String)key, (ScriptElm)elm));
                continue;
            }
            if (isw.starts('b') && ScriptParser.found(isw, "bln")) {
                ScriptParser.parseBln(isw, (key, elm) -> block.local.put((String)key, (ScriptElm)elm));
                continue;
            }
            if (isw.starts('m') && ScriptParser.found(isw, "map")) {
                ScriptParser.parseMap(isw, (key, elm) -> block.local.put((String)key, (ScriptElm)elm));
                continue;
            }
            if (isw.starts('l') && ScriptParser.found(isw, "lst")) {
                ScriptParser.parseList(isw, (key, elm) -> block.local.put((String)key, (ScriptElm)elm));
                continue;
            }
            if (isw.starts('e') && ScriptParser.found(isw, "else")) {
                if (isw.starts('i') && ScriptParser.found(isw, "if")) {
                    if (isw.starts('(')) {
                        isw.nextline();
                        continue;
                    }
                    Print.console(">>> Incomplete or invalid 'elseif' at line '" + line + "'!");
                    isw.nextline();
                    continue;
                }
                isw.nextline();
                continue;
            }
            isw.nextline();
        }
    }

    private static boolean found(ISW isw, String str) throws IOException {
        if (isw.skip(str)) {
            return true;
        }
        Print.console(">>> Unknown code at line '" + isw.linenum + "', expected '" + str + "'.");
        Print.console(">>> Found: " + isw.line + " <-- ");
        isw.nextline();
        return false;
    }

    public static class ISW {
        protected InputStreamReader stream;
        protected char cher;
        protected boolean has = true;
        protected int linenum;
        protected String line = new String();

        public ISW(InputStream stream) {
            this.stream = new InputStreamReader(stream, StandardCharsets.UTF_8);
        }

        public boolean starts(char c) throws IOException {
            return this.cher == c;
        }

        private boolean next() throws IOException {
            int i = this.stream.read();
            if (i < 0) {
                this.has = false;
                return true;
            }
            this.cher = (char)i;
            if (this.cher == '\r') {
                return this.next();
            }
            if (this.cher == '\n') {
                System.out.println(this.linenum + ": " + this.line);
                ++this.linenum;
                this.line = "";
                return true;
            }
            if (this.cher >= ' ') {
                this.line = this.line + this.cher;
            }
            return false;
        }

        private void nextline() throws IOException {
            int line = this.linenum;
            while (this.has && line == this.linenum) {
                this.next();
            }
        }

        public boolean has() {
            return this.has;
        }

        public void skipw() throws IOException {
            if (this.has && this.cher <= ' ') {
                this.next();
                this.skipw();
            }
        }

        public boolean skip(String sec) throws IOException {
            char[] chars = sec.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (!this.has || this.cher != chars[i]) {
                    return false;
                }
                this.next();
            }
            this.skipw();
            return true;
        }

        public String till_str() throws IOException {
            StringBuffer buffer = new StringBuffer();
            if (this.cher == '\"') {
                this.next();
            }
            int last = 32;
            while (this.has && (this.cher != '\"' || last == 92)) {
                char c = this.cher;
                last = c;
                buffer.append(c);
                if (!this.next()) continue;
                break;
            }
            return buffer.toString();
        }

        public String till_space() throws IOException {
            StringBuffer buffer = new StringBuffer();
            while (this.has && this.cher > ' ') {
                buffer.append(this.cher);
                if (!this.next()) continue;
                break;
            }
            return buffer.toString();
        }

        public String till_end() throws IOException {
            StringBuffer buffer = new StringBuffer();
            while (this.has) {
                buffer.append(this.cher);
                if (!this.next()) continue;
                break;
            }
            return buffer.toString();
        }

        public String till(char c) throws IOException {
            StringBuffer buffer = new StringBuffer();
            while (this.has && this.cher != c) {
                buffer.append(this.cher);
                this.next();
            }
            this.next();
            return buffer.toString();
        }

        public String till(char c, char h) throws IOException {
            StringBuffer buffer = new StringBuffer();
            while (this.has && this.cher != c && this.cher != h) {
                buffer.append(this.cher);
                if (!this.next()) continue;
            }
            this.next();
            return buffer.toString();
        }
    }
}

